from django.shortcuts import render, redirect
from django.contrib import messages
from .forms import ( MSTaskForm,
                    OutletsTaskForm)
from .models import ( ms,
                        outlets)
from motionsensor.models import MotionSensor
from firedetector.models import FireDetector
from outlets.models import Outlets
from .tasks import ( schedule_ms,
                        schedule_outlets_on,
                        schedule_outlets_off,
                        schedule_outlets_toggle)
from background_task.models import Task

def device_selection(request):
    return render(request, 'tasks/device_selection.html')

def tasks_index(request):
    """Tasks Index"""
    
    # List of Tasks
    task_list = Task.objects.filter(creator_object_id=request.user.id)

    return render(request, 'tasks/index.html', {'task_list': task_list})

def task_ms(request):
    """Create MS Task View"""
    
    if request.method == 'POST':
        form = MSTaskForm(request.user, request.POST or None)

        if form.is_valid():
            device = form.save(commit=False)
            device.related_sn = MotionSensor.objects.get(owner=request.user)
            schedule_ms(device.related_sn.sn, device.outlet_sn.sn, verbose_name="Toggle Switch With Motion Sensor", schedule=device.run_on, creator=request.user)
            messages.success(request, 'Task Successfully Created.')
            form.save()
            return redirect('tasks_index')

    else:
        form = MSTaskForm(request.user)
        context = { 
            'form' : form,
        }
        return render(request, 'tasks/ms.html', context)

def task_outlets(request):
    """Create Outlet Task View"""

    if request.method == 'POST':
        form = OutletsTaskForm(request.user, request.POST or None)

        if form.is_valid():
            device = form.save(commit=False)
            if device.action == 'Toggle':
                schedule_outlets_toggle(device.related_sn.sn, verbose_name="Toggle Outlet", schedule=device.run_on, creator=request.user)
            elif device.action == 'Turn On':
                schedule_outlets_on(device.related_sn.sn, verbose_name="Turn Outlet On", schedule=device.run_on, creator=request.user)
            else:
                schedule_outlets_off(device.related_sn.sn, verbose_name="Turn Outlet Off", schedule=device.run_on, creator=request.user)
            form.save()
            messages.success(request, 'Task Successfully Created.')
            return redirect('tasks_index')

    else:
        form = OutletsTaskForm(request.user)
        context = { 
            'form' : form,
        }
        return render(request, 'tasks/outlets.html', context)