# Group 14 - EEL 4914/5 - Senior Design Summer/Fall 19
## Software for home automation system local hub
## Project Description
This repository contains the scripts required to run the client-side networking hub which coordinates communication between smart home automation system modules and the webserver.

## How to build this project
Python 2.7 is required to run this program. Also note that this project requires that an MQTT broker be running locally in order to function properly. To install dependencies, run:
```
pip install -r requirements.txt
```

Then, run the command

```
python main.py
```

To run the  script.

## Configuration
The files 'mqtt.conf' and 'hub.conf' can be used to configure the behavior of the hub.

### mqtt.conf
- broker: The IP Address of the MQTT broker.
- port: The port used to connect to the MQTT broker.
- listenTopic: The topic string which the MQTT client listens on.
- keepalive: The MQTT keepalive period.
- username: The username used when connecting to the MQTT broker.
- password: The password used when connecting to the MQTT broker.

### hub.conf
- refreshTime: The interval at which the hub polls the server and updates the database with new module states (in seconds). Lower numbers will mean more frequent updates.
- ownerID: The ownerID used to relate the hub device with a specific user account in the database.
- sleepTime: Time for which the main thread should sleep after each iteration of the main polling loop (to reduce CPU usage). Also in seconds.
