import files
import pymongo 
import json
import model
import tasks

def init():
    
    global db
    global client
    client = pymongo.MongoClient("mongodb+srv://shared:MyMongoPassword@shared-dev-vhsyp.mongodb.net/test?retryWrites=true&w=majority")
    db = client.djongo_test

def disconnect():
    pass
#    client.close()

def selectCollection(dev):
    if dev["deviceType"] == "Outlet":
        collection = db.outlets_outlets
    elif dev["deviceType"] == "HVAC":
        collection = db.hvac_hvac
    elif dev["deviceType"] == "Lights":
        collection = db.lights_lights
    elif dev["deviceType"] == "Sensor":
        collection = db.motionsensor_motionsensor
    elif dev["deviceType"] == "FireDetector":
        collection = db.firedetector_firedetector

    return collection

def addDevice(dev):
    collection = selectCollection(dev)
    collection.insert_one(dev)

def isInDB(dev):
    collection = selectCollection(dev)
    if collection.find_one({"sn": dev["sn"]}) == None:
        return False
    else:
        return True

def updateDevice(dev):

    if isInDB(dev):
        if dev["deviceType"] != "Outlet" and dev["deviceType"] != "Lights":
            collection = selectCollection(dev)
            if dev["deviceType"] == "HVAC":
                collection.update_one({"sn": dev["sn"]}, {"$set": {"temperature": dev["temperature"], "humidity": dev["humidity"], "on": dev["on"]}})
            else:
                collection.find_one_and_update({"sn": dev["sn"]}, {"$set": dev})
            
def getDevsByOwnerID(owner):
    for x in db.hvac_hvac.find({"owner_id": owner}):
        model.createHVAC(x["sn"], x["temperature"], x["owner_id"])
    for x in db.lights_lights.find({"owner_id": owner}):
        model.createLight(x["sn"], x["status"], x["pin"], x["owner_id"])
    for x in db.motionsensor_motionsensor.find({"owner_id": owner}):
        model.createMotionSensor(x["sn"], x["status"], x["pin"], x["owner_id"])
    for x in db.outlets_outlets.find({"owner_id": owner}):
        model.createOutlet(x["sn"], x["status"], x["owner_id"])
    for x in db.firedetector_firedetector.find({"owner_id": owner}):
        model.createFiredetector(x["sn"], x["pin"], owner)

#def getTasksByOwnerID(owner):
    tasks.setMSTasks(db.tasks_ms.find({"owner_id": owner}))
    tasks.setOutletsTasks(db.tasks_outlets.find({"owner_id": owner}))
    tasks.setLightsTasks(db.tasks_lights.find({"owner_id": owner}))
def syncDevice(dev):

    collection = selectCollection(dev)
    result = collection.find_one({"sn": dev["sn"]})

    if result == None:
        # no matching device in database to sync with.
        return

    if dev != result:
        if dev["deviceType"] == "Outlet":
            if model.notRelated(dev):
                dev.update(result)
                model.sendStatus(dev)
        else:
           dev.update(result) 
           model.sendStatus(dev)
