import model
import sys
import mqttClient
import database
import time
import files
import tasks
import datetime
import RPi.GPIO as GPIO

def parseMessage(mqttMessage):
    global ownerID
    print mqttMessage
    strings = mqttMessage.split()

    if len(strings) < 2: # Strings of size less than two words considered malformed and are discarded
        return

    stringIndex = 0
    stringTuples = []
    for string in strings: # first two entries will be device ID and device type
        if len(strings) > (stringIndex+1):
            stringTuples.append((string,strings[stringIndex+1]))
            stringIndex = stringIndex + 2

    #Discard any messages that do not have an integer as their second element.
    try:
        targetDevice = model.getDeviceByID(int(stringTuples[0][1]))
    except:
        return

    if targetDevice != None:
        # do things related to device that we already know exists    
        model.mqttUpdate(targetDevice, strings)
        database.updateDevice(targetDevice)
        pass
    else:
        # new device, need to register and place in devices list before information can be stored
        deviceType = stringTuples[0][0]
        deviceID = int(stringTuples[0][1])
        newDevice = None
        if deviceType == "Outlet":
            model.createOutlet(deviceID, 0, ownerID)
        elif deviceType == "HVAC":
            newDevice = model.createHVAC(deviceID, 0, ownerID) 
            #print ("HVAC device added to devices list. Device ID: ", deviceID)
        elif deviceType == "Light":
            newDevice = model.createLight(deviceID, 0, 0, ownerID)
        elif deviceType == "Fire_Detector":
            newDevice = model.createFiredetector(deviceID, 0, ownerID)
        elif deviceType == "Motion_Sensor":
           newDevice = model.createMotionSensor(deviceID, 0, 0, ownerID)
        elif deviceType == "SWITCH" or deviceType == "OUTLET":
            newDevice = model.createOutlet(deviceID, 0, ownerID)

#        if not database.isInDB(newDevice):
#            database.addDevice(newDevice)

def sensorTimeout():

    try:
        currentTime = datetime.datetime.utcnow()
        for device in model.devicesList:
            if device["deviceType"] == "Sensor":
                if (currentTime - device["time_triggered"]) > datetime.timedelta(seconds = device["timeout"]):
                    device["status"] = "No Activity"
            elif device["deviceType"] == "FireDetector":
                if (currentTime - device["time_triggered"]) > datetime.timedelta(seconds = 2):
                    device["status"] = "Ok"

            database.updateDevice(device)

    except:
        pass

def GPIOUpdate(dev):
    devType = dev["deviceType"]

    if devType == "Lights":
        GPIO.setup(dev["pin"], GPIO.OUT)
        if dev["status"] == 1:
            GPIO.output(dev["pin"], 1)
        else:
            GPIO.output(dev["pin"], 0)
    elif devType == "Sensor":
        GPIO.setup(dev["pin"], GPIO.IN)
        if GPIO.Input(dev["pin"]):
            dev["status"] = "Activity Detected"
        else:
            dev["status"] = "No Activity"
    elif devType == "FireDetector":
        GPIO.setup(dev["pin"], GPIO.IN)
        if GPIO.Input:
            dev["status"] = "Ok"
        else:
            dev["status"] = "Fire Hazard Detected"


global ownerID
configOptions = files.readConfig("hub.conf")
ownerID = int(configOptions["ownerID"])
previousTime = time.time()
mqttClient.init()
print "Connecting to database."

tryConnection = True

GPIO.setmode(GPIO.BOARD)

while tryConnection:
    try:
        database.init()
        tryConnection = False
    except KeyboardInterrupt:
        sys.exit()
    except:
        print "database connection failed, retrying"
        time.sleep(1)

print "Connected to database."

#Initial load of all devices previously registered in the database.
database.getDevsByOwnerID(ownerID)

try:
    while True:
        currentTime = time.time()

        # Perform DB synchronization
        # Values in database get precedence and are written to model first,
        # Then MQTT messages are read, and then local state is written back.
        if (currentTime - previousTime) >= int(configOptions["refreshTime"]):
            previousTime = currentTime

            for device in model.devicesList:
                database.getDevsByOwnerID(ownerID) # Get new devices
                database.syncDevice(device) # Update existent devices 

                if "pin" in device:
                    if device["pin"] != 0 or device["pin"] != 30:
                        pass
                        #GPIOUpdate(device)

            for message in mqttClient.mqttMessages.getMessages():
                parseMessage(message)

            sensorTimeout()
#            for device in model.devicesList:
#                database.updateDevice(device) # Update DB to reflect changes made by MQTT messages

        # Run automation and scheduling tasks based on current state of system.
        tasks.runTasks()

        time.sleep(float(configOptions["sleepTime"]))
except KeyboardInterrupt:
    print "Exiting."
    database.disconnect()
    mqttClient.disconnect()
