import mqttClient
import datetime
import database

devicesList = []

def getDeviceByID(identifier):
    for device in devicesList:
        if device["sn"] == identifier:
            return device
    return None

def getDevicesByType(typeString):
    tempList = []
    for device in devicesList:
        if device["deviceType"] == typeString:
            tempList.append(device)
    return tempList


def deleteDeviceByID(idNumber):
    for device in devicesList:
        if device["sn"] == idNumber:
            devicesList.remove(device)


def addDeviceToList(device):
    if getDeviceByID(device["sn"]) == None:
        devicesList.append(device)
        print "Device with ID ", device["sn"], " registered."
    else:
        #print "Duplicate device ID", device["sn"], " detected, device was not registered."
        pass



# Creation of dictionary representations of device status.
# In the case of devices with a pin argument, a pin of '0' will denote that the device is networked
# and not connected to a pin.
def createHVAC(sn, temperature, owner_id):
    newHVAC = {
            "sn": sn,
            "setTemperature": 0,
            "humidity": 0,
            "cooling": 0,
            "on": 0,
            "deviceType": "HVAC",
            "temperature": temperature,
            "owner_id": owner_id
            }
    addDeviceToList(newHVAC)
    return newHVAC


def createLight(sn, status, pin, owner_id):
    newLight = {
            "owner_id" : owner_id,
            "sn": sn,
            "status": status,
            "pin": pin,
            "deviceType": "Lights"
            }
    addDeviceToList(newLight)
    return newLight


def createOutlet(sn, toggleStatus, owner_id):
    newOutlet = {
            "sn": sn,
            "status": toggleStatus,
            "owner_id": owner_id,
            "location": "Room", 
            "deviceType": "Outlet"
            }
    addDeviceToList(newOutlet)
    return newOutlet

def notRelated(dev):
    for x in devicesList:
        if x["deviceType"] == "Sensor":
            if x["light_rel_id"] != None:
                if x["light_rel_id"] == dev["sn"]:
                    return False
    return True


def createMotionSensor(sn, triggered, pin, owner_id):
    newMotionSensor = {
            "sn": sn,
            "owner_id" : owner_id,
            "status" : triggered,
            "pin" : pin,
            "deviceType" : "Sensor",
            "light_rel_id": 0,
            "timeout": 5,
            "time_triggered": None 

            }
    addDeviceToList(newMotionSensor)
    return newMotionSensor

def createFiredetector(sn, pin, owner_id):
    newFiredetector = {
            "sn": sn,
            "owner_id": owner_id,
            "status": "Ok",
            "pin": pin,
            "deviceType": "FireDetector",
            "time_triggered": None,
            "location": "Room"
            }
    addDeviceToList(newFiredetector)
    return newFiredetector


def updateHVAC(deviceDict, updateStrings): 
    if updateStrings[2] == "humidity":
        deviceDict["humidity"] = int(updateStrings[3])
    elif updateStrings[2] == "temperature":
        deviceDict["temperature"] = int(updateStrings[3])
    elif updateStrings[2] == "setTemperature":
        deviceDict["setTemperature"] = int(updateStrings[3])
    elif updateStrings[2] == "cooling":
        deviceDict["cooling"] = int(updateStrings[3])
    elif updateStrings[2] == "on":
        deviceDict["on"] = int(updateStrings[3])

def updateMotionSensor(deviceDict, updateStrings):
    if updateStrings[2] == "status":
        statusString = updateStrings[3] + " " + updateStrings[4]
        if statusString == "Activity Detected":
            deviceDict["status"] = (updateStrings[3] + " " + updateStrings[4])
            deviceDict["time_triggered"] = datetime.datetime.utcnow()
        else:
            deviceDict["status"] = "No Activity"

def updateFireDetector(deviceDict, updateStrings):
    statusString = updateStrings[3] + " " + updateStrings[4]
    if updateStrings[2] == "status":
        if statusString == "Heat Detected":
            deviceDict["status"] = "Fire Hazard Detected"
            deviceDict["time_triggered"] = datetime.datetime.utcnow()

def updateOutlet(deviceDict, updateStrings):
    if updateStrings[2] == "power":
        pass


def mqttUpdate(deviceDict, updateStrings):
    devType = deviceDict["deviceType"]
    if devType == "Sensor":
        updateMotionSensor(deviceDict, updateStrings)
    elif devType == "HVAC":
        updateHVAC(deviceDict, updateStrings)
    elif devType == "Outlet":
        updateOutlet(deviceDict, updateStrings)
    elif devType == "FireDetector":
        updateFireDetector(deviceDict, updateStrings)
    elif devType == "Lights":
        pass
    database.updateDevice(deviceDict)

def sendStatus(dev):
    devType = dev["deviceType"]
    if devType == "HVAC":
       mqttClient.send_message("devices/HVAC_Control", str(dev["sn"]) + " setTemp " + str(dev["setTemperature"]))
       mqttClient.send_message("devices/HVAC_Control", str(dev["sn"])+ " setCool " + str(dev["cooling"]))
       mqttClient.send_message("devices/HVAC_Control", str(dev["sn"]) + " setOn " + str(dev["on"]))
    elif devType == "Outlet":
        mqttClient.send_message("devices/Outlet_Control", str(dev["sn"]) + " toggle " + str(dev["status"]))
    elif devType == "Lights":
        mqttClient.send_message("devices/Outlet_Control", str(dev["sn"]) + " toggle " + str(dev["status"]))
