import paho.mqtt.client as mqtt
import threading
import files

# Use message handler for accessing message data to avoid potential race conditions
class messageHandler:
    def __init__(self):
        self.messages = []
        self._lock = threading.Lock()
        self.hasMessages = False

    def addMessage(self,message):
        with self._lock:
            self.messages.append(message)
            self.hasMessage
    # returns copy of messages and clears the message queue
    def getMessages(self): 
        with self._lock:
            self.hasMessages = False
            messagesCopy = self.messages[:] 
            self.messages = []
            return messagesCopy
#sendTopic = ""
listenTopic = ""
client = None
mqttMessages = messageHandler()


def on_connect(client, userdata, flags, rc):
    global listenTopic
    print("Connected to MQTT broker with result code " + str(rc))
    print("Connected to topic: " + listenTopic)
    client.subscribe(listenTopic)

def on_message(client, userdata, msg):
    global mqttMessages
    mqttMessages.addMessage(str(msg.payload))

def send_message(messageTopic, messageString):
    client.publish(messageTopic, messageString, 0, False)

def disconnect():
    client.disconnect()
    client.loop_stop()

def init():
    arguments = files.readConfig("mqtt.conf")
#    global sendTopic
    global listenTopic
    global client

    broker = arguments["broker"]
    port = int(arguments["port"])
    listenTopic = arguments["listenTopic"]
#    sendTopic = arguments["sendTopic"]
    keepalive = int(arguments["keepalive"])
    mqtt_username = arguments["username"]
    mqtt_password = arguments["password"]

    client = mqtt.Client(mqtt_username)
    client.username_pw_set(mqtt_username, mqtt_password)
    client.on_connect = on_connect
    client.on_message = on_message
    client.connect(broker,port,keepalive)
    # client loop is threaded to avoid blocking. 
    client.loop_start()


