import model
import datetime
import database
import mqttClient

msTasks = []
lightsTasks = []
outletsTasks = []

def setMSTasks(tasks):
    global msTasks
    msTasks = tasks 

def setLightsTasks(tasks):
    global lightsTasks
    lightsTasks = tasks

def setOutletsTasks(tasks):
    global outletsTasks 
    outletsTasks = tasks

def processMSRels():
    #Toggle device status based on relational identifiers
    for device in model.devicesList:
        if device["deviceType"] == "Sensor":
            motion = device["status"]
            relatedDevice = model.getDeviceByID(device["light_rel_id"]) 
            if relatedDevice != None:
                oldStatus = relatedDevice["status"]
                if relatedDevice["deviceType"] == "Outlet":
                    if motion == "No Activity":
                        relatedDevice["status"] = 0
                    elif motion == "Activity Detected":
                        relatedDevice["status"] = 1
                    mqttClient.send_message("devices/Outlet_Control", str(relatedDevice["sn"]) + " toggle " + str(relatedDevice["status"]))


def runTasks():
    global msTasks
    global lightsTasks
    global outletsTasks

    processMSRels()
    currentTime = datetime.datetime.utcnow()    

