/*
  Name:		Thermostat.ino
  Created:	10/21/2019 5:19:47 AM
  Author:	fxrev
*/

// the setup function runs once when you press reset or power the board
#include "PubSub.h"
#include "AmpSensor.h"


#define ACRelay1 D6

static String deviceType = "SWITCH";

std::string controllerID = "";

int toggleRelay = 1;

void setup() {

  // Begin Serial on 115200
  // Remember to choose the correct Baudrate on the Serial monitor!
  // This is just for debugging purposes
  Serial.begin(9600);


  pinMode(ACRelay1, OUTPUT);
  
  pubsubSetup();
}

volatile int counter = 0;

void loop() {
  pubsubLoop();

  uint intervalToSend = 10;
  counter++;

  if (updated) {
    handleCommand(ControllerId, Command, Data);
  }

  processAmps();
  
  if (counter % intervalToSend == 0) {
    sendData(deviceType+" "+ String(deviceId) + " power " + String(AmpsRMS*120));
  }

  if (updated) {
    handleCommand(ControllerId, Command, Data);
  }
}

void sendData(String str) {
  sendMessage(str);
}


void handleCommand(std::string id, std::string c, std::string dat) {
  String str = "";
  str += id.c_str();
  str += " ";
  str += c.c_str();
  str += " ";
  str += dat.c_str();
  Serial.println(str);

  if (strcmp(controllerID.c_str(), "") && strcmp(deviceId, id.c_str())) {
    controllerID = id;
    Serial.println("New Controller " + String(controllerID.c_str()));
  }
  if (!strcmp(controllerID.c_str(), "")) {
    auto com = (char*)c.c_str();
    int data = std::strtol((char*)dat.c_str(), nullptr, 10);
    if (compare(com, "toggle")) {
      toggleRelay ^= 1;
      digitalWrite(ACRelay1, toggleRelay);
    }
  }

  updated = false;

}
