import numpy as np
import networkx as nx
import matplotlib.pyplot as plt
import import_ipynb
from itertools import combinations
import pickle

File = 'C:/Users/lzy11/Desktop/11000_node_system/python/SystemY.txt'

###create_one
def create_phase1(File):
    miss_edge = [('HVMV_SUB_HSB.1','SOURCEBUS.1'),('HVMV_SUB_HSB.1', 'SOURCEBUS.1'),('REGXFMR_HVMV_SUB_LSB.1', '_HVMV_SUB_LSB.1'),('REGXFMR_HVMV_SUB_LSB.1', 'HVMV_SUB_HSB.1'),('HVMV_SUB_48332.1','_HVMV_SUB_LSB.1')]
    G = nx.Graph()
    with open(File) as file:
        lines = file.readlines()
        i = 0
        for line in lines:
            if line[0]=='N':
                i+=1
                temp = line.split(' ')
                temp = [item for item in temp if item!='']
                G.add_node(temp[2][5:].upper())
                G.add_node(temp[3][5:].upper())
                G.add_edge(temp[2][5:].upper(),temp[3][5:].upper())
    G.add_edge('REGXFMR_190-8593.1','190-8593.1')
    G.add_edge('REGXFMR_190-8581.1','190-8581.1')
    G.add_edge('REGXFMR_190-7361.1','190-7361.1')
    G.add_edges_from(miss_edge)
    G.remove_edge('181932.1', '236965.1')
    G.add_edge('SOURCEBUS.1','EPRI_CKT7.1')
    G.add_edge('EPRI_CKT7.1','CKT7.1')
    G.add_edge('CKT7.1','318412.1')
    # first subtree
    G_1 = nx.Graph()
    G.remove_edge('L3081380.1','M1142843.1')
    bfs = list(nx.bfs_edges(G,'L3081380.1'))
    #print(len(bfs))
    #print(bfs)
    G.add_edge('L3081380.1','M1142843.1')
    G_1.add_edges_from(bfs)
    #print(len(G_1.edges),len(G_1.nodes))
    #second subtree
    G_2 = nx.Graph()
    G.remove_edge('M1047515.1','M1047513.1')
    bfs = list(nx.bfs_edges(G,'M1047513.1'))
    #print(len(bfs))
    #print(bfs)
    G.add_edge('M1047515.1','M1047513.1')
    G_2.add_edges_from(bfs)
    #print(len(G_2.edges),len(G_2.nodes))
    # third subtree
    G_3 = nx.Graph()
    G.remove_edge('L3066815.1','196-29519.1')
    bfs = list(nx.bfs_edges(G,'L3066815.1'))
    #print(len(bfs))
    #print(bfs)
    G.add_edge('L3066815.1','196-29519.1')
    G_3.add_edges_from(bfs)
    #print(len(G_3.edges),len(G_3.nodes))
    # fourth subtree
    G_4 = nx.Graph()
    G.remove_edge('SOURCEBUS.1','EPRI_CKT7.1')
    bfs = list(nx.bfs_edges(G,'EPRI_CKT7.1'))
    G.add_edge('SOURCEBUS.1','EPRI_CKT7.1')
    G_4.add_edges_from(bfs)
    # main subtree
    G_main = nx.Graph()
    #for node in G.neighbors('196-29519.1'):
    #    print(node)
    G.remove_edge('SOURCEBUS.1','EPRI_CKT7.1')
    G.remove_edge('L3066815.1','196-29519.1')
    G.remove_edge('M1047515.1','M1047513.1')
    G.remove_edge('L3081380.1','M1142843.1')
    bfs = list(nx.bfs_edges(G,'M1142843.1'))
    #print(bfs)
    #print(len(bfs))
    G.add_edge('L3081380.1','M1142843.1')
    G.add_edge('M1047515.1','M1047513.1')
    G.add_edge('L3066815.1','196-29519.1')
    G.add_edge('SOURCEBUS.1','EPRI_CKT7.1')
    G_main.add_edges_from(bfs)
    #print(len(G_main.edges),len(G_main.nodes))
    
    '''
    regxfmr_190-8593.1 \\main
    regxfmr_190-7361.1  \\ first cluster
    regxfmr_190-8581.1  \\ main
    '''

    # The clusters are stored in G_1,G_2,G_3 and G_main
    total = len(G.nodes)
    num_1 = len(G_1.nodes)
    num_2 = len(G_2.nodes)
    num_3 = len(G_3.nodes)
    num_4 = len(G_4.nodes)
    num_main = len(G_main.nodes)
    #print(total,num_1+num_2+num_3+num_4+num_main)
    partion = './result_Partition/PhaseOne.data'
    store = open(partion, 'wb')
    pickle.dump([G,G_1,G_2,G_3,G_4,G_main],store)
    return G,G_main,G_1,G_2,G_3,G_4
#AllnodeName
NameList = ['SOURCEBUS.1', 'SOURCEBUS.2', 'SOURCEBUS.3', '_HVMV_SUB_LSB.1', '_HVMV_SUB_LSB.2', '_HVMV_SUB_LSB.3', 'HVMV_SUB_48332.1', 'HVMV_SUB_48332.2', 'HVMV_SUB_48332.3', 'M1009763.2', 'L2673322.2', 'M1069148.3', 'L2673309.3', 'M1069588.2', 'L2804270.2', 'M3036164.2', 'L2935553.2', 'M1209749.2', 'L2748840.2', 'M1108264.2', 'M1108263.2', 'L3085398.1', 'L3085398.2', 'L3085398.3', 'M1026891.1', 'M1026891.2', 'M1026891.3', 'L3216367.1', 'L3216367.2', 'L3216367.3', 'M1069468.1', 'M1069468.2', 'M1069468.3', 'M1142800.2', 'M1142799.2', 'M1047592.3', 'P827512.3', 'M1047339.1', 'P895104.1', 'M1026915.1', 'M1026915.2', 'M1026915.3', 'M1026920.1', 'M1026920.2', 'M1026920.3', 'N1138596.1', 'L3254207.1', 'M1069464.2', 'P873787.2', 'N1144665.1', 'N1144665.2', 'N1144665.3', 'M1047515.1', 'M1047515.2', 'M1047515.3', 'N1137002.1', 'M1047707.1', 'L2729406.3', 'L2897768.3', 'L3649301.1', 'L3649302.1', 'L2970842.2', 'M1089113.2', 'M1047312.1', 'P893163.1', 'L2822871.1', 'L2822871.2', 'L2822871.3', 'M1026872.1', 'M1026872.2', 'M1026872.3', 'M1026312.2', 'L2973163.2', 'L3728038.1', 'L3728039.1', 'M1069567.2', 'M1069582.2', 'N1140830.1', 'L3216351.1', 'L2952007.3', 'L2861158.3', 'N1140827.1', 'N1140827.2', 'N1140827.3', 'M1026726.1', 'M1026726.2', 'M1026726.3', 'L2730106.1', 'L2730106.2', 'L2730106.3', 'N1142099.1', 'N1142099.2', 'N1142099.3', 'M1026658.1', 'L3172805.1', 'P895112.1', 'L3048962.1', 'L2991914.1', 'L2991914.2', 'L2991914.3', 'M1047503.1', 'M1047503.2', 'M1047503.3', 'M1047751.1', 'L2973154.1', 'L3010565.3', 'L2897775.3', 'M1125955.3', 'M1125957.3', 'M1069640.2', 'L2804269.2', 'M1026702.1', 'M1026702.2', 'M1026702.3', 'N1139551.1', 'N1139551.2', 'N1139551.3', 'N1136355.2', 'L2783231.2', 'L2748143.1', 'L3251854.1', 'M1069610.2', 'M1069600.2', 'M1069424.1', 'M1069424.2', 'M1069424.3', 'L2935549.1', 'L2935549.2', 'L2935549.3', 'P895089.3', 'L3235242.3', 'M1026795.3', 'N1140522.3', 'L3030199.1', 'L3030199.2', 'L3030199.3', 'M1125934.1', 'M1125934.2', 'M1125934.3', 'M1069189.3', 'L2860487.3', '221-312488.1', '221-312488.2', '221-312488.3', 'M1089183.1', 'M1089183.2', 'M1089183.3', 'M1108464.2', 'L3102286.2', 'F739845.1', 'F739845.2', 'F739845.3', '293471.1', '293471.2', '293471.3', 'P827499.1', 'N1139254.1', 'M1026657.1', 'M1026656.1', 'M1108299.2', 'M1108300.2', 'L3198355.2', 'L2805037.2', 'N1137994.3', 'M1069484.3', 'L2860504.1', 'L2860493.1', 'M1026783.1', 'M1026783.2', 'M1026783.3', 'M1026780.1', 'M1026780.2', 'M1026780.3', 'P895111.3', 'L2895496.3', 'N1140819.1', 'N1140819.2', 'N1140819.3', 'M1026700.1', 'M1026700.2', 'M1026700.3', 'M1089173.3', 'L2935551.3', 'M1026344.1', 'M1026364.1', 'L2879070.1', 'L2879070.2', 'L2879070.3', 'L3216345.1', 'L3216345.2', 'L3216345.3', 'M1069428.2', 'N1139257.2', 'L2991919.1', 'M1026361.1', 'N1147857.1', 'M1009742.1', 'Q14412.1', 'Q14412.2', 'Q14412.3', 'M1047325.1', 'M1047325.2', 'M1047325.3', 'N1139263.1', 'L3048227.1', 'P827506.1', 'M1069469.1', 'M1027019.2', 'L2785522.2', 'L3216338.2', 'L2973146.2', 'M3037452.1', 'L2973164.1', 'L3120376.1', 'M1026925.1', 'M1047612.3', 'P828360.3', 'M1089195.3', 'L3141393.3', 'M1026946.2', 'M1026940.2', 'M1047471.2', 'L3216349.2', 'M1047401.1', 'L2748132.1', 'L3122820.1', 'L3141398.1', 'M1108360.3', 'L3048968.3', 'L2801950.3', 'M1069224.3', 'L2766746.3', 'M1027073.3', 'M1142873.3', 'M1069181.1', 'L2973151.1', 'L3179682.3', 'L2786274.3', 'L3066816.1', 'M1026667.1', 'M1108529.1', 'M1108529.2', 'M1108529.3', 'M1108532.1', 'M1108532.2', 'M1108532.3', 'L2766723.1', 'L3122822.1', 'L2673312.1', 'L3235247.1', 'M1166391.3', 'L3254873.3', 'L2861157.3', 'P901951.3', 'M1047346.1', 'M1047346.2', 'M1047346.3', 'M1047345.1', 'M1047345.2', 'M1047345.3', 'L2989596.2', 'L2822873.2', 'M1108328.3', 'L2875754.3', 'L2786204.3', 'M1209819.3', 'P901972.1', 'M1009726.1', 'M1047702.1', 'N1137001.1', 'L2767340.1', 'L2767340.2', 'L2767340.3', 'M3037449.1', 'M3037449.2', 'M3037449.3', 'M1047457.2', 'L2710546.2', 'L2674027.1', 'L2674027.2', 'L2674027.3', 'L2692633.1', 'L2692633.2', 'L2692633.3', 'N1142108.1', 'L2674051.1', 'M1069135.1', 'M1069135.2', 'M1069135.3', 'R18242.1', 'R18242.2', 'R18242.3', 'M1047534.1', 'M1047534.2', 'M1047534.3', 'N1136663.1', 'N1136663.2', 'N1136663.3', 'M1108508.3', 'L3097861.3', 'M1069560.2', 'L2973153.1', 'L2973153.2', 'L2973153.3', 'N1136998.1', 'N1136998.2', 'N1136998.3', 'L2898515.3', 'M1166387.3', 'M1047442.2', 'L3235250.2', 'M1142871.1', 'M1142871.2', 'M1142871.3', 'M1142874.1', 'M1142874.2', 'M1142874.3', 'L2955081.1', 'L2955081.2', 'L2955081.3', 'M1108315.1', 'M1108315.2', 'M1108315.3', 'L2973162.1', 'L2973162.2', 'L2973162.3', 'M1026333.1', 'M1026333.2', 'M1026333.3', 'M1009832.2', 'L2860479.2', 'M1026854.1', 'P901894.1', 'M1026485.2', 'M1026492.2', 'D6413567-3_INT.1', 'D6413567-3_INT.2', 'D6413567-3_INT.3', 'E182724.1', 'E182724.2', 'E182724.3', 'N1139541.1', 'N1139541.2', 'N1139541.3', 'M4122658.1', 'M4122658.2', 'M4122658.3', 'L2933135.1', 'L2933135.2', 'L2933135.3', 'L2729414.1', 'L2729414.2', 'L2729414.3', 'L2729430.2', 'L2766742.2', 'M1026972.2', 'L2860483.2', 'L2860490.1', 'L2860490.2', 'L2860490.3', 'L3104134.1', 'L3104134.2', 'L3104134.3', 'M1089144.1', 'P827522.1', 'M1089118.1', 'L3048208.1', 'M1108505.1', 'M1108505.2', 'M1108505.3', 'L2955047.1', 'L2955047.2', 'L2955047.3', 'M1089148.1', 'L2766721.1', 'M1026745.2', 'L3029183.2', 'L2710512.2', 'M1047828.2', 'M1047342.1', 'L3197645.1', 'M1069192.1', 'L3235253.1', 'L3214071.1', 'L3214071.2', 'L3214071.3', 'M1125952.1', 'M1125952.2', 'M1125952.3', 'M1027101.2', 'L2860480.2', 'L2710517.1', 'M1026646.1', 'M1069662.2', 'L2935547.2', 'M1026931.1', 'L3216336.1', 'L3142049.1', 'L3142049.2', 'L3142049.3', 'M1108493.1', 'M1108493.2', 'M1108493.3', 'M1069169.1', 'M1069169.2', 'M1069169.3', 'L3010556.1', 'L3010556.2', 'L3010556.3', 'L2991933.3', 'L3122837.3', 'L2691936.1', 'L2897772.1', 'L3101814.1', 'L2766732.2', 'L2989564.2', 'M1126016.1', 'L3120534.1', 'M1026330.2', 'L2766726.2', 'P901912.2', 'L3195365.2', 'M1108381.1', 'M1108381.2', 'M1108381.3', 'L3254237.1', 'L3254237.2', 'L3254237.3', 'L2804262.1', 'L2841639.1', 'N1230123.2', 'L2708744.2', 'M1069519.2', 'P901927.2', 'L2897790.3', 'L2935566.3', 'L3216337.1', 'P901931.3', 'M1069548.3', 'M1010013.1', 'L3120503.1', 'M1089145.1', 'M1089145.2', 'M1089145.3', 'L3215385.1', 'L3215385.2', 'L3215385.3', 'M1026854.2', 'M1026854.3', 'M1026852.1', 'M1026852.2', 'M1026852.3', 'M1069420.1', 'M1069420.2', 'M1069420.3', 'L3157708.3', 'N1137991.3', 'M1108413.1', 'M1108460.1', 'P827532.1', 'M1047326.1', 'E182732.1', 'E182732.2', 'E182732.3', 'M1026760.1', 'M1026760.2', 'M1026760.3', 'L3048205.3', 'M1108361.3', 'M3036169.1', 'L2673317.1', 'L3178981.2', 'M1047368.2', 'M1069519.1', 'M1069519.3', 'N1136354.1', 'N1136354.2', 'N1136354.3', 'L2879794.1', 'M1142811.1', 'M1069565.2', 'L2785536.2', 'L3104114.2', 'M1009824.2', 'L2745848.1', 'L2745848.2', 'L2745848.3', 'L2673308.1', 'L2673308.2', 'L2673308.3', 'L2991939.1', 'L2991939.2', 'L2991939.3', 'L2916606.3', 'L2822864.3', 'M1142851.1', 'M1142851.2', 'M1142851.3', '196-31070.1', '196-31070.2', '196-31070.3', 'M1209822.3', 'M1209823.3', 'M1069550.2', 'M1069551.2', 'L3141397.2', 'L3649299.1', 'M3772794.1', 'P895106.2', 'L3048887.2', 'M1047824.2', 'M1047834.2', 'M1069350.1', 'M1069350.2', 'M1069350.3', 'N1144668.1', 'N1144668.2', 'N1144668.3', 'L2879072.2', 'M1047441.2', 'M1108274.2', 'M1108269.2', 'L3235244.1', 'M1069398.1', 'N1147862.1', 'L2685805.1', 'M1069247.1', 'M1069248.1', 'L2786273.2', 'M1108278.2', 'L3254238.1', 'L3254238.2', 'L3254238.3', 'M1047303.1', 'M1047303.2', 'M1047303.3', 'M1047633.3', 'L2897554.3', 'M1069627.2', 'L2897791.2', 'M1089097.2', 'M1108270.2', 'N1142101.1', 'L2936214.1', 'L3066810.3', 'L2897769.3', 'M1209758.2', 'M1209753.2', 'M1047528.1', 'M1047528.2', 'M1047528.3', 'L2858166.1', 'L2858166.2', 'L2858166.3', 'M1142843.1', 'M1142843.2', 'M1142843.3', 'L3081380.1', 'L3081380.2', 'L3081380.3', 'L2804272.2', 'L2841641.2', 'M1069393.2', 'M1069408.2', 'N1142104.1', 'N1142104.2', 'N1142104.3', 'M1108500.1', 'M1108500.2', 'M1108500.3', 'L3216348.1', 'L2841627.1', 'L2916599.1', 'M1047447.2', 'L2954349.2', 'L3235246.2', 'M1125911.2', 'L2711224.2', 'N1147863.3', 'L3122817.3', 'M1186061.2', 'L2861223.2', 'M1069130.1', 'L3085396.1', 'E182730.1', 'N1142109.1', 'M1069417.1', 'M1069417.2', 'M1069417.3', 'N1138597.1', 'N1138597.2', 'N1138597.3', 'M1026987.2', 'M1026990.2', 'M1142832.1', 'M1142832.2', 'M1142832.3', 'L3160865.1', 'L3160865.2', 'L3160865.3', 'L2673323.3', 'M1009809.3', 'L2822869.1', 'L2822869.2', 'L2822869.3', 'M1026808.1', 'M1026808.2', 'M1026808.3', 'M1047825.2', 'M1069731.2', 'N1140520.3', 'L2729410.3', 'L3178978.1', 'M1069384.1', 'L3066805.1', 'M4362181.2', 'M1047319.3', 'M1047318.3', 'L3216358.1', 'M1026826.1', 'M1108276.2', 'M1089198.1', 'M1089198.2', 'M1089198.3', 'M1089201.1', 'M1089201.2', 'M1089201.3', 'M1047763.1', 'N1136027.1', 'L3101827.3', 'M1108540.3', 'M1026335.1', 'L2804259.1', 'N1136357.3', 'M1047513.1', 'M1047513.2', 'M1047513.3', 'M1047507.1', 'M1047507.2', 'M1047507.3', 'M1142863.3', 'N1141480.3', 'M1125916.2', 'L2879767.2', 'L3066809.3', 'M1069487.3', 'M1142818.1', 'M1142818.2', 'M1142818.3', 'P829965.1', 'P829965.2', 'P829965.3', 'Q14733.1', 'Q14733.2', 'Q14733.3', 'M1047568.1', 'M1047568.2', 'M1047568.3', 'M1047322.1', 'L2954338.2', 'M1047409.1', 'L2841648.1', 'M1089177.3', 'M1026951.2', 'L2954347.2', 'M4122657.3', 'L3027124.3', 'M1069419.1', 'M1069419.2', 'M1069419.3', 'M1069418.1', 'M1069418.2', 'M1069418.3', 'M1026824.3', 'P859694.3', 'M1047453.2', 'L2691948.2', 'P860892.3', 'N1139543.3', 'M1089205.1', 'N1134472.1', 'L2710542.2', 'M3032980.1', 'M3032980.2', 'M3032980.3', 'M3032977.1', 'M3032977.2', 'M3032977.3', 'M3763618.3', 'P1121282.3', 'L2917330.1', 'L2861222.1', 'M1047490.1', 'P1164481.1', 'M1069356.3', 'M1069363.3', 'P828359.3', 'L2878848.3', 'M1047486.1', 'L3177665.1', 'L2805036.2', 'L2692654.1', 'M1125929.1', 'M1047669.1', 'M1047669.2', 'M1047669.3', 'M1047672.1', 'M1047672.2', 'M1047672.3', 'M1125919.1', 'P829961.1', 'M1142819.2', 'P829960.2', 'P829979.2', 'M3036172.2', 'M1026883.3', 'M1026898.3', 'M1089143.1', 'L3141400.1', 'M1069481.3', 'P827507.3', 'M1026377.1', 'L3048210.1', 'E182722.1', 'M1026331.3', 'L3214055.3', 'M1108295.1', 'M1108295.2', 'M1108295.3', 'L2936279.1', 'L2936279.2', 'L2936279.3', 'M1026704.2', 'L2841634.2', 'M1047386.2', 'M1047379.2', 'M1089118.2', 'M1089118.3', 'M1089115.1', 'M1089115.2', 'M1089115.3', 'M1026486.2', 'M1026488.2', 'L3010570.1', 'P904451.1', '221-282819.1', 'M1125968.3', 'P895107.3', 'N1136999.1', 'M1069412.2', 'L2879061.2', 'M1026947.2', 'M1142880.3', 'L2891575.3', 'M1026848.1', 'M1026847.1', 'L2897793.1', 'M1069521.1', 'M1069175.3', 'L3197637.3', 'L3197635.2', 'L2804257.2', 'L2860485.2', 'L3235945.3', 'L2842330.3', 'L2804254.1', 'M1047752.1', 'M1166370.3', 'M1166364.3', 'M1047592.1', 'M1047592.2', 'M3763619.1', 'M3763619.2', 'M3763619.3', 'M3037540.3', 'L2710509.3', 'L2763072.2', 'M4118754.2', 'M1089196.1', 'M1089196.2', 'M1089196.3', 'M1047484.1', 'M1047484.2', 'M1047484.3', 'L3010560.1', 'L3010560.2', 'L3010560.3', 'L3254219.3', 'L3254220.3', 'M1026648.1', 'M1026647.1', 'M1089112.3', 'L2691951.3', '228-1048090-1_INT.2', '193-51796.2', 'M1108433.2', 'M1026327.2', 'L2841636.2', 'L2990826.1', 'L2990826.2', 'L2990826.3', 'L2911069.2', 'L2948732.2', 'M1108260.2', 'M1108259.2', 'M1069312.3', 'P873800.3', 'M1186078.3', 'L2876797.1', 'L2876797.2', 'L2876797.3', 'R18241.1', 'R18241.2', 'R18241.3', 'L3254227.2', 'M3037455.3', 'L3217052.3', 'P827500.1', 'L2822861.1', 'M1047724.1', 'M1047724.2', 'M1047724.3', 'M1047722.1', 'M1047722.2', 'M1047722.3', 'D5534969-2_INT.1', 'D5534969-2_INT.2', 'D5534969-2_INT.3', 'E182729.1', 'E182729.2', 'E182729.3', 'N1134477.1', 'N1134477.2', 'N1134477.3', 'M1166355.1', 'L2858200.1', 'M1047699.1', 'M1047699.2', 'M1047699.3', 'L2935554.1', 'L2935554.2', 'L2935554.3', 'M1047292.3', 'L2766750.3', 'L3649300.1', 'M1047733.1', 'L3066804.1', 'M3327098.2', 'L2691943.2', 'P829986.1', 'M1125904.1', 'N1139550.1', 'M1026307.2', 'L3085388.2', 'L3233413.2', 'L3122827.1', 'L2954355.1', 'P827576.2', 'N1139256.2', 'L2952003.1', 'L2952003.2', 'L2952003.3', 'N1136359.3', 'L3008237.3', 'M1089102.3', 'M1089096.3', 'P895102.2', 'M1125978.2', 'M1026706.1', 'M1026706.2', 'M1026706.3', 'N1140825.1', 'N1140825.2', 'N1140825.3', 'L3141399.3', 'M1069210.3', 'M3763624.3', 'P1121283.3', 'M1142839.3', 'L3067507.3', 'N1141478.2', 'M1142826.2', 'M1108334.3', 'L2692664.3', 'L2823544.1', '226-23751.1', '226-23751.2', '226-23751.3', 'P827536.1', 'N1137999.1', 'L3027157.1', 'L3027157.2', 'L3027157.3', 'L2973155.1', 'L2973155.2', 'L2973155.3', 'M1186052.1', 'M1186052.2', 'M1186052.3', '198-5320.1', '198-5320.2', '198-5320.3', 'L3216346.1', 'L2858163.1', 'M1047813.2', 'L2973149.2', 'L3086079.2', 'M1069574.2', 'L2710530.2', 'M1069285.1', 'M1069285.3', 'M4113348.1', 'M4113348.3', 'L2879074.1', 'M1026916.2', 'E193509.1', 'E193509.2', 'E193509.3', 'M1142839.1', 'M1142839.2', 'M1047794.2', 'M1047796.2', 'L3027116.1', 'L3027116.2', 'L3027116.3', 'L2929261.1', 'M1166375.1', 'P895080.1', 'L2973156.2', 'M1069311.3', 'M1069208.3', 'L2691945.3', 'N1140820.2', 'M1026468.2', 'P901909.2', 'M1026662.1', 'N1141473.1', 'M1026941.1', 'M1026942.1', 'N1137985.1', 'M1047713.1', 'M1047713.2', 'M1047713.3', 'M1047720.1', 'M1047720.2', 'M1047720.3', 'M1108298.1', 'M1108298.2', 'M1108298.3', '196-36167.1', '196-36167.2', '196-36167.3', 'E183472.1', 'E183472.2', 'E183472.3', 'L2989566.1', 'L2989566.2', 'L2989566.3', 'M1010007.1', 'M1010004.1', 'P862322.1', 'P862322.2', 'P862322.3', 'M1089188.3', 'M1089189.3', 'L2972704.3', 'L3263051.3', 'N1139544.3', 'L2897776.3', 'N1230122.1', 'L2689726.1', 'M1142868.1', 'M1142868.2', 'M1142868.3', 'M1142869.1', 'M1142869.2', 'M1142869.3', 'L2767414.3', 'M1027027.3', 'L3270853.3', 'M1125982.2', 'M1069572.2', 'L3066826.2', 'M1166356.1', 'L2730187.1', 'L3122825.1', 'L2991920.1', 'N1134474.1', 'N1134474.2', 'N1134474.3', 'M1069496.1', 'M1069496.2', 'M1069496.3', 'L3122826.1', 'M1047358.1', 'L3142078.2', 'L2879752.2', 'P850072.1', 'P850072.2', 'P850072.3', '221-311609.1', '221-311609.2', '221-311609.3', 'M1027023.2', 'L3122815.2', 'L2724120.3', 'M1069149.3', 'M1142819.1', 'M1142819.3', 'L2729429.1', 'L3215549.2', 'L2897800.2', 'L3027156.3', 'L2860481.3', 'N1140828.1', 'N1140828.2', 'N1140828.3', 'M1026708.1', 'M1026708.2', 'M1026708.3', 'M1126020.1', 'M1126023.1', 'M1026906.1', 'M1209824.3', 'M1209828.3', 'L3195315.1', 'M1069590.2', 'M1069595.2', 'M1027004.2', 'L2897765.2', 'M1047314.1', 'N1137961.1', 'L2876814.1', 'L2876814.2', 'L2876814.3', 'M1026834.1', 'M1026834.2', 'M1026834.3', 'M1008743.2', 'M1008742.2', 'P827525.1', 'P827525.2', 'P827525.3', 'M1026902.1', 'M1026902.2', 'M1026902.3', 'N1144663.1', 'N1144663.2', 'N1144663.3', 'M1089215.1', 'M1089215.2', 'M1089215.3', 'M1069467.1', 'M1047324.1', 'M1047324.2', 'M1047324.3', 'L2897780.1', 'L2897780.2', 'L2897780.3', 'M1069411.1', 'M1069411.2', 'M1069411.3', 'L2711226.1', 'L2711226.2', 'L2711226.3', 'L3101789.1', 'L2841616.1', 'M1089170.3', 'L2879062.3', 'N1139545.3', 'M1069174.3', 'N1140517.1', 'L3157718.1', 'L2727008.2', 'M1069629.2', 'L2691944.1', 'N1230121.3', 'M1069533.1', 'M1069533.2', 'M1069533.3', 'N1136356.1', 'N1136356.2', 'N1136356.3', 'M1142865.1', 'M1047526.1', 'M1047526.2', 'M1047526.3', 'N1136666.1', 'N1136666.2', 'N1136666.3', 'L2804253.1', 'M1209790.1', 'M1209790.2', 'M1209790.3', 'M1209788.1', 'M1209788.2', 'M1209788.3', 'P850400.3', 'L3029500.1', 'M1026764.1', 'M1108375.3', 'M1069217.3', 'L2954350.3', 'L2802481.1', 'L3214549.1', 'L2851933.1', 'L2851933.2', 'L2851933.3', 'L3207907.1', 'L3207907.2', 'L3207907.3', 'L2841619.3', 'M1108380.2', 'P904452.2', 'N1136995.3', 'M1047613.3', '221-306687.2', 'L2916625.2', 'M1009724.1', 'M1009720.1', 'L2822862.3', 'D6019477-1_INT.3', 'E182727.3', 'M1027043.3', 'M1026948.2', 'M1026949.2', 'M1089131.1', 'L3270854.1', 'M1209763.2', 'L3176661.3', 'L2970804.3', 'P827504.1', 'N1137957.1', 'L2936275.2', 'L2766722.2', 'L3142079.2', 'M3036162.2', 'M1026724.1', 'M1026724.2', 'M1026724.3', 'R18243.1', 'R18243.2', 'R18243.3', 'L2710504.2', 'M1142860.1', 'P895114.1', 'L3197652.1', 'P827575.3', 'M1069437.3', 'M1069620.2', 'L3270814.1', 'M1026378.1', 'L2897778.1', 'M1069532.2', 'L2785534.2', 'M1069147.3', 'L3066801.3', 'M1069556.3', 'P901932.3', 'L2691967.1', 'L2691967.2', 'L2691967.3', 'M1069504.1', 'M1069504.2', 'M1069504.3', 'M1166393.3', 'M1166395.3', 'L2766718.1', 'L2766718.2', 'L2766718.3', 'L3048206.1', 'L3048206.2', 'L3048206.3', 'M1047821.2', 'L2684420.2', 'P850080.1', 'P850080.2', 'P850080.3', '221-311905.1', '221-311905.2', '221-311905.3', 'M1089204.1', 'L3157167.1', 'M1186072.1', 'M1186072.2', 'M1186072.3', 'M1186067.1', 'M1186067.2', 'M1186067.3', 'M1047432.1', 'L2879075.1', 'M3037537.2', 'L3231269.2', 'R42247.1', 'R42247.2', 'R42247.3', 'M1149233.1', 'M1149233.2', 'M1149233.3', 'M1108266.2', 'M1108265.2', 'M1069543.2', 'M1069535.2', 'M1126017.1', 'M1047711.1', 'M1047718.1', 'M1069136.1', 'M1069136.2', 'M1069136.3', 'M1009771.2', 'L2914323.2', 'M1069218.3', 'L2954351.3', 'M1026744.1', 'M1026744.2', 'M1026744.3', 'M1008752.2', 'M1008746.2', 'M1069457.1', 'E182745.1', 'N1139546.2', 'M1026363.3', 'L2897779.3', 'L2841626.3', 'L2711234.2', 'L2973178.2', 'M1149236.1', 'P829974.1', 'L3160862.3', 'L3104850.3', 'L2748130.2', 'L3083019.1', 'M1027080.1', 'L3085389.2', 'L2729405.2', 'P828362.1', 'P828362.2', 'P828362.3', 'N1136671.1', 'N1136671.2', 'N1136671.3', 'P901941.1', 'L3251799.1', 'M1026308.2', 'L2897764.2', 'M1009840.2', 'L2991901.2', 'N1134470.1', 'L3251808.1', 'L3139086.2', 'N1137992.1', 'N1137992.2', 'N1137992.3', '196-29520.1', '196-29520.2', '196-29520.3', 'L3029501.2', 'M3036165.2', 'M1026857.1', 'M1026859.1', 'M1108311.3', 'L2898526.3', 'L3048965.1', 'L3048965.2', 'L3048965.3', 'L3216123.1', 'L3216123.2', 'L3216123.3', 'N1136996.1', 'N1136996.2', 'N1136996.3', 'M1069202.3', 'L2879073.3', 'M1089093.3', 'M1047786.2', 'L3048207.2', 'L3160868.2', 'L3082988.2', 'L2936211.3', 'N1140525.3', 'L3645809.3', 'P829962.3', 'M1142835.3', 'L3125349.1', 'L3125349.2', 'L3125349.3', 'N1138604.1', 'N1138604.2', 'N1138604.3', 'D5710794-3_INT.1', 'D5710794-3_INT.2', 'D5710794-3_INT.3', 'E192860.1', 'E192860.2', 'E192860.3', 'L3254216.1', 'L2785511.1', 'L2897784.2', 'M1026496.2', 'P859135.1', 'M1027002.1', 'M1027002.2', 'M1027002.3', 'L2673313.1', 'L2673313.2', 'L2673313.3', 'M1047725.2', 'M1047728.2', 'M1047300.1', 'M1047300.2', 'M1047300.3', 'M1047299.1', 'M1047299.2', 'M1047299.3', 'L3122835.2', 'L3234185.2', 'L3065750.2', 'L2991943.3', 'L2952013.1', 'M1026701.1', 'M1026701.2', 'M1026701.3', 'M1026697.1', 'M1026697.2', 'M1026697.3', 'M1069730.2', 'L3159037.2', 'M1142833.3', 'P901913.3', 'N1140823.1', 'N1140823.2', 'N1140823.3', 'M1027066.3', 'L2841645.3', 'M1125959.3', 'M1125974.3', 'M1069191.1', 'M1108258.2', 'P829976.1', 'L2955078.1', 'D5837361-8_INT.3', 'E182745.3', 'N1147867.3', 'M1026792.1', 'L2821010.1', 'M1125968.1', 'M1125968.2', 'M1125976.1', 'M1125976.2', 'M1125976.3', 'N1142112.2', 'P827496.2', '221-240988.3', 'L3141411.3', 'P829956.3', 'D5535139-1_INT.1', 'D5535139-1_INT.2', 'D5535139-1_INT.3', 'E183473.1', 'E183473.2', 'E183473.3', 'M1125997.1', 'M1125997.2', 'M1125997.3', 'M1047518.2', 'L2973160.2', 'N1134471.1', 'M1009838.2', 'L2801896.2', 'P827520.3', 'M1009784.1', 'M1009784.2', 'M1009784.3', 'M1009770.1', 'M1009770.2', 'M1009770.3', 'N1136669.1', 'N1136669.2', 'N1136669.3', 'L3103822.1', 'L3103822.2', 'L3103822.3', 'M3768670.1', 'P1123251.1', 'N1136994.3', 'L2729428.1', 'M1026926.1', 'N1138000.1', '221-242079.1', '221-242079.2', '221-242079.3', 'L3011293.1', 'L3011293.2', 'L3011293.3', 'M1026777.1', 'L3233353.1', 'L3029506.2', 'L3010559.1', 'M1069213.3', 'L3178977.3', 'M1108534.1', 'P901934.1', 'P829796.3', 'N1142107.3', 'L2691965.2', 'L2785538.1', 'N1139259.3', 'L2710543.3', 'Q1301.1', 'Q1301.2', 'Q1301.3', 'L3160872.1', 'L3160872.2', 'L3160872.3', 'M1047763.2', 'P827509.2', 'M1047793.2', 'P827555.2', 'L2879069.1', 'L2955006.3', 'L2692600.3', 'L3029505.3', 'L2673318.3', 'M1026682.1', 'M1047424.2', 'L2691949.2', 'M1026699.2', 'L3085403.1', 'M4113345.3', 'L3235255.1', 'L3235255.2', 'L3235255.3', 'M1047316.1', 'M1047316.2', 'M1047316.3', 'M1026886.1', 'M1026886.2', 'M1026886.3', 'L3120484.1', 'L3120484.2', 'L3120484.3', 'L2879078.1', 'L2879078.2', 'L2879078.3', 'M1026681.1', 'M1026681.2', 'M1026681.3', 'L3232902.1', 'L3232902.2', 'L3232902.3', 'L3123509.1', 'L3123509.2', 'L3123509.3', 'M1209772.1', 'M1209772.2', 'M1209772.3', 'R20703.1', 'R20703.2', 'R20703.3', 'L2859403.1', 'L2859403.2', 'L2859403.3', 'M1026926.2', 'M1026926.3', 'M1026927.1', 'M1026927.2', 'M1026927.3', 'M1125914.1', 'M1125914.2', 'M1125914.3', 'L2917328.1', 'L2917328.2', 'L2917328.3', 'L2841635.1', 'L2841635.2', 'L2841635.3', 'L2766499.3', 'M1047444.2', 'M1108459.2', 'L2802480.2', 'L2691954.1', 'L2691954.2', 'L2691954.3', 'L3122849.1', 'L3122849.2', 'L3122849.3', 'L2764411.3', 'M1026907.1', 'M1026907.2', 'M1026907.3', 'L2729206.3', 'L2804957.3', 'L3048937.3', 'L2822872.1', 'L2822872.2', 'L2822872.3', 'M1047490.2', 'M1047490.3', 'L3235946.1', 'M1126005.1', 'M1009698.1', 'L3156034.1', 'L3254205.3', 'L3197647.1', 'M1026778.1', 'M1026844.3', 'N1147861.3', 'L2973833.1', 'L2973833.2', 'L2973833.3', 'M1166373.1', 'M1166373.2', 'M1166373.3', 'L2991902.2', 'M1008758.2', 'M1026734.1', 'L3065696.1', 'L2748780.1', 'M1125987.1', 'M1125987.2', 'M1125987.3', 'P901945.1', 'P901945.2', 'P901945.3', 'P901910.2', 'L3027122.1', 'M1108506.1', 'L2841637.3', 'N1139539.1', 'L2710520.1', 'M1089119.2', 'P827521.2', 'L3046854.2', 'M1047478.3', 'L2766716.3', 'N1137003.1', 'L2973171.2', 'L3085392.3', 'P875742.2', 'M1010008.1', 'L3784018.1', 'L3784018.2', 'L3784018.3', 'M1026703.3', 'L2973166.3', 'L3068944.2', 'M1047550.1', 'M1047550.2', 'M1047550.3', 'L2936270.1', 'L3086078.1', 'M1047593.1', 'M1047593.2', 'M1047593.3', 'M1047615.1', 'M1047615.2', 'M1047615.3', 'M1009855.2', 'L2748139.2', 'N1140832.3', 'L2841631.3', 'M1047819.2', 'L2916610.2', 'L2879076.3', 'M1089122.3', 'L2691939.2', 'M1069489.3', 'L2933120.3', 'M1069225.3', 'M1089120.1', 'M1089120.2', 'M1089120.3', 'M1089119.1', 'M1089119.3', 'L3645810.3', 'M3763623.3', 'L3649304.1', 'M1027042.3', 'L3178969.2', 'L2729401.2', 'L3235249.1', 'L2954348.1', 'L3066812.1', 'L2841622.1', 'M1209787.1', 'M1209787.2', 'M1209787.3', 'L2823611.1', 'L2823611.2', 'L2823611.3', '196-35541.3', 'M1108317.3', 'M1047340.1', 'L2991923.1', 'M1026661.1', 'P827530.1', 'P827503.3', 'N1147865.1', 'L2895489.1', 'L2730163.1', 'L2730163.2', 'L2730163.3', 'M1026331.1', 'M1026331.2', 'M1089103.2', 'L3048196.2', 'L2673306.3', 'L2726973.1', 'L2726973.2', 'L2726973.3', 'M1047485.1', 'M1047485.2', 'M1047485.3', 'L2991640.3', 'M1089160.3', 'L3160101.1', 'M1125905.2', 'M1026950.1', 'M1026950.2', 'M1026950.3', 'M1026954.1', 'M1026954.2', 'M1026954.3', 'M1047558.1', 'N1136659.1', 'L2766741.1', 'L2766741.2', 'L2766741.3', 'M1069564.1', 'N1136361.1', 'M1047566.1', 'N1137995.1', 'N1145955.1', 'M1069461.1', 'P827574.1', 'M1069156.1', 'M1069156.2', 'M1069156.3', 'M1089112.1', 'M1089112.2', 'L3195356.1', 'L3195356.2', 'L3195356.3', 'N1137996.3', 'L3178979.3', 'L3254231.1', 'L3728042.1', 'L3728043.1', 'M1047723.1', 'M1047729.1', 'L2895461.1', 'L3029518.2', 'L2897807.2', 'L2785520.2', 'N1139542.3', '221-308718.1', '221-308718.2', '221-308718.3', 'M1209750.2', 'L3254869.2', 'L2798067.2', 'M1047403.1', 'M1047404.1', 'L3102793.2', 'M1089143.2', 'M1089143.3', 'M1089141.1', 'M1089141.2', 'M1089141.3', 'N1139547.1', 'N1139547.2', 'N1139547.3', 'L2688693.1', 'L2688693.2', 'L2688693.3', 'L3048222.3', 'L3104117.3', '221-311583.1', 'N1139250.1', 'L2690187.2', 'M1108412.2', 'M1026690.1', 'P873801.3', 'M1089138.1', 'L2841628.1', 'M1069364.3', 'L2689678.2', 'M1026463.2', 'L2692655.1', 'L2692655.2', 'L2692655.3', 'M1142821.1', 'M1142821.2', 'M1142821.3', 'P827508.1', 'N1144667.1', 'M1089162.3', 'L3029520.2', 'M1009655.3', 'P827528.3', 'L2991906.1', 'M1027056.1', 'L3066814.1', 'L3066814.2', 'L3066814.3', 'M1108398.1', 'M1108398.2', 'M1108398.3', 'M1108483.1', 'M1108486.1', 'M1142863.1', 'M1142863.2', 'M1142865.2', 'M1142865.3', 'M1026341.1', 'P827531.1', 'L2748133.3', 'L3085399.3', 'L2767342.1', 'M1125944.1', 'M1125944.2', 'M1125944.3', 'M1125947.1', 'M1125947.2', 'M1125947.3', 'L2710511.1', 'L2766719.1', 'P827549.1', 'N1140518.1', 'L2766728.3', 'M1069462.2', 'L3216342.2', 'M1027041.3', 'L2916607.3', 'L2710513.2', 'M1009839.2', 'L2973165.1', 'M1108501.1', 'M1108499.1', 'M1069227.3', 'L2785546.1', 'M1026810.1', 'M1108368.3', 'L3085393.3', 'L3178974.2', 'M1026774.1', 'M1026774.2', 'M1026774.3', 'M1026769.1', 'M1026769.2', 'M1026769.3', 'L3189189.2', 'L2821770.1', 'M1069555.2', 'L3252336.2', 'P829977.1', 'P829977.2', 'P829977.3', 'M1186061.1', 'M1186061.3', 'L2820556.1', 'M1047410.1', 'M1027001.2', 'M1047344.1', 'L3029499.1', '221-282818.2', 'M1026830.3', 'P827511.3', 'P895105.1', 'N1142110.1', 'N1142111.1', 'L2991912.1', 'L3010569.1', 'M1047335.1', 'L3216368.1', 'L3216368.2', 'L3216368.3', 'L2879081.1', 'L3104144.1', 'L2916619.2', 'M1126031.3', 'L3179608.3', 'L2990098.1', 'M1108462.1', 'L2673326.2', 'M1142815.1', 'N1141477.1', 'N1139252.2', 'L3122812.2', 'M1166386.3', 'M1089163.3', 'N1142100.1', 'N1142100.2', 'N1142100.3', 'M1069456.3', 'L2897806.3', 'L2822865.3', 'L3195321.1', 'L3197646.1', 'L3197646.2', 'L3197646.3', 'M1026829.2', 'N1147859.2', 'L3139121.1', 'L3139121.2', 'L3139121.3', 'L2763153.1', 'L2763153.2', 'L2763153.3', 'E182726.2', 'L2766744.2', 'L3216370.1', 'L3216370.2', 'L3216370.3', 'M1047312.2', 'M1047312.3', '226-23745.3', 'M1142828.1', 'M1142828.2', 'M1142828.3', 'L2674047.1', 'L2674047.2', 'L2674047.3', 'M3949157.1', 'L3727711.1', 'M1026329.1', 'M1026329.2', 'M1026329.3', 'M1026328.1', 'M1026328.2', 'M1026328.3', 'M1108355.3', 'M1108352.3', 'L3086002.3', 'N1134476.1', 'N1134476.2', 'N1134476.3', 'M1069284.1', 'P850401.1', 'D5502543-2_INT.1', 'D5502543-2_INT.2', 'D5502543-2_INT.3', 'Q14413.1', 'Q14413.2', 'Q14413.3', 'L3029503.3', 'N1140524.1', 'M1047792.2', 'L2876846.2', 'M1089165.3', 'L3216343.3', 'L2748144.1', 'L2748144.2', 'L2748144.3', 'L3010562.2', 'M1026690.2', 'M1026690.3', 'M1069557.2', 'M1047374.2', 'L3197629.2', 'M1089202.1', 'M1089202.2', 'M1089202.3', 'M1089203.1', 'M1089203.2', 'M1089203.3', 'M1026866.1', 'M1149236.2', 'M1149236.3', 'M1149235.1', 'M1149235.2', 'M1149235.3', 'L2766720.1', 'M1209791.1', 'P903354.1', 'M1026960.1', 'M3729981.1', 'L3011298.1', 'L3011298.2', 'L3011298.3', 'M1108524.3', 'N1136031.3', 'M1026722.2', 'L2991915.2', 'L2673320.2', 'M1047497.2', 'M1047755.1', 'M3037441.1', 'N1140824.1', 'M1026709.1', 'M1026709.2', 'M1026709.3', 'L3729298.1', 'L3727707.1', 'L3160123.1', 'L2897805.1', 'M1089094.3', 'M1125919.2', 'M1125919.3', 'M1125917.1', 'M1125917.2', 'M1125917.3', 'M1069154.1', 'M1069154.2', 'M1069154.3', 'L3197630.1', 'L3197630.2', 'L3197630.3', 'M1026343.1', 'M1069155.1', 'M1069155.2', 'M1069155.3', 'L2785523.3', 'L3141388.3', 'M1026786.1', 'M1026786.2', 'M1026786.3', 'M1026785.1', 'M1026785.2', 'M1026785.3', 'N1137958.3', 'M1026877.1', 'L2820583.3', 'M1108354.3', 'L2991911.3', 'N1136363.1', 'N1136363.2', 'N1136363.3', 'R18245.1', 'R18245.2', 'R18245.3', '221-306686.3', 'L2970258.3', 'L2841632.1', 'L2841632.2', 'L2841632.3', 'REGXFMR_190-8593.1', 'REGXFMR_190-8593.2', 'REGXFMR_190-8593.3', 'P1197121.3', 'L2805031.3', 'M1069226.3', 'L2860506.2', 'L2954346.2', 'L2879077.2', 'D5860423-3_INT.1', 'D5860423-3_INT.2', 'D5860423-3_INT.3', '190-8593.1', '190-8593.2', '190-8593.3', 'L3139366.1', 'L3139366.2', 'L3139366.3', 'M4362177.1', 'M4362177.2', 'M4362177.3', 'L2763812.3', 'L2951995.3', 'L3197638.1', 'M1026849.1', 'N1137993.1', 'L2860482.1', 'P901946.1', 'N1142105.1', 'M1026905.1', 'P827515.1', 'M1108520.3', 'L2804277.3', 'L2991913.1', 'L2933165.2', 'L3235273.2', 'M1089131.2', 'M1089131.3', 'L3029502.1', 'L3029502.2', 'L3029502.3', 'M1047780.2', 'L3066811.2', 'M1047732.3', 'N1137987.3', 'L3197661.3', 'L3122848.3', 'M1047580.1', 'M1047580.2', 'M1047580.3', 'M1108345.3', 'M1108347.3', 'D5655682-1_INT.2', 'E182725.2', 'D5926308-3_INT.1', 'D5926308-3_INT.2', 'D5926308-3_INT.3', 'L2860491.1', 'L2860491.2', 'L2860491.3', 'L2897770.3', 'L3104127.2', 'L2767343.3', 'L2786266.1', 'L2786266.2', 'L2786266.3', 'M1166375.2', 'M1166375.3', 'L2785512.2', 'P827529.2', 'N1136668.2', 'M1027114.1', 'L3195327.1', 'M1027121.1', 'M1027123.1', 'L3104157.3', 'P895409.3', 'D6138608-3_INT.1', 'D6138608-3_INT.2', 'D6138608-3_INT.3', 'Q14404.1', 'Q14404.2', 'Q14404.3', 'L2991927.2', 'M1089155.3', 'M1089158.3', 'M1026324.2', 'M1026323.2', 'L2804258.2', 'M1069284.3', 'P829978.1', 'L2992656.1', 'L2936271.1', 'L2936271.2', 'L2936271.3', 'M1142815.2', 'M1142815.3', 'M1069544.2', 'L2916598.1', 'L2954344.3', 'L2897767.3', 'L2876796.1', 'M1047756.1', 'L3122810.2', 'M1108379.1', 'M1108379.2', 'M1108379.3', 'M1108380.1', 'M1108380.3', 'N1140822.3', 'L2860478.2', 'L2822858.2', 'L2841620.2', 'L3727709.1', 'L3727710.1', 'N1136667.1', 'N1136667.2', 'N1136667.3', '196-29519.1', '196-29519.2', '196-29519.3', 'N1144666.3', 'M1125989.1', 'M1125989.2', 'M1125989.3', 'L2898495.1', 'L2898495.2', 'L2898495.3', 'L3179674.2', 'REGXFMR_190-7361.1', 'REGXFMR_190-7361.2', 'REGXFMR_190-7361.3', 'M1069564.2', 'M1069564.3', 'M1069249.3', 'L2803194.3', 'M1186065.1', 'M1186065.2', 'M1186065.3', 'M1186064.1', 'M1186064.2', 'M1186064.3', 'D6231996-1_INT.2', 'E206614.2', 'M1209776.1', 'M1209776.2', 'M1209776.3', 'M1209775.1', 'M1209775.2', 'M1209775.3', 'L2804261.3', 'L3178980.3', 'M1047835.2', 'M1047836.2', 'M1125962.1', 'M1125962.2', 'M1125962.3', 'L3123452.1', 'L3123452.2', 'L3123452.3', 'P893610.2', 'M1108302.2', 'P829797.1', 'L2841629.3', 'L3254218.1', 'L3254218.2', 'L3254218.3', 'L3778577.3', 'L2820531.1', 'L2820531.2', 'L2820531.3', 'L3626914.3', 'L2955077.1', 'L2955077.2', 'L2955077.3', 'M1166374.1', 'M1166374.2', 'M1166374.3', 'N1139552.1', 'N1139552.2', 'N1139552.3', 'P827533.2', 'N1139538.2', 'L3160098.1', 'L3160098.2', 'L3160098.3', 'M1089213.1', 'M1089213.2', 'M1089213.3', 'L2820590.3', 'L3104125.1', 'L3104125.2', 'L3104125.3', 'Q14411.1', 'Q14411.2', 'Q14411.3', 'M1069428.1', 'M1069428.3', 'L3118855.1', 'L3118855.2', 'L3118855.3', 'L3231255.1', 'L3231255.2', 'L3231255.3', 'D5861005-2_INT.1', 'D5861005-2_INT.2', 'D5861005-2_INT.3', 'M1027071.3', 'L3235241.3', 'L2729409.2', 'L2841624.2', 'L3235254.1', 'L3235254.2', 'L3235254.3', 'M1026855.1', 'M1026855.2', 'M1026855.3', 'M1026851.1', 'M1069466.1', 'M1069524.1', 'M1027091.1', 'M1027092.1', 'L2766747.1', 'M1069464.1', 'M1069464.3', 'M1069461.2', 'M1069461.3', 'P827560.1', 'L2822877.1', 'L2822877.2', 'L2822877.3', 'N1138598.1', 'N1138598.2', 'N1138598.3', 'M1009715.1', 'M1009705.1', 'L3198347.3', 'M1108489.1', 'M1108492.1', 'L3226771.1', 'L3189190.1', 'L2991918.2', 'L2954339.2', 'L3048200.2', 'L3160861.3', 'N1142098.1', 'M1047795.2', 'M1047552.2', 'L2804283.1', 'L2916627.1', 'L3029498.1', 'L3029498.2', 'L3029498.3', 'M1047773.2', 'L2973152.2', 'L2822870.3', 'M1166369.1', 'L2839305.1', 'L2710508.2', 'M3763624.1', 'M3763624.2', 'M3763618.1', 'M3763618.2', 'M1026861.1', 'M1026861.2', 'M1026861.3', 'M1026858.1', 'M1026858.2', 'M1026858.3', 'L3082992.1', 'M1010011.1', 'L3214069.1', 'L3214069.2', 'L3214069.3', 'M1026655.3', 'N1141475.3', 'L3197643.2', 'M1026339.2', 'M1108268.2', 'M1069311.1', 'M1069311.2', 'M1069310.1', 'M1069310.2', 'M1069310.3', 'M1047423.1', 'M1047420.1', 'M1069613.2', 'M1026823.1', 'L2879087.1', 'D5806920-1_INT.2', 'M1027039.2', 'L3552667.3', 'M1026890.1', 'L2954357.1', 'M1069438.3', 'L2785530.1', 'L2822868.1', 'M1069556.1', 'M1069556.2', 'N1139264.1', 'P827523.3', 'M1027087.1', 'L2726983.1', 'L2821087.1', 'L2673310.1', 'L2936212.1', 'N1142106.2', 'L2936213.2', 'M1027011.1', 'M1027011.2', 'M1027011.3', 'M1209795.3', 'L2746587.3', 'N1147858.3', 'M1108378.1', 'M1026662.3', 'M1047809.2', 'M1026805.1', 'L3120502.1', 'M1069526.2', 'L2673331.2', 'M1108490.1', 'M1108490.2', 'M1108490.3', 'M1009805.1', 'M1009805.2', 'M1009805.3', 'L3122816.1', 'L3122816.2', 'L3122816.3', 'L3160103.1', 'L3160103.2', 'L3160103.3', 'M1069503.1', 'M1069503.2', 'M1069503.3', 'N1134469.1', 'M1089200.1', 'L3027670.2', 'L2691941.3', 'M1125960.1', 'M1125960.2', 'M1125960.3', 'N1136367.1', 'N1136367.2', 'N1136367.3', 'M1069515.1', 'M1069515.2', 'M1069515.3', 'M1069131.1', 'P827534.1', 'M1069530.2', 'M1069189.1', 'M1069189.2', 'M1069184.1', 'M1069184.2', 'M1069184.3', 'L3159645.1', 'M1069632.2', 'P829957.3', 'L3160863.3', 'P829963.2', 'M1010014.1', 'N1137998.3', 'L3048199.2', 'L3067478.1', 'L3067478.2', 'L3067478.3', 'M1125994.1', 'M1125994.2', 'M1125994.3', 'M1047480.1', 'M1047480.2', 'M1047480.3', 'M1069483.1', 'M1069483.2', 'M1069483.3', 'L2841615.1', 'L2673305.2', 'M1047721.1', 'M1026366.1', 'L3104131.1', 'L2973167.1', 'L2973167.2', 'L2973167.3', 'M1027055.1', 'N1134475.1', 'N1134475.2', 'N1134475.3', 'L3067447.1', 'M1108350.3', 'L3139598.2', 'N1140829.3', 'L3085397.2', 'N1139540.1', 'L2748140.1', 'L3141412.1', 'M1069619.2', 'M1047769.2', 'L3197632.2', 'L2785524.3', 'P827495.2', 'L2991921.3', 'L2710510.3', 'L3197628.3', 'N1140831.3', 'N1136358.3', 'L3104119.1', 'L2842329.3', 'M1125961.3', 'L2973791.1', 'L2973791.2', 'L2973791.3', 'L3179650.1', 'L3179650.2', 'L3179650.3', 'P860843.3', 'M1026961.1', 'L2710516.1', 'L3160864.2', 'M1108378.2', 'M1108378.3', 'M1047623.1', 'L2748157.1', 'L3048212.1', 'L3122824.1', 'L2879089.3', 'L2937757.3', 'L3067448.3', '193-46661.3', 'M1069390.1', 'L2897801.1', 'M1108527.2', 'M1009650.1', 'M1009650.2', 'M1009650.3', 'E203026.1', 'E203026.2', 'E203026.3', 'M1026779.1', 'L2973169.1', 'M1026953.2', 'Q14734.1', 'Q14734.2', 'Q14734.3', 'L3197631.1', 'L2748127.1', 'M1209814.1', 'M1209814.2', 'M1209814.3', 'M1209811.1', 'M1209811.2', 'M1209811.3', 'L2729408.2', 'L3048228.3', 'L2991940.3', 'M1108395.1', 'M1108395.2', 'M1108395.3', 'L2728247.1', 'L2728247.2', 'L2728247.3', 'L2804271.2', 'L2916234.1', 'L2673316.1', 'N1138607.1', 'N1138607.2', 'N1138607.3', 'L3159448.1', 'L3159448.2', 'L3159448.3', 'L3048890.3', 'M1166402.3', 'L3010563.1', 'L2841623.1', 'M1125940.2', 'L2991908.1', 'L3178973.1', 'M1047826.2', 'M1047767.2', 'L2879068.2', 'M1026844.1', 'M1026844.2', 'L3066819.1', 'L3104853.3', '221-311359.1', '221-311359.2', '221-311359.3', 'L3234149.1', 'L3234149.2', 'L3234149.3', 'N1139537.1', 'L2673346.1', 'L2673346.2', 'L2673346.3', 'L3254210.3', 'L2955005.2', 'M1108372.2', 'L2936268.3', 'L2688692.1', 'L2688692.2', 'L2688692.3', 'M1108286.1', 'M1108286.2', 'M1108286.3', 'L2804247.2', 'M1047744.1', 'L3178971.1', 'L3728040.1', 'L3728041.1', 'M1069509.1', 'M1069509.2', 'M1069509.3', 'L2766738.1', 'L2766738.2', 'L2766738.3', 'L3104128.1', 'L2673315.1', 'L3047289.1', 'L3047289.2', 'L3047289.3', 'L2785516.2', 'L3048963.2', 'D5799561-2_INT.1', 'D5799561-2_INT.2', 'D5799561-2_INT.3', 'M1069199.3', 'L2785525.3', 'L3198356.3', 'L3197641.1', 'L2973161.1', 'E183493.1', 'E183493.2', 'E183493.3', 'M1125902.1', 'M1125902.2', 'M1125902.3', 'L3085402.1', 'M1026394.1', 'M1047768.2', 'P827554.2', 'L2991909.1', 'M1026736.2', 'M1026986.1', 'M1026986.2', 'M1026986.3', 'M1026997.1', 'M1026997.2', 'M1026997.3', 'M4118755.1', 'M1026978.1', 'M1026978.2', 'M1026978.3', 'M1026979.1', 'M1026979.2', 'M1026979.3', 'L3082981.3', 'L3235275.1', 'L3235275.2', 'L3235275.3', 'M1026347.1', 'M1026347.2', 'M1026347.3', 'M3768670.2', 'M3768670.3', 'L2915534.1', 'L2710519.1', 'M1026820.1', 'L3141403.1', 'L3197633.1', 'M1069500.1', 'M1069500.2', 'M1069500.3', 'M1069382.1', 'M1069382.2', 'M1069382.3', 'N1147866.1', 'L2710537.2', 'M1026935.2', 'M1108364.3', 'L2897789.2', 'M1026466.2', 'L3160878.3', 'L2917336.3', 'M1026977.1', 'M1026977.2', 'M1026977.3', 'P895082.2', 'L3214112.2', 'L3160104.2', 'L2973144.3', 'L2748152.2', 'M1108387.1', 'M1108387.2', 'M1108387.3', 'L2955055.2', 'M1108311.1', 'M1108311.2', 'L2991907.1', 'M1047812.2', 'M4350438.2', 'N1142103.1', 'N1142103.2', 'N1142103.3', 'L3104830.1', 'L3104830.2', 'L3104830.3', 'L3197626.3', 'M1047483.1', 'M1047483.2', 'M1047483.3', 'M4277837.1', 'M4277837.2', 'M4277837.3', 'L3160102.1', 'L3160102.2', 'L3160102.3', 'P827514.1', 'P827514.2', 'P827514.3', 'L3160793.3', 'N1147860.3', 'L3177881.3', 'D5835167-6_INT.1', 'D5835167-6_INT.2', 'D5835167-6_INT.3', 'Q14414.1', 'Q14414.2', 'Q14414.3', 'L3048221.1', 'L3048221.2', 'L3048221.3', 'L2748128.3', 'L2913406.2', 'M1069563.1', 'N1136360.1', 'M1166366.1', 'M1166366.2', 'M1166366.3', '196-29518.1', '196-29518.2', '196-29518.3', 'L2805035.1', 'M1026713.1', 'L2991922.1', 'L2991922.2', 'L2991922.3', 'M1047339.2', 'M1047339.3', 'L3104145.2', 'M1027013.1', 'M1027013.2', 'M1027013.3', 'M1027023.1', 'M1027023.3', 'L3649298.1', 'M1047388.2', 'L3048211.1', 'L2766725.3', 'L2673311.1', 'M1027043.1', 'M1027043.2', 'M1027055.2', 'M1027055.3', 'L3008279.1', 'L2785537.1', 'P827498.1', 'N1136032.1', 'M1009834.2', '221-240991.1', 'L3066817.1', 'M1026662.2', 'L2673319.1', 'L2673319.2', 'L2673319.3', 'N1136993.1', 'L3104121.1', 'L3104113.1', 'L3104856.1', 'L2785518.3', 'M1108393.1', 'M1069494.3', 'L2745806.3', '193-48013.1', 'L3157710.2', 'M1089176.3', 'M1089179.3', 'M1108257.2', 'M1108340.3', 'L2916605.3', '196-29521.2', 'L2804245.2', 'N1140527.3', 'L3254915.2', 'L3727708.1', 'L3160105.3', 'L3235251.3', 'M1142798.2', 'M1142801.2', 'M1010016.1', 'L3251807.1', 'L2992657.1', 'M1069597.2', 'L3197653.2', 'L2991929.2', 'M1026851.2', 'M1026851.3', 'M3949154.1', 'L2895449.1', 'L2895449.2', 'L2895449.3', 'M1069463.2', 'L3086074.3', 'N1138595.2', 'M3036167.2', 'L3143999.1', 'L3143999.2', 'L3143999.3', 'M1069451.3', 'L3160115.2', 'L2935567.2', 'L3253570.3', 'N1137989.3', 'L3122814.3', 'L2935556.2', 'M1009651.1', 'M1009651.2', 'M1009651.3', 'M1026655.1', 'N1141474.1', 'M1047737.3', 'M1026387.1', 'M1166361.1', 'L2692661.1', 'M1047522.1', 'N1136664.1', 'M1027039.1', 'M1027039.3', 'M1026320.2', 'L2879079.2', 'M1047649.1', 'M1047649.2', 'M1047649.3', 'M1026341.2', 'M1026341.3', 'L3216361.2', 'M1125913.2', 'L3048209.2', 'L2896685.1', 'L2896685.2', 'L2896685.3', 'L2748135.1', 'L2767409.2', 'M1166400.3', 'M1047435.1', 'L2970841.1', 'L3091052.1', 'N1137960.1', 'N1137960.2', 'N1137960.3', 'M1047309.1', 'M1047309.2', 'M1047309.3', 'M1047732.1', 'M1047732.2', 'M1047737.1', 'M1047737.2', 'L3215340.1', '193-51796.1', 'M1069607.2', 'M1166398.3', 'L3142050.3', 'E184626.1', 'E184626.2', 'E184626.3', 'M1166377.1', 'M1166377.2', 'M1166377.3', 'L2989432.2', 'L3066830.2', 'M1209774.1', 'M1209774.2', 'M1209774.3', 'M1026693.2', 'L2991916.2', 'M1069365.3', 'L3235243.3', 'P827502.1', 'M1026960.2', 'M1026960.3', 'M1026970.1', 'M1026970.2', 'M1026970.3', 'L3727712.1', 'L3236011.2', 'L3198358.2', 'M1108316.3', 'L2860486.3', 'M1027000.1', 'M1027000.2', 'M1027000.3', 'L2916608.1', 'L2916608.2', 'L2916608.3', 'M1108514.3', 'L2673300.2', 'N1139255.1', 'D6108141-1_INT.1', 'D6108141-1_INT.2', 'D6108141-1_INT.3', 'E206209.1', 'E206209.2', 'E206209.3', 'M1047521.1', 'M1047521.2', 'M1047521.3', 'L3030126.3', 'L3254870.3', 'L2915542.1', 'L2915542.2', 'L2915542.3', 'L3085401.1', 'L3010557.1', 'L3254213.1', 'L3254213.2', 'L3254213.3', 'M1069738.2', 'L2690941.2', 'L2748839.2', 'D5712486-1_INT.3', 'E206210.3', 'L2876812.1', 'M1069497.1', 'M1069497.2', 'M1069497.3', 'N1144664.3', 'L3178972.3', 'N1147864.1', 'M3327097.2', 'L3448661.2', 'M1009828.2', 'L2766715.2', 'P827561.3', 'M1026705.3', 'P827573.2', 'L2972930.1', 'L2879067.1', 'L3235252.2', 'P827527.1', 'P827527.2', 'P827527.3', 'L2785517.3', '221-559682.3', 'L3082993.1', 'M3016088.1', 'L3122821.1', 'L3122821.2', 'L3122821.3', 'M1047486.2', 'M1047486.3', 'D5867591-1_INT.1', 'D5867591-1_INT.2', 'D5867591-1_INT.3', 'M1026658.2', 'M1026658.3', 'L2730108.3', 'M1008733.2', 'M1026354.1', 'M1026354.2', 'M1026354.3', 'M1026309.2', 'L2804260.2', 'L3085395.1', 'M1026767.1', 'L3141401.1', 'L3104120.2', 'M1026896.1', 'P860847.1', 'M1026905.2', 'M1026905.3', 'M1108344.3', 'M1108353.3', 'L2763811.3', 'L3235256.1', 'L3235256.2', 'L3235256.3', 'M3019248.2', 'M3021569.2', 'L3254230.1', 'L2814529.1', 'L2814529.2', 'L2814529.3', 'L2689727.1', 'L2860484.2', '221-703009.3', 'L3150961.3', 'L2711225.3', 'L3030200.3', 'M1186063.1', 'M1186063.2', 'M1186063.3', 'L2879054.1', 'N1136661.3', 'L2689691.1', 'L2689691.2', 'L2689691.3', 'M1009763.1', 'M1009763.3', 'N1136353.2', 'L2820535.2', 'L2727795.3', 'M1166368.1', 'L3086098.1', 'L3030197.1', 'L3030197.2', 'L3030197.3', 'L2822867.2', 'D6049822-1_INT.1', 'M1047323.1', 'M1089174.3', 'P827501.3', 'M3037441.2', 'M3037441.3', 'L3104859.2', 'L3101194.3', 'L2862616.3', 'M1026829.1', 'M1026829.3', 'M1069205.3', 'E182746.1', 'E182746.2', 'E182746.3', 'M1010015.1', 'L3066813.2', 'L2991910.2', 'M1108331.3', 'L2785531.1', 'L3179646.1', 'L3179646.2', 'L3179646.3', 'L3066818.2', 'L2954345.3', 'L2804255.2', 'M1108356.3', 'L2842390.3', 'P829975.3', 'L3160871.3', 'M1047338.1', 'L2691953.1', 'L2767408.3', 'L3728037.1', 'P895113.3', 'M1166396.3', 'M1166399.3', 'M1108507.1', 'L3108449.1', 'L3160109.1', 'L3160109.2', 'L3160109.3', 'P901936.3', 'M1108267.2', 'N1145956.1', 'L2729412.1', 'L3160107.1', 'L3160107.2', 'L3160107.3', 'L2897766.3', 'M1026798.1', 'L2952014.1', 'L2748125.3', 'L2673303.3', 'L2879753.2', 'L2914324.1', 'L2876847.2', 'M1047787.2', 'L2691942.2', 'M1026393.1', 'N1140821.3', 'L3189188.3', 'N1136365.1', 'N1136365.2', 'N1136365.3', 'M1069517.1', 'M1069517.2', 'M1069517.3', 'L3254228.2', 'N1137956.3', 'M1142814.1', 'M1142814.2', 'M1142814.3', 'L3217053.3', 'M1026357.3', 'L3178997.3', 'M1125903.1', 'M1069488.3', 'L2764412.1', 'N1136030.2', 'L2785513.1', 'M1209782.1', 'L3217056.1', 'M1009827.2', 'M1069201.3', 'M1047406.1', 'L2691947.1', 'M1047766.2', 'L3216344.2', 'P830058.3', 'M1089199.1', 'M1089199.2', 'M1089199.3', 'M1089197.1', 'M1089197.2', 'M1089197.3', 'N1140526.3', 'M3763620.3', 'L2729207.3', '228-961799-3_INT.3', 'M1108335.3', 'M1027036.2', 'L3010580.2', 'M1010003.1', 'P901933.1', 'L3141394.2', 'M1069465.1', 'L3104154.3', 'L3104155.3', 'D6047588-1_INT.2', 'F739844.2', 'L3104130.2', 'L2841625.3', 'L3010566.3', 'M1027038.2', 'L2935568.2', 'M1047293.1', 'M1047293.2', 'M1047293.3', 'M1047292.1', 'M1047292.2', 'P901905.2', 'M1026330.1', 'M1026330.3', 'L2897777.1', 'L2897777.2', 'L2897777.3', 'L2860488.2', 'L3122811.1', 'L2897774.2', 'L3254211.2', 'M1069513.1', 'M1069513.2', 'M1069513.3', 'L2691938.2', 'L2804256.1', 'L2804256.2', 'L2804256.3', 'M1047688.3', 'L2822863.3', 'M1069505.1', 'M1069505.2', 'M1069505.3', 'M1047311.1', 'L2748158.1', 'L3254234.2', 'P903360.1', 'L3214064.2', 'N1140523.3', 'L2766724.3', 'M1069554.2', 'M1108526.1', 'M1108526.2', 'M1108526.3', 'N1139251.3', 'L3011229.1', 'M1166362.1', 'L3197639.1', 'L3085391.2', 'L2691952.1', 'L2691952.2', 'L2691952.3', 'L2897781.1', 'D6049825-1_INT.1', 'D6049825-1_INT.2', 'D6049825-1_INT.3', 'E182748.1', 'E182748.2', 'E182748.3', 'L2691950.3', 'L2916609.3', 'M1047558.2', 'M1047558.3', 'M1069498.1', 'M1069498.2', 'M1069498.3', 'M1069499.1', 'M1069499.2', 'M1069499.3', 'L3104132.1', 'L2805034.1', 'L2822866.1', 'L2822866.2', 'L2822866.3', 'M1047688.1', 'M1047688.2', 'P827563.2', 'L3160100.2', 'L3085390.2', 'L2954361.2', 'E182744.2', 'L2801895.2', 'L2691973.1', 'M1047671.1', 'M1026984.1', 'M1026984.2', 'M1026984.3', 'M1209751.2', 'P827505.3', 'L3066829.3', 'L2879063.2', 'N1140528.1', 'L3649297.1', 'N1140817.1', 'N1140817.2', 'N1140817.3', 'N1136029.2', 'N1136028.1', 'N1136028.2', 'N1136028.3', 'N1139258.3', 'M1142875.1', 'M1142875.2', 'M1142875.3', 'M1026895.3', 'L2820528.3', 'N1138608.3', 'L3048230.3', 'N1139260.1', 'N1139260.2', 'N1139260.3', 'L2925506.1', 'L2925506.2', 'L2925506.3', 'L2729434.2', 'M1069549.1', 'M1069549.2', 'M1069549.3', 'L2970811.1', 'N1137988.1', 'P829798.1', 'L2841621.1', 'L2841621.2', 'L2841621.3', 'N1137986.1', 'N1137986.2', 'N1137986.3', 'N1141479.1', 'L3198348.1', 'L2876813.1', 'L3104118.3', 'L2748126.3', 'M1166394.3', 'L0247171.2', 'L3179607.2', 'L2861197.3', 'L3160896.3', 'L3067506.3', 'L3029497.3', 'L3047073.3', '221-559681.3', 'L3104133.1', 'L3122819.3', 'L3048889.3', 'M1027068.3', 'L3235268.3', 'L3008232.2', 'M1149249.3', 'M1026896.2', 'M1026896.3', 'M1142808.2', 'M1027100.1', 'L3140238.1', 'L3235257.1', 'L3235257.2', 'L3235257.3', 'L3010564.3', 'M1069481.1', 'M1069481.2', 'L2691946.2', 'L3139103.1', 'M1026732.1', 'M1026866.2', 'M1026866.3', 'E182723.3', 'L3119793.2', 'M1047371.2', 'M1026807.1', 'M1026807.2', 'M1026807.3', 'N1140521.1', 'N1140521.2', 'N1140521.3', 'L3066807.3', 'N1138606.3', 'M1069335.3', 'N1142102.1', 'L2804956.1', 'M1047777.2', 'L3254212.2', 'L2820533.1', 'L2879055.3', 'M1047434.1', 'M1026665.1', 'L3232933.1', 'L3104115.2', 'L3086075.2', 'M1108484.1', 'M1108484.2', 'M1108484.3', 'L2822857.2', 'L3104126.3', 'P827542.2', 'M1209807.1', 'M1209807.2', 'M1209807.3', 'M1209805.1', 'M1209805.2', 'M1209805.3', 'L2989565.1', 'E182733.1', 'E182733.2', 'E182733.3', 'L2806553.3', 'L3122813.1', 'L2729411.1', 'L2935555.1', 'M3037453.1', 'L3215203.1', 'L3215203.2', 'L3215203.3', 'M1026812.1', 'L3122847.1', 'N1138594.1', 'M1026679.1', 'L3141396.3', 'L3066808.3', 'M3036170.1', 'M3036170.2', 'M3036170.3', 'N1136362.1', 'M1026773.1', 'L3195751.1', 'M1026660.1', 'L3085410.2', 'M1026670.1', 'M1026670.2', 'M1026670.3', 'L3178982.1', 'M1125988.1', 'M1125988.2', 'M1125988.3', 'L3197636.2', 'M1089132.3', 'L2876798.1', 'L2876798.2', 'L2876798.3', 'M1069457.2', 'M1069457.3', 'N1136660.1', 'L3104136.1', 'L3104136.2', 'L3104136.3', 'L3048888.3', 'D5587291-3_INT.1', 'D5587291-3_INT.2', 'D5587291-3_INT.3', '190-8581.1', '190-8581.2', '190-8581.3', 'L3197644.1', 'M1009843.2', 'L3251806.2', 'M1069516.1', 'M1069516.2', 'M1069516.3', 'L3251830.1', 'L2804249.1', 'L2804249.2', 'L2804249.3', 'L2935557.1', 'M1069250.3', 'L2690868.3', 'L3030204.1', 'L3030204.2', 'L3030204.3', 'L3179637.3', 'M1108262.2', 'M1108261.2', 'D5513564-1_INT.1', 'D5513564-1_INT.2', 'D5513564-1_INT.3', 'E192201.1', 'E192201.2', 'E192201.3', 'R20185.1', 'R20185.2', 'R20185.3', 'L3181545.1', 'L3181545.2', 'L3181545.3', 'N1138603.1', 'N1138603.2', 'N1138603.3', 'L3178976.1', 'L3065665.1', 'L2785514.1', 'L2710536.1', 'L2936216.3', 'M1026969.2', 'L3048231.2', 'M1069175.1', 'M1069175.2', 'M1069328.3', 'D6198039-1_INT.1', 'D6198039-1_INT.2', 'D6198039-1_INT.3', 'E206217.1', 'E206217.2', 'E206217.3', 'M1047552.1', 'M1047552.3', 'L2879071.2', 'L3029504.2', 'M1026796.1', 'M1026796.2', 'M1026796.3', 'M1026795.1', 'M1026795.2', 'P827553.2', 'L2804251.1', 'M1069133.1', 'L2764399.2', 'P895117.2', 'L2842383.1', 'L2842383.2', 'L2842383.3', 'M1166368.2', 'M1166368.3', 'L2745811.3', 'L2804252.1', 'L3066815.1', 'L3066815.2', 'L3066815.3', 'P895075.3', 'L2710544.1', 'N1140519.1', 'N1140519.2', 'N1140519.3', 'L3160117.2', 'L3029510.2', 'E182731.2', 'N1136658.1', 'N1136658.2', 'N1136658.3', 'M1047566.2', 'M1047566.3', 'L2730149.1', 'L2730149.2', 'L2730149.3', 'L2860500.2', 'L3216347.3', 'L2767341.1', 'L2767341.2', 'L2767341.3', 'E206211.1', 'E206211.2', 'E206211.3', 'N1134480.1', 'N1134480.2', 'N1134480.3', 'M1209791.2', 'M1209791.3', 'L3030203.3', 'L2879773.1', 'L2879773.2', 'L2879773.3', 'L2804282.3', 'N1137005.1', 'N1137005.2', 'N1137005.3', 'M1047574.1', 'M1047574.2', 'M1047574.3', 'L3225319.2', 'L3048201.2', 'M1126025.1', 'L2823545.1', 'L3160108.2', 'N1134478.1', 'N1134478.2', 'N1134478.3', 'L3029055.2', 'M1047577.1', 'M1047577.2', 'M1047577.3', 'M1209797.1', 'M1209797.2', 'M1209797.3', 'L3645811.3', 'L3254229.2', 'L2710521.1', 'M1026824.1', 'M1026824.2', 'M1009807.1', 'M1009807.2', 'M1009807.3', 'N1136672.3', 'L3253995.3', 'L2841638.3', 'L2860492.3', 'L2691959.2', 'L2973159.1', 'L2822859.2', 'L2973158.3', 'L2674052.3', 'M1125990.1', 'M1125990.2', 'M1125990.3', 'N1136366.1', 'N1136366.2', 'N1136366.3', 'L2916620.1', 'L2916620.2', 'L2916620.3', 'M1026472.2', 'M1026939.2', 'L3104124.2', 'L3233412.1', 'L3235266.3', 'L3235267.3', 'L3235248.3', 'L3217064.2', 'L3200222.2', 'L3729297.1', 'L3197625.3', 'L2917333.1', 'N1140516.3', 'M1209748.2', 'L3142099.2', 'L2898457.1', 'M1166376.1', 'M1166376.2', 'M1166376.3', 'L2842384.1', 'L2842384.2', 'L2842384.3', 'L2763407.3', 'M1069438.1', 'M1069438.2', 'D6023352-1_INT.1', 'D6023352-1_INT.2', 'D6023352-1_INT.3', 'M1047750.1', 'L2708293.1', 'L3176656.1', 'M1047548.1', 'M1047548.2', 'M1047548.3', 'M1089185.1', 'M1089185.2', 'M1089185.3', 'L2748781.1', 'M1026695.1', 'M1026695.2', 'M1026695.3', 'N1140818.1', 'N1140818.2', 'N1140818.3', 'L2860501.2', 'M1209800.3', 'L2839332.3', 'L2954353.1', 'L2726974.2', 'L2785527.1', 'L2766729.1', 'M1069376.2', 'M1108534.2', 'M1108534.3', 'M1027005.2', 'L3176660.2', 'M1125943.3', 'M1026874.1', 'M1125969.2', 'L2673343.2', 'L2764436.2', 'D5565090-1_INT.2', 'L3029495.2', 'N1134479.1', 'N1134479.2', 'N1134479.3', 'L2823592.1', 'L2823592.2', 'L2823592.3', 'L2933164.1', 'L2933164.2', 'L2933164.3', 'L2992624.1', 'L2992624.2', 'L2992624.3', 'L3232301.3', 'M1010017.1', 'L2858175.1', 'M1009820.2', 'L3045895.3', 'L2841618.1', 'M1209817.1', 'M1209817.2', 'M1209817.3', 'L2785547.2', '221-311595.3', 'F739841.2', 'L0247160.2', 'L3122823.2', 'L3048966.3', 'M1142810.2', 'M1027109.1', 'L3101788.1', 'P903490.3', 'L2916603.2', 'L3160106.1', 'D5563942-4_INT.1', 'D5563942-4_INT.2', 'D5563942-4_INT.3', 'Q16483.1', 'Q16483.2', 'Q16483.3', 'M1069514.1', 'M1069514.2', 'M1069514.3', 'P850083.1', 'P850083.2', 'P850083.3', 'L3178988.2', 'L3010568.1', 'M1026357.1', 'M1026357.2', 'M1026356.1', 'M1026356.2', 'M1026356.3', 'L2989600.1', 'M1026487.2', 'M1069348.3', 'L2804248.2', 'L2729413.1', 'L2673314.3', 'L2785528.2', 'L2897773.1', 'L3010567.3', 'L2991917.2', 'L2766730.2', 'M1166407.3', 'M1008753.2', 'M1047419.1', 'M1089207.1', 'M1089207.2', 'M1089207.3', 'M1047572.1', 'M1047572.2', 'M1047572.3', 'M1108329.3', 'N1138599.1', 'N1138599.2', 'N1138599.3', 'L3217057.1', '193-103041.3', 'L2785515.3', 'M1069206.3', 'L2729424.1', 'L2917359.1', 'M3037538.1', 'L3027133.1', 'L3197627.3', 'M1069187.1', 'L2748129.1', 'D6290228-6_INT.1', 'D6290228-6_INT.2', 'D6290228-6_INT.3', 'Q16642.1', 'Q16642.2', 'Q16642.3', 'N1136657.1', 'N1136657.2', 'N1136657.3', 'L3027671.1', 'M1108423.1', 'N1136665.1', 'L2710532.3', 'L2785526.2', 'M1047522.2', 'M1047522.3', 'L2857591.1', 'M1142860.2', 'M1142860.3', 'L2841630.3', 'L3312692.1', 'M1069495.1', 'M1069495.2', 'M1069495.3', 'L3179678.1', 'L3179678.2', 'L3179678.3', 'M1149225.2', 'R42246.1', 'R42246.2', 'R42246.3', 'L3632979.1', 'P841985.2', 'L3104796.3', 'N1141476.1', 'L2785519.1', 'L3104122.1', 'L3197618.1', 'E192258.1', 'E192258.2', 'E192258.3', 'D5534970-1_INT.1', 'D5534970-1_INT.2', 'D5534970-1_INT.3', 'L2841633.1', 'L2841633.2', 'L2841633.3', 'L3254206.2', 'N1145954.1', 'N1145954.2', 'N1145954.3', 'P827580.1', 'P827580.2', 'P827580.3', 'L2955074.1', 'L2955074.2', 'L2955074.3', 'L2970845.2', 'L3010585.1', 'L2861219.2', 'L3104135.1', 'L3254203.2', 'L2954352.3', 'M1047400.1', 'L2842379.1', 'L2916617.2', 'N1136670.1', 'N1136670.2', 'N1136670.3', 'L2766727.2', 'L2727019.1', 'L2801909.1', 'L2801909.2', 'L2801909.3', 'M1047831.2', 'L2748131.2', 'L2729427.2', 'L2766717.3', 'L2879064.1', 'L3195318.2', 'L3254204.1', 'L2973148.1', 'L2801902.2', 'M1125969.1', 'M1125969.3', 'L2748146.1', 'N1139549.1', 'N1138593.1', 'L3197624.2', 'M1069558.2', 'L3197654.1', 'L2710505.2', 'L2879065.2', 'M1166358.3', 'L2898522.1', 'L2992556.3', '196-35813.1', '196-35813.2', '196-35813.3', 'L3064514.3', 'L3141402.3', 'L2859391.2', 'L2860489.1', 'M1026989.2', 'M1209752.2', 'L2710514.2', 'L2726975.2', 'L3649306.1', 'L2767407.2', 'L2730107.3', 'M4113347.3', 'L3216339.2', 'D5472341-1_INT.2', 'F739842.2', 'L2897792.1', 'M1026800.1', 'M1026800.2', 'M1026800.3', 'M1026797.1', 'M1026797.2', 'M1026797.3', 'L2729407.2', 'L3342743.3', 'L3122818.3', 'M1047430.1', 'L3048203.2', 'L2936276.2', 'L2860499.2', 'P827564.3', 'L3030205.3', 'M1026655.2', 'L3008248.1', 'L2804250.3', 'L2954354.1', 'L2673321.1', 'L3197634.2', 'L3141389.1', 'M1069376.1', 'M1069376.3', 'L2935559.1', 'P895087.1', 'L3254217.1', 'L3254217.2', 'L3254217.3', 'L3101782.1', 'L2745799.3', 'L3082983.2', 'L2691966.2', 'N1136368.1', 'L3197642.3', 'M1209800.1', 'M1209800.2', 'L2973157.1', 'L2935550.3', 'D5865224-1_INT.2', 'L3066821.1', 'M1009691.1', 'M1026830.1', 'M1026830.2', 'L3178975.2', 'M1069518.1', 'M1069518.2', 'M1069518.3', 'L2916618.2', 'L2710515.3', 'L3235258.1', 'L3235258.2', 'L3235258.3', 'L3141395.3', 'N1136997.3', 'L3104123.3', '190-7361.1', '190-7361.2', '190-7361.3', 'M4113347.1', 'M4113347.2', 'L3645812.3', '228-1353934-4_INT.3', 'L3254214.2', 'D5686080-1_INT.1', 'D5686080-1_INT.2', 'D5686080-1_INT.3', 'L2766749.1', 'L2766749.2', 'L2766749.3', 'L2692660.1', 'L2955076.1', 'M1125979.3', 'L3160114.1', 'L3235245.3', 'M1026876.1', 'M1026876.2', 'M1026876.3', 'L2785535.2', 'L2973150.1', 'L3160113.2', 'L2710518.1', 'L3195310.1', 'L3142098.2', 'M1026784.3', 'L2897771.2', 'L2917255.3', 'L3254215.3', 'L2989571.1', 'L3179699.2', 'L3029507.2', 'L2748124.2', 'D5958866-1_INT.1', 'D5958866-1_INT.2', 'D5958866-1_INT.3', 'L2861218.1', 'L2861218.2', 'L2861218.3', 'L0247162.2', 'L2935552.3', 'M1142810.1', 'M1142810.3', 'L3216350.1', 'L3197660.2', 'M1026880.1', 'L2822860.2', 'L3101787.1', 'L3027132.1', 'L3179673.3', 'L2879092.3', 'L2803199.1', 'L2803199.2', 'L2803199.3', 'L3254208.3', 'M1027014.3', 'M1047763.3', 'M1047433.1', 'L2991905.1', 'L2935560.3', 'L3085400.3', 'L2764403.1', 'M1108535.1', 'M1108535.2', 'M1108535.3', 'L2785521.3', 'L3216988.2', 'L3649305.1', 'L2983432.1', 'L3315860.2', 'M1125966.2', 'M1047497.1', 'M1047497.3', 'L2729423.3', 'D6140776-1_INT.1', 'L2673307.3', 'L2685809.1', 'L3254209.3', 'L2860477.1', 'P827548.1', 'L3048946.3', 'L2839331.1', 'L2973180.2', 'L3066806.3', 'L2785529.3', 'L3177894.1', 'L2731712.2', 'L2917310.2', 'D5682346-3_INT.1', 'D5682346-3_INT.2', 'D5682346-3_INT.3', 'L3085394.3', 'L3236004.3', 'L2879066.2', 'L3048214.1', 'L3120504.1', 'P827537.1', '228-979371-2_INT.3', '193-48013.3', 'L2785543.2', 'M1047837.2', 'L2916602.1', 'D6140778-1_INT.2', 'L2766748.1', 'REGXFMR_190-8581.1', 'REGXFMR_190-8581.2', 'REGXFMR_190-8581.3', 'L3104129.1', 'M1027110.1', 'L3047058.1', 'L2801949.2', 'L2710525.3', 'L3197640.3', 'L3010561.1', 'L3141390.2', 'D5746546-1_INT.3', 'D5956499-2_INT.1', 'D5956499-2_INT.2', 'D5956499-2_INT.3', 'L2823592_CAP.1', 'L2823592_CAP.2', 'L2823592_CAP.3', 'Q16642_CAP.1', 'Q16642_CAP.2', 'Q16642_CAP.3', 'Q16483_CAP.1', 'Q16483_CAP.2', 'Q16483_CAP.3', '157345.1', '157345.2', '157345.3', '157346.1', '157346.2', '157346.3', '165442.1', '165442.2', '165442.3', '298160.1', '298160.2', '298160.3', '165448.1', '165448.2', '165448.3', '275354.1', '275354.2', '275354.3', '165449.1', '165449.2', '165449.3', '165450.1', '165450.2', '165450.3', '165453.1', '165453.2', '165453.3', '165454.1', '165454.2', '165454.3', '165451.1', '165451.2', '165451.3', '238402.1', '238402.2', '238402.3', '165455.1', '165455.2', '165455.3', '165456.1', '165456.2', '165456.3', '165452.1', '165452.2', '165452.3', '283563.1', '283563.2', '283563.3', '165457.1', '165457.2', '165457.3', '165458.1', '165458.2', '165458.3', '165459.1', '165459.2', '165459.3', '165460.1', '165460.2', '165460.3', '165461.1', '165461.2', '165461.3', '165463.1', '165463.2', '165463.3', '165462.1', '165462.2', '165462.3', '165465.1', '165465.2', '165465.3', '165466.1', '165466.2', '165466.3', '165467.1', '165467.2', '165467.3', '165468.1', '165468.2', '165468.3', '165475.1', '165475.2', '165475.3', '165476.1', '165476.2', '165476.3', '165477.1', '165477.2', '165477.3', '273626.1', '273626.2', '273626.3', '165469.1', '165469.2', '165469.3', '165480.1', '165480.2', '165480.3', '165478.1', '165478.2', '165478.3', '165479.1', '165479.2', '165479.3', '165484.1', '165484.2', '165484.3', '165483.1', '165483.2', '165483.3', '261839.1', '261839.2', '261839.3', '261838.1', '261838.2', '261838.3', '165486.1', '165486.2', '165486.3', '165485.1', '165485.2', '165485.3', '165487.1', '165487.2', '165487.3', '165488.1', '165489.1', '165491.1', '165490.1', '165494.1', '165492.1', '165493.1', '283952.1', '283952.2', '283952.3', '165500.1', '165500.2', '165500.3', '165501.1', '165501.2', '165501.3', '165495.1', '165495.2', '165495.3', '165503.1', '165503.2', '165503.3', '165504.1', '165504.2', '165504.3', '181883.1', '181883.2', '181883.3', '158676.1', '158676.2', '158676.3', '181889.1', '181889.2', '181889.3', '181890.1', '181890.2', '181890.3', '181891.1', '181891.2', '181891.3', '181892.1', '181892.2', '181892.3', '181884.1', '181884.2', '181884.3', '181886.1', '181886.2', '181886.3', '181888.1', '181888.2', '181888.3', '181885.1', '181885.2', '181885.3', '181887.1', '181887.2', '181887.3', '181893.1', '181893.2', '181893.3', '181894.1', '181894.2', '181894.3', '181895.1', '181895.2', '181895.3', '181896.1', '181896.2', '181896.3', '181897.1', '181897.2', '181897.3', '181898.1', '181899.1', '181900.1', '181901.1', '181902.1', '181908.3', '181903.3', '181904.3', '181905.3', '181909.3', '181907.3', '181906.3', '181910.2', '181911.2', '181916.2', '181915.2', '181912.2', '181913.2', '181914.2', '181917.1', '181917.2', '181917.3', '181920.1', '181920.2', '181920.3', '181918.1', '181918.2', '181918.3', '181919.1', '181919.2', '181919.3', '152566.1', '152566.2', '152566.3', '181925.1', '181925.2', '181925.3', '181926.1', '181926.2', '181926.3', '181927.1', '181927.2', '181927.3', '181928.1', '181928.2', '181928.3', '181924.1', '181924.2', '181924.3', '181933.3', '181934.3', '255317.1', '255317.2', '255317.3', '181929.1', '181929.2', '181929.3', '181936.1', '181936.2', '181936.3', '181932.1', '181932.2', '181932.3', '181939.1', '181939.2', '181939.3', '181940.1', '181940.2', '181940.3', '181937.1', '181937.2', '181937.3', '181938.1', '181938.2', '181938.3', '181941.1', '181941.2', '181941.3', '181943.3', '181944.3', '181945.1', '181945.2', '181945.3', '181942.1', '181942.2', '181942.3', '236964.1', '181946.1', '181953.1', '181954.1', '181947.1', '181950.1', '181948.1', '181951.1', '181952.1', '181949.1', '181955.1', '181956.1', '236966.1', '181957.3', '181958.3', '181967.3', '181966.3', '181965.3', '181959.3', '181963.3', '181964.3', '181960.3', '181961.3', '181962.3', '181969.1', '181969.2', '181969.3', '181970.1', '181970.2', '181970.3', '181971.1', '181971.2', '181971.3', '181972.1', '181972.2', '181972.3', '181973.1', '181973.2', '181973.3', '181974.1', '181974.2', '181974.3', '181968.1', '181968.2', '181968.3', '181979.1', '181979.2', '181979.3', '181976.1', '181976.2', '181976.3', '181977.1', '181977.2', '181977.3', '181978.1', '181978.2', '181978.3', '181975.2', '181982.2', '181980.1', '181980.2', '181980.3', '181981.1', '181981.2', '181981.3', '261881.1', '261881.2', '261881.3', '181987.1', '181987.2', '181987.3', '181988.1', '181988.2', '181988.3', '181985.1', '181985.2', '181985.3', '181986.1', '181986.2', '181986.3', '181989.1', '181989.2', '181989.3', '181992.1', '181992.2', '181992.3', '181990.1', '181990.2', '181990.3', '181991.1', '181991.2', '181991.3', '181993.1', '181993.2', '181993.3', '181994.1', '181994.2', '181994.3', '181995.1', '181995.2', '181995.3', '181996.1', '181996.2', '181996.3', '181997.1', '181997.2', '181997.3', '181998.1', '181998.2', '181998.3', '181999.1', '181999.2', '181999.3', '182000.1', '182000.2', '182000.3', '182001.1', '182001.2', '182001.3', '182002.1', '182002.2', '182002.3', '182003.1', '182003.2', '182003.3', '182004.1', '182004.2', '182004.3', '182005.1', '182005.2', '182005.3', '182006.1', '182006.2', '182006.3', '210023.1', '210023.2', '210023.3', '182012.1', '182012.2', '182012.3', '182013.1', '182013.2', '182013.3', '182015.1', '182015.2', '182015.3', '182016.1', '182016.2', '182016.3', '182011.1', '182011.2', '182011.3', '182014.1', '182014.2', '182014.3', '182018.1', '182018.2', '182018.3', '182019.1', '182019.2', '182019.3', '182020.1', '182020.2', '182020.3', '182017.1', '182017.2', '182017.3', '182022.1', '182022.2', '182022.3', '182021.1', '182021.2', '182021.3', '182024.1', '182024.2', '182024.3', '182025.1', '182025.2', '182025.3', '182023.1', '182023.2', '182023.3', '215930.1', '215930.2', '215930.3', '182027.1', '182027.2', '182027.3', '247589.1', '247589.2', '247589.3', '182030.1', '182030.2', '182030.3', '182148.1', '182148.2', '182148.3', '182149.1', '182149.2', '182149.3', '182153.1', '182153.2', '182153.3', '182152.1', '182152.2', '182152.3', '182154.1', '182154.2', '182154.3', '215932.1', '215932.2', '215932.3', '182155.1', '182155.2', '182155.3', '182156.1', '182156.2', '182156.3', '182157.1', '182157.2', '182157.3', '182158.1', '182158.2', '182158.3', '182159.1', '182159.2', '182159.3', '182160.1', '182160.2', '182160.3', '232292.1', '232292.2', '232292.3', '182161.1', '182161.2', '182161.3', '182162.1', '182162.2', '182162.3', '189961.2', '189961.3', '189960.2', '189960.3', '189962.1', '189962.2', '189962.3', '189960.1', '189963.1', '189963.2', '189963.3', '189950.2', '189949.2', '189948.2', '194050.2', '189951.1', '194048.1', '194049.1', '194054.1', '194055.1', '194056.1', '194057.1', '194058.3', '194053.3', '194052.3', '194051.3', '194065.3', '194064.3', '194063.3', '194062.3', '194061.2', '194060.2', '194059.2', '202181.1', '202181.2', '202181.3', '182007.1', '182007.2', '182007.3', '318412.1', '318412.2', '318412.3', '253843.1', '253843.2', '253843.3', '233811.2', '221728.1', '221728.2', '221728.3', '221729.1', '221729.2', '221729.3', '221730.1', '221730.2', '221730.3', '233812.2', '182026.2', '232293.1', '232294.1', '232294.2', '232294.3', '232497.1', '232497.2', '232497.3', '261837.1', '261837.2', '261837.3', '236963.1', '236965.1', '243937.1', '243937.2', '243937.3', '315933.1', '315933.2', '315933.3', '238403.1', '238403.2', '238403.3', '243936.1', '243936.2', '243936.3', '157347.1', '157347.2', '157347.3', '253842.1', '253842.2', '253842.3', '247590.1', '247590.2', '247590.3', '255318.1', '255318.2', '255318.3', '255322.1', '255322.2', '255322.3', '255334.1', '255334.2', '255334.3', '255335.1', '255335.2', '255335.3', '255418.1', '255418.2', '255418.3', '255419.1', '255419.2', '255419.3', '181935.1', '181935.2', '181935.3', '261836.1', '261836.2', '261836.3', '261880.1', '261880.2', '261880.3', '280598.1', '280598.2', '280598.3', '280596.1', '280596.2', '280596.3', '280597.1', '280597.2', '280597.3', '280600.1', '280600.2', '280600.3', '282273.1', '282274.1', '282275.1', '283565.1', '283565.2', '283565.3', '283566.1', '283566.2', '283566.3', '283567.1', '283567.2', '283567.3', '283954.1', '283954.2', '283954.3', '283955.1', '283955.2', '283955.3', '283956.1', '283956.2', '283956.3', '287274.1', '287274.2', '287274.3', '287275.1', '287275.2', '287275.3', '298159.1', '298159.2', '298159.3', '298161.1', '298161.2', '298161.3', '298162.1', '298162.2', '298162.3', 'HVMV_SUB_HSB.1', 'HVMV_SUB_HSB.2', 'HVMV_SUB_HSB.3', 'EPRI_CKT7.1', 'EPRI_CKT7.2', 'EPRI_CKT7.3', 'REGXFMR_HVMV_SUB_LSB.1', 'REGXFMR_HVMV_SUB_LSB.2', 'REGXFMR_HVMV_SUB_LSB.3', 'CKT7.1', 'CKT7.2', 'CKT7.3']
length = len(NameList)
NameToIndex = {}
IndexToName = {}
i = 0
for name in NameList:
    NameToIndex[name] = i
    IndexToName[i] = name
    i+=1
def RXMatrix(File):
    RMatrix = np.zeros(shape=(length,length))
    XMatrix = np.zeros(shape=(length,length))
    with open(File) as file:
        lines = file.readlines()
        i =0 
        for line in lines:
            if(line[0]=='['):
                i+=1
                index1 = line.find(',')
                row = int(line[1:index1])
                index2 = line.find(']')
                col = int(line[index1+1:index2])
                index1 = line.find('=')
                index2 = line.find('+')
                real = float(line[index1+1:index2])
                index1 = line.find('j')
                imag = float(line[index1+1:])
                #if any([row == 2, row == 3822, row == 3825]):
                #    print(row,col)
                #    print(IndexToName[row-1],IndexToName[col-1])
                #if any([row == 3823, row == 3, row == 3826]):
                #   if(row!=col):
                #        print(row,col)
                #        print(IndexToName[row-1],IndexToName[col-1])
                #print(row,col,real,imag)
                Y_complex = complex(real,imag)
                Y_complex = 1/Y_complex
                RMatrix[row-1,col-1] = -Y_complex.real
                RMatrix[col-1,row-1] = -Y_complex.real
                RMatrix[col-1,row-1] = -Y_complex.real
                XMatrix[row-1,col-1] = -Y_complex.imag
                XMatrix[col-1,row-1] = -Y_complex.imag
    return RMatrix, XMatrix
#print(NameToIndex['REGXFMR_190-8581.1'])

#SOURCEBUS.1
#HVMV_SUB_HSB.1
#REGXFMR_HVMV_SUB_LSB.1
#print(NameToIndex['SOURCEBUS.2'],NameToIndex['HVMV_SUB_HSB.2'],NameToIndex['REGXFMR_HVMV_SUB_LSB.2'])

#print(NameToIndex['REGXFMR_190-8593.1'])
#print(NameToIndex['190-8593.1'])

RMatrix, XMatrix = RXMatrix(File)
## missing edge for phase 1
#[('HVMV_SUB_HSB.1','SOURCEBUS.1'),('HVMV_SUB_HSB.1', 'SOURCEBUS.1'),('REGXFMR_HVMV_SUB_LSB.1', '_HVMV_SUB_LSB.1'),('REGXFMR_HVMV_SUB_LSB.1', 'HVMV_SUB_HSB.1'),('HVMV_SUB_48332.1','_HVMV_SUB_LSB.1')]

#For phase one
lineOne  = 'C:/Users/lzy11/Desktop/11000_node_system/11000_node_system/Lines11.dss'
GPhaseOne,GPhaseOne_main,GPhaseOne_1,GPhaseOne_2,GPhaseOne_3,GPhaseOne_4 = create_phase1(lineOne)
print('------------phase_one------------')
print(nx.is_tree(GPhaseOne))
# weight to GPhaseOne
#print(list(GPhaseOne.neighbors('SOURCEBUS.1')))
GPhaseOne_weight = nx.Graph()
for edge in GPhaseOne.edges:
    index1 = NameToIndex[edge[0]]
    index2 = NameToIndex[edge[1]]
    #print(index1,index2,edge[0],edge[1])
    #print(RMatrix[index1,index2])
    #print(XMatrix[index1,index2])
    #print(edge,RMatrix[index1,index2],XMatrix[index1,index2])
    GPhaseOne_weight.add_edge(edge[0],edge[1],R=RMatrix[index1,index2],X=XMatrix[index1,index2])
print(nx.is_tree(GPhaseOne_weight))
####maybe errors NameToIndex['Q14404.1'] NameToIndex['190-7361.1'] weight is 0
### bus0 is set to be _HVMV_SUB_LSB.1
#num_node = len(GPhaseOne_weight.nodes)

#print(nx.is_tree(GPhaseOne))

#print(list(GPhaseOne.neighbors('REGXFMR_190-8581.1')))
#print(nx.is_tree(GPhaseOne))
#print(NameToIndex['REGXFMR_190-8581.1'])

file_name = "./result_RX/RXMatrix_1_test.data"
file_pointer = open(file_name, 'wb')
RLinear = np.zeros(shape=(length,length))
XLinear = np.zeros(shape=(length,length))

perm = list(combinations(list(GPhaseOne_weight), 2))
print(len(perm))
j = 0
for item in list(perm):
    j+=1
    if((j%1000)==0):
        print(j)
        break
    path1 = nx.dijkstra_path(GPhaseOne_weight,'SOURCEBUS.1', item[0], 'R')
    path2 = nx.dijkstra_path(GPhaseOne_weight,'SOURCEBUS.1', item[1], 'R')
    index1 = NameToIndex[item[0]]
    index2 = NameToIndex[item[1]]
    #print(path1)
    #print(path2)
    minLen = min(len(path1),len(path2))
    node = 'SOURCEBUS.1'
    for i in range(minLen):
        if path1[i] == path2[i]:
            node = path1[i]
        else:
            break
    #print(node)
    weight_R = nx.dijkstra_path_length(GPhaseOne_weight, 'SOURCEBUS.1', node,'R')
    weight_X = nx.dijkstra_path_length(GPhaseOne_weight, 'SOURCEBUS.1', node,'X')
    #print(weight_R,weight_X)
    RLinear[index1,index2] = weight_R
    RLinear[index2,index1] = weight_R
    XLinear[index1,index2] = weight_X
    XLinear[index2,index1] = weight_X  
    #print(weight_R,weight_X,index1,index2)
    ######X matrix
    
pickle.dump([RLinear,XLinear],file_pointer)
file_pointer.close()

###lack some basic edges[source bus, HVMV,regu
file_name = './result_RX/RXMatrix_1_test.data'
file_open = open(file_name, 'rb')
[R,X] = pickle.load(file_open)
#print(R[3473,2700:3000])

#print(NameToIndex['SOURCEBUS.1'])
#print(NameToIndex['HVMV_SUB_HSB.1'])
#print(NameToIndex['REGXFMR_HVMV_SUB_LSB.1'])

#print(list(GPhaseOne.neighbors('_HVMV_SUB_LSB.1')))
#print(list(GPhaseOne.neighbors('_HVMV_SUB_LSB.1')))

#nx.dijkstra_path(GPhaseOne_weight, 'SOURCEBUS.1', 'SOURCEBUS.1', 'R')

#########################phase_2
import networkx as nx
import matplotlib.pyplot as plt
lineOne  = 'C:/Users/lzy11/Desktop/11000_node_system/11000_node_system/Lines22.dss'
G = nx.Graph()
with open(lineOne) as file:
    lines = file.readlines()
    i = 0
    for line in lines:
        if line[0]=='N':
            i+=1
            temp = line.split(' ')
            temp = [item for item in temp if item!='']
            G.add_node(temp[2][5:].upper())
            G.add_node(temp[3][5:].upper())
            G.add_edge(temp[2][5:].upper(),temp[3][5:].upper())
G.add_edge('REGXFMR_190-8593.1','190-8593.1')
G.add_edge('REGXFMR_190-8581.1','190-8581.1')
G.add_edge('REGXFMR_190-7361.1','190-7361.1')
miss_edge=[('HVMV_SUB_HSB.1','SOURCEBUS.1'),('REGXFMR_HVMV_SUB_LSB.1', '_HVMV_SUB_LSB.1'),('REGXFMR_HVMV_SUB_LSB.1', 'HVMV_SUB_HSB.1'),('HVMV_SUB_48332.1','_HVMV_SUB_LSB.1')]
G.add_edges_from(miss_edge)
G.add_edge('SOURCEBUS.1','EPRI_CKT7.1')
G.add_edge('EPRI_CKT7.1','CKT7.1')
G.add_edge('CKT7.1','318412.1')
#graphs = list(nx.connected_component_subgraphs(G))
#print(len(graphs))
print('------------phase_two------------')
print(nx.is_tree(G))

# first subtree
G_1 = nx.Graph()
G.remove_edge('L3081380.1','M1142843.1')
bfs = list(nx.bfs_edges(G,'L3081380.1'))
#print(len(bfs))
#print(bfs)
G.add_edge('L3081380.1','M1142843.1')
G_1.add_edges_from(bfs)
#second subtree
G_2 = nx.Graph()
G.remove_edge('M1047515.1','M1047513.1')
bfs = list(nx.bfs_edges(G,'M1047513.1'))
#print(len(bfs))
#print(bfs)
G.add_edge('M1047515.1','M1047513.1')
G_2.add_edges_from(bfs)
# third subtree
G_3 = nx.Graph()
G.remove_edge('L3066815.1','196-29519.1')
bfs = list(nx.bfs_edges(G,'L3066815.1'))
#print(len(bfs))
#print(bfs)
G.add_edge('L3066815.1','196-29519.1')
G_3.add_edges_from(bfs)

# fourth subtree
G_4 = nx.Graph()
G.remove_edge('SOURCEBUS.1','EPRI_CKT7.1')
bfs = list(nx.bfs_edges(G,'EPRI_CKT7.1'))
G.add_edge('SOURCEBUS.1','EPRI_CKT7.1')
G_4.add_edges_from(bfs)
#print(len(G_4.edges),len(G_4.nodes))
# main subtree
#for node in G.neighbors('196-29519.1'):
#    print(node)
G_main = nx.Graph()
G.remove_edge('SOURCEBUS.1','EPRI_CKT7.1')
G.remove_edge('L3066815.1','196-29519.1')
G.remove_edge('M1047515.1','M1047513.1')
G.remove_edge('L3081380.1','M1142843.1')
bfs = list(nx.bfs_edges(G,'M1142843.1'))
#print(bfs)
#print(len(bfs))
G.add_edge('L3081380.1','M1142843.1')
G.add_edge('M1047515.1','M1047513.1')
G.add_edge('L3066815.1','196-29519.1')
G.add_edge('SOURCEBUS.1','EPRI_CKT7.1')
G_main.add_edges_from(bfs)
# The clusters are stored in G_1,G_2,G_3 and G_main
total = len(G.nodes)
num_1 = len(G_1.nodes)
num_2 = len(G_2.nodes)
num_3 = len(G_3.nodes)
num_4 = len(G_4.nodes)
num_main = len(G_main.nodes)
print(total,num_1+num_2+num_3+num_4+num_main)
#print(nx.is_tree(G))
partion = './result_Partition/PhaseTwo.data'
store = open(partion, 'wb')
pickle.dump([G,G_1,G_2,G_3,G_4,G_main],store)

G_new = nx.Graph()
for node in G.nodes:
    G_new.add_node(node[:-2]+'.2')
for edge in G.edges:
    G_new.add_edge(edge[0][:-2]+'.2',edge[1][:-2]+'.2')
    
file_name = './result_RX/RXMatrix_1_test.data'
file_open = open(file_name, 'rb')
[RLinear,XLinear] = pickle.load(file_open)
file_open.close()
GPhaseTwo_weight = nx.Graph()
for edge in G_new.edges:
    index1 = NameToIndex[edge[0]]
    index2 = NameToIndex[edge[1]]
    #print(index1,index2,edge[0],edge[1])
    #print(RMatrix[index1,index2])
    #print(XMatrix[index1,index2])
    #print(edge,RMatrix[index1,index2],XMatrix[index1,index2])
    GPhaseTwo_weight.add_edge(edge[0],edge[1],R=RMatrix[index1,index2],X=XMatrix[index1,index2])

print(nx.is_tree(GPhaseTwo_weight))    
    
perm = list(combinations(list(GPhaseTwo_weight), 2))
print(len(perm))
j = 0
for item in list(perm):
    j+=1
    if((j%1000)==0):
        print(j)
        break
    path1 = nx.dijkstra_path(GPhaseTwo_weight,'SOURCEBUS.2', item[0], 'R')
    path2 = nx.dijkstra_path(GPhaseTwo_weight,'SOURCEBUS.2', item[1], 'R')
    index1 = NameToIndex[item[0]]
    index2 = NameToIndex[item[1]]
    #print(path1)
    #print(path2)
    minLen = min(len(path1),len(path2))
    node = 'SOURCEBUS.2'
    for i in range(minLen):
        if path1[i] == path2[i]:
            node = path1[i]
        else:
            break
    #print(node)
    weight_R = nx.dijkstra_path_length(GPhaseTwo_weight, 'SOURCEBUS.2', node,'R')
    weight_X = nx.dijkstra_path_length(GPhaseTwo_weight, 'SOURCEBUS.2', node,'X')
    #print(weight_R,weight_X)
    RLinear[index1,index2] = weight_R
    RLinear[index2,index1] = weight_R
    XLinear[index1,index2] = weight_X
    XLinear[index2,index1] = weight_X  
    #print(weight_R,weight_X,index1,index2)
    ######X matrix 
file_name = './result_RX/RXMatrix_2_test.data'
file_open = open(file_name, 'wb')
pickle.dump([RLinear,XLinear],file_open)
file_open.close()

#############################Phase_3
import networkx as nx
import matplotlib.pyplot as plt
lineOne  = 'C:/Users/lzy11/Desktop/11000_node_system/11000_node_system/Lines33.dss'
G = nx.Graph()
with open(lineOne) as file:
    lines = file.readlines()
    i = 0
    for line in lines:
        if line[0]=='N':
            i+=1
            temp = line.split(' ')
            temp = [item for item in temp if item!='']
            G.add_node(temp[2][5:].upper())
            G.add_node(temp[3][5:].upper())
            G.add_edge(temp[2][5:].upper(),temp[3][5:].upper())
G.add_edge('REGXFMR_190-8593.1','190-8593.1')
G.add_edge('REGXFMR_190-8581.1','190-8581.1')
G.add_edge('REGXFMR_190-7361.1','190-7361.1')
miss_edge=[('HVMV_SUB_HSB.1','SOURCEBUS.1'),('REGXFMR_HVMV_SUB_LSB.1', '_HVMV_SUB_LSB.1'),('REGXFMR_HVMV_SUB_LSB.1', 'HVMV_SUB_HSB.1'),('HVMV_SUB_48332.1','_HVMV_SUB_LSB.1')]
G.add_edges_from(miss_edge)
print(len(G.nodes))
print(len(G.edges))
graphs = list(nx.connected_component_subgraphs(G))
print(len(graphs))
G.remove_edge('228-1353934-4_INT.1','193-103041.1')
G.remove_edge('228-961799-3_INT.1','193-46661.1')
G.remove_edge('181932.1', '181933.1')
G.add_edge('SOURCEBUS.1','EPRI_CKT7.1')
G.add_edge('EPRI_CKT7.1','CKT7.1')
G.add_edge('CKT7.1','318412.1')
print('------------phase_one------------')
print(nx.is_tree(G))

'''
regxfmr_190-8593.1 \\main
regxfmr_190-7361.1  \\ first cluster
regxfmr_190-8581.1  \\ main
'''
# first subtree
G_1 = nx.Graph()
G.remove_edge('L3081380.1','M1142843.1')
bfs = list(nx.bfs_edges(G,'L3081380.1'))
#print(len(bfs))
#print(bfs)
G.add_edge('L3081380.1','M1142843.1')
G_1.add_edges_from(bfs)
#second subtree
G_2 = nx.Graph()
G.remove_edge('M1047515.1','M1047513.1')
bfs = list(nx.bfs_edges(G,'M1047513.1'))
#print(len(bfs))
#print(bfs)
G.add_edge('M1047515.1','M1047513.1')
G_2.add_edges_from(bfs)
# third subtree
G_3 = nx.Graph()
G.remove_edge('L3066815.1','196-29519.1')
bfs = list(nx.bfs_edges(G,'L3066815.1'))
#print(len(bfs))
#print(bfs)
G.add_edge('L3066815.1','196-29519.1')
G_3.add_edges_from(bfs)

# fourth subtree
G_4 = nx.Graph()
G.remove_edge('SOURCEBUS.1','EPRI_CKT7.1')
bfs = list(nx.bfs_edges(G,'EPRI_CKT7.1'))
G.add_edge('SOURCEBUS.1','EPRI_CKT7.1')
G_4.add_edges_from(bfs)
#print(len(G_4.edges),len(G_4.nodes))
# main subtree
#for node in G.neighbors('196-29519.1'):
#    print(node)
G_main = nx.Graph()
G.remove_edge('SOURCEBUS.1','EPRI_CKT7.1')
G.remove_edge('L3066815.1','196-29519.1')
G.remove_edge('M1047515.1','M1047513.1')
G.remove_edge('L3081380.1','M1142843.1')
bfs = list(nx.bfs_edges(G,'M1142843.1'))
#print(bfs)
#print(len(bfs))
G.add_edge('L3081380.1','M1142843.1')
G.add_edge('M1047515.1','M1047513.1')
G.add_edge('L3066815.1','196-29519.1')
G.add_edge('SOURCEBUS.1','EPRI_CKT7.1')
G_main.add_edges_from(bfs)
# The clusters are stored in G_1,G_2,G_3 and G_main
total = len(G.nodes)
num_1 = len(G_1.nodes)
num_2 = len(G_2.nodes)
num_3 = len(G_3.nodes)
num_4 = len(G_4.nodes)
num_main = len(G_main.nodes)
partion = './result_Partition/PhaseThree.data'
store = open(partion, 'wb')
pickle.dump([G,G_1,G_2,G_3,G_4,G_main],store)
#print(total,num_1+num_2+num_3+num_4+num_main)
#print(len(G.edges),len(G.nodes))
#print(nx.is_tree(G))

G_new = nx.Graph()
for node in G.nodes:
    G_new.add_node(node[:-2]+'.3')
for edge in G.edges:
    G_new.add_edge(edge[0][:-2]+'.3',edge[1][:-2]+'.3')

file_name = './result_RX/RXMatrix_2_test.data'
file_open = open(file_name, 'rb')
[RLinear,XLinear] = pickle.load(file_open)
file_open.close()
GPhaseThree_weight = nx.Graph()
for edge in G_new.edges:
    index1 = NameToIndex[edge[0]]
    index2 = NameToIndex[edge[1]]
    #print(index1,index2,edge[0],edge[1])
    #print(RMatrix[index1,index2])
    #print(XMatrix[index1,index2])
    #print(edge,RMatrix[index1,index2],XMatrix[index1,index2])
    GPhaseThree_weight.add_edge(edge[0],edge[1],R=RMatrix[index1,index2],X=XMatrix[index1,index2])

    
print(nx.is_tree(GPhaseThree_weight))   
perm = list(combinations(list(GPhaseThree_weight), 2))
print(len(perm))
j = 0
for item in list(perm):
    j+=1
    if((j%1000)==0):
        print(j)
        break
    path1 = nx.dijkstra_path(GPhaseThree_weight,'SOURCEBUS.3', item[0], 'R')
    path2 = nx.dijkstra_path(GPhaseThree_weight,'SOURCEBUS.3', item[1], 'R')
    index1 = NameToIndex[item[0]]
    index2 = NameToIndex[item[1]]
    #print(path1)
    #print(path2)
    minLen = min(len(path1),len(path2))
    node = 'SOURCEBUS.3'
    for i in range(minLen):
        if path1[i] == path2[i]:
            node = path1[i]
        else:
            break
    #print(node)
    weight_R = nx.dijkstra_path_length(GPhaseThree_weight, 'SOURCEBUS.3', node,'R')
    weight_X = nx.dijkstra_path_length(GPhaseThree_weight, 'SOURCEBUS.3', node,'X')
    #print(weight_R,weight_X)
    RLinear[index1,index2] = weight_R
    RLinear[index2,index1] = weight_R
    XLinear[index1,index2] = weight_X
    XLinear[index2,index1] = weight_X  
    #print(weight_R,weight_X,index1,index2)
    ######X matrix 
file_name = './result_RX/RXMatrix_3_test.data'
file_open = open(file_name, 'wb')
pickle.dump([RLinear,XLinear],file_open)
file_open.close()

###for the diagonal elements
file_name = './result_RX/RXMatrix_3.data'
file_open = open(file_name,'rb')
[RLinear,XLinear] = pickle.load(file_open)
file_open.close()

for node in list(GPhaseOne_weight.nodes):
    index = NameToIndex[node]
    weight_R = nx.dijkstra_path_length(GPhaseOne_weight, 'SOURCEBUS.1', node,'R')
    weight_X = nx.dijkstra_path_length(GPhaseOne_weight, 'SOURCEBUS.1', node,'X')    
    RLinear[index,index] = weight_R
    XLinear[index,index] = weight_X 


for node in list(GPhaseTwo_weight.nodes):
    index = NameToIndex[node]
    weight_R = nx.dijkstra_path_length(GPhaseTwo_weight, 'SOURCEBUS.2', node,'R')
    weight_X = nx.dijkstra_path_length(GPhaseTwo_weight, 'SOURCEBUS.2', node,'X')    
    RLinear[index,index] = weight_R
    XLinear[index,index] = weight_X 

for node in list(GPhaseThree_weight.nodes):
    index = NameToIndex[node]
    weight_R = nx.dijkstra_path_length(GPhaseThree_weight, 'SOURCEBUS.3', node,'R')
    weight_X = nx.dijkstra_path_length(GPhaseThree_weight, 'SOURCEBUS.3', node,'X')    
    RLinear[index,index] = weight_R
    XLinear[index,index] = weight_X 
file_name = './result_RX/RXMatrix_final.data'
file_open = open(file_name,'wb')
pickle.dump([RLinear,XLinear],file_open)
file_open.close()