import opendssdirect as dss
import numpy as np
import csv
import dss_function
import opt_function
import os
import math
import types
import inspect
import pickle
import networkx as nx
import matplotlib.pyplot as plt
import time


def Voltage(YVol,NodeNum):
    YMag = [0]*NodeNum
    for i in range(NodeNum):
        YMag[i] = math.sqrt(YVol[2*i]**2 + YVol[2*i+1]**2)
    return YMag
def BoundVol(AllNodeNames,circuit):
    length = len(AllNodeNames)
    VUpper = [0]*length
    VLower = [0]*length
    VBase = [0]*length
    for i in range(length):
        circuit.SetActiveBus(AllNodeNames[i])
        base = dss.Bus.kVBase()*1000
        VUpper[i] = base*1.05
        VLower[i] = base*0.95
        VBase[i] = base
    return VUpper,VLower,VBase

def getRXMatrix(File):
    file_open = open(File,'rb')
    [R,X] = pickle.load(file_open) 
    return R,X
def getPartition(File):
    file_open = open(File,'rb')
    [G,G_1,G_2,G_3,G_4,G_main] = pickle.load(file_open)
    return G,G_1,G_2,G_3,G_4,G_main

def getLoadPartition(File):
    file_open = open(File,'rb')
    [LoadToNode,LoadToCluster,Loads_G_11,Loads_G_12,Loads_G_13,Loads_G_14,Loads_G_1main,Loads_G_21,Loads_G_22,Loads_G_23,Loads_G_24,Loads_G_2main,Loads_G_31,Loads_G_32,Loads_G_33,Loads_G_34,Loads_G_3main] = pickle.load(file_open)
    return LoadToNode,LoadToCluster,Loads_G_11,Loads_G_12,Loads_G_13,Loads_G_14,Loads_G_1main,Loads_G_21,Loads_G_22,Loads_G_23,Loads_G_24,Loads_G_2main,Loads_G_31,Loads_G_32,Loads_G_33,Loads_G_34,Loads_G_3main
def Mapping(AllNodeNames):
    NameToIndex = {}
    IndexToName = {}
    i = 0
    for name in AllNodeNames:
        NameToIndex[name] = i
        IndexToName[i] = name
        i+=1
    return NameToIndex,IndexToName
###########initalPV##############
def getinitalPV(G):
    P_initial = {}
    Q_initial = {}
    for load in G:
        loadKW = '? Load.' + load.lower() + '.kw'
        loadKVar = '? Load.' + load.lower() + '.kvar'
        p = dss.run_command(loadKW)
        q = dss.run_command(loadKVar)
        P_initial[load] = float(p)
        Q_initial[load] = float(q)
    return P_initial,Q_initial

###calculate the S_k
def CalSignal(G):
    IndexSet = []
    signal = 0
    for node in list(G.nodes):
        IndexSet.append(NameToIndex[node])
    for index in IndexSet:
         signal += (Mu_Upper[index] - Mu_Lower[index])
    return signal
###Calculate the Inner_signal
def CalInner(G,Load):
    Node = LoadToNode[Load]
    inner_R = 0
    inner_X = 0
    for node in list(G.nodes):
        index = NameToIndex[node]
        inner_R += (Mu_Upper[index] - Mu_Lower[index])*RMatrix[index,index]
        inner_X += (Mu_Upper[index] - Mu_Lower[index])*XMatrix[index,index]
    return inner_R,inner_X

def RX_Com(G1,G2):
    Name1 = list(G1.nodes)[0]
    Name2 = list(G2.nodes)[0]
    Index1 = NameToIndex[Name1]
    Index2 = NameToIndex[Name2]
    weightR = RMatrix[Index1,Index2]
    weightX = XMatrix[Index1,Index2]
    return weightR,weightX

MainDir = os.path.dirname(os.getcwd())
dss.run_command("Compile 'C:/Users/XZHOU/Desktop/11000_node_system/11000_node_system/MasterWang.dss'")
circuit = dss.Circuit

AllNodeNames = circuit.YNodeOrder()
AllNodeNames = [str(node) for node in AllNodeNames]
node_number = len(AllNodeNames)
#print(AllNodeNames)

############getData##############
File_RX = 'C:/Users/XZHOU/Desktop/11000_node_system/python/result_RX/RXMatrix_final.data'
File_Phase1 = 'C:/Users/XZHOU/Desktop/11000_node_system/python/result_Partition/PhaseOne.data'
File_Phase2 = 'C:/Users/XZHOU/Desktop/11000_node_system/python/result_Partition/PhaseTwo.data'
File_Phase3 = 'C:/Users/XZHOU/Desktop/11000_node_system/python/result_Partition/PhaseThree.data'
File_load = 'C:/Users/XZHOU/Desktop/11000_node_system/python/result_Partition/LoadPartition.data'
G_1,G_11,G_12,G_13,G_14,G_1main = getPartition(File_Phase1) 
G_2,G_21,G_22,G_23,G_24,G_2main = getPartition(File_Phase2)
G_3,G_31,G_32,G_33,G_34,G_3main = getPartition(File_Phase3)  
LoadToNode,LoadToCluster,Loads_G_11,Loads_G_12,Loads_G_13,Loads_G_14,Loads_G_1main,Loads_G_21,Loads_G_22,Loads_G_23,Loads_G_24,Loads_G_2main,Loads_G_31,Loads_G_32,Loads_G_33,Loads_G_34,Loads_G_3main = getLoadPartition(File_load)
NameToIndex, IndexToName = Mapping(AllNodeNames)
RMatrix,XMatrix = getRXMatrix(File_RX)
VUpper,VLower,VBase = BoundVol(AllNodeNames,circuit)

YVol = circuit.YNodeVArray()
AllNodeVoltage = Voltage(YVol,node_number)
AllNodeVoltage_initial = AllNodeVoltage
BaseVoltage = Voltage(YVol,node_number)
AllLoadNames = dss.Loads.AllNames()
print(len(AllLoadNames))
#######parameters
Mu_Upper = [0]*node_number
Mu_Lower = [0]*node_number
signal_11 = CalSignal(G_11)
signal_12 = CalSignal(G_12)
signal_13 = CalSignal(G_13)
signal_14 = CalSignal(G_14)

signal_21 = CalSignal(G_21)
signal_22 = CalSignal(G_22)
signal_23 = CalSignal(G_23)
signal_24 = CalSignal(G_24)

signal_31 = CalSignal(G_31)
signal_32 = CalSignal(G_32)
signal_33 = CalSignal(G_33)
signal_34 = CalSignal(G_34)
#############initialPQ

#phaseOne
pLoadIni_11, qLoadIni_11 = getinitalPV(Loads_G_11)
pLoadIni_12, qLoadIni_12 = getinitalPV(Loads_G_12)
pLoadIni_13, qLoadIni_13 = getinitalPV(Loads_G_13)
pLoadIni_14, qLoadIni_14 = getinitalPV(Loads_G_14)
#phaseTwo
pLoadIni_21, qLoadIni_21 = getinitalPV(Loads_G_21)
pLoadIni_22, qLoadIni_22 = getinitalPV(Loads_G_22)
pLoadIni_23, qLoadIni_23 = getinitalPV(Loads_G_23)
pLoadIni_24, qLoadIni_24 = getinitalPV(Loads_G_24)
#phaseThree
pLoadIni_31, qLoadIni_31 = getinitalPV(Loads_G_31)
pLoadIni_32, qLoadIni_32 = getinitalPV(Loads_G_32)
pLoadIni_33, qLoadIni_33 = getinitalPV(Loads_G_33)
pLoadIni_34, qLoadIni_34 = getinitalPV(Loads_G_34)

##########fixed initial load
#phaseOne
pLoadIni_11_restore, qLoadIni_11_restore = getinitalPV(Loads_G_11)
pLoadIni_12_restore, qLoadIni_12_restore = getinitalPV(Loads_G_12)
pLoadIni_13_restore, qLoadIni_13_restore = getinitalPV(Loads_G_13)
pLoadIni_14_restore, qLoadIni_14_restore = getinitalPV(Loads_G_14)
#phaseTwo
pLoadIni_21_restore, qLoadIni_21_restore = getinitalPV(Loads_G_21)
pLoadIni_22_restore, qLoadIni_22_restore = getinitalPV(Loads_G_22)
pLoadIni_23_restore, qLoadIni_23_restore = getinitalPV(Loads_G_23)
pLoadIni_24_restore, qLoadIni_24_restore = getinitalPV(Loads_G_24)
#phaseThree
pLoadIni_31_restore, qLoadIni_31_restore = getinitalPV(Loads_G_31)
pLoadIni_32_restore, qLoadIni_32_restore = getinitalPV(Loads_G_32)
pLoadIni_33_restore, qLoadIni_33_restore = getinitalPV(Loads_G_33)
pLoadIni_34_restore, qLoadIni_34_restore = getinitalPV(Loads_G_34)


########CalR_Common
R_com = {}
X_com = {}

######PhaseOne################
weightR,weightX = RX_Com(G_11,G_12)
R_com['1_1_2'] = weightR
X_com['1_1_2'] = weightX
######################
weightR,weightX = RX_Com(G_11,G_13)
R_com['1_1_3'] = weightR
X_com['1_1_3'] = weightX
######################
weightR,weightX = RX_Com(G_11,G_14)
R_com['1_1_4'] = weightR
X_com['1_1_4'] = weightX
######################
weightR,weightX = RX_Com(G_12,G_13)
R_com['1_2_3'] = weightR
X_com['1_2_3'] = weightX
######################
weightR,weightX = RX_Com(G_12,G_14)
R_com['1_2_4'] = weightR
X_com['1_2_4'] = weightX
######################
weightR,weightX = RX_Com(G_13,G_14)
R_com['1_3_4'] = weightR
X_com['1_3_4'] = weightX

######PhaseTwo################
weightR,weightX = RX_Com(G_21,G_22)
R_com['2_1_2'] = weightR
X_com['2_1_2'] = weightX
######################
weightR,weightX = RX_Com(G_21,G_23)
R_com['2_1_3'] = weightR
X_com['2_1_3'] = weightX
######################
weightR,weightX = RX_Com(G_21,G_24)
R_com['2_1_4'] = weightR
X_com['2_1_4'] = weightX
######################
weightR,weightX = RX_Com(G_22,G_23)
R_com['2_2_3'] = weightR
X_com['2_2_3'] = weightX
######################
weightR,weightX = RX_Com(G_22,G_24)
R_com['2_2_4'] = weightR
X_com['2_2_4'] = weightX
######################
weightR,weightX = RX_Com(G_23,G_24)
R_com['2_3_4'] = weightR
X_com['2_3_4'] = weightX
######PhaseThree################
weightR,weightX = RX_Com(G_31,G_32)
R_com['3_1_2'] = weightR
X_com['3_1_2'] = weightX
######################
weightR,weightX = RX_Com(G_31,G_33)
R_com['3_1_3'] = weightR
X_com['3_1_3'] = weightX
######################
weightR,weightX = RX_Com(G_31,G_34)
R_com['3_1_4'] = weightR
X_com['3_1_4'] = weightX
######################
weightR,weightX = RX_Com(G_32,G_33)
R_com['3_2_3'] = weightR
X_com['3_2_3'] = weightX
######################
weightR,weightX = RX_Com(G_32,G_34)
R_com['3_2_4'] = weightR
X_com['3_2_4'] = weightX
######################
weightR,weightX = RX_Com(G_33,G_34)
R_com['3_3_4'] = weightR
X_com['3_3_4'] = weightX

iteration = 50
timeLine = list(range(iteration))
record_p_11 = [0]*iteration
record_q_11 = [0]*iteration
record_mU_11 = [0]*iteration
record_mL_11 = [0]*iteration
record_v_11  = [0]*iteration

record_p_12 = [0]*iteration
record_q_12 = [0]*iteration
record_mU_12 = [0]*iteration
record_mL_12 = [0]*iteration
record_v_12  = [0]*iteration

record_p_13 = [0]*iteration
record_q_13 = [0]*iteration
record_mU_13 = [0]*iteration
record_mL_13 = [0]*iteration
record_v_13  = [0]*iteration

record_p_14 = [0]*iteration
record_q_14 = [0]*iteration
record_mU_14 = [0]*iteration
record_mL_14 = [0]*iteration
record_v_14  = [0]*iteration

Target_11 = Loads_G_11[-10]
Target_12 = Loads_G_11[-5]
Target_13 = Loads_G_11[-7]
Target_14 = Loads_G_11[-8]
coff = 1.5
step_mu = 5e-4
step_pq = 5e-4
def project(num_p,num_q,ini_p,ini_q):
    p = 0
    q = 0
    if(ini_p > 0):
        p = min(max(num_p,0),coff*ini_p)
        q = min(max(num_q,0),coff*ini_q)
    else:
        p = max(min(num_p,0),coff*ini_p)
        q = max(min(num_q,0),coff*ini_q)
    return p,q
a = 0.01
record_loss = [0]*iteration
record_totalpower = [0]*iteration
record_losspercent = [0]*iteration
t0 = time.time()

load_change = 1

for i in range(iteration):
    print(i)
    
    if i == 51:
        load_change = 1
    elif i == 101:
        load_change = 1
    elif i == 151:
        load_change = 1
    elif i == 201:
        load_change = 1
    else:
        load_change = 1
        
        
    loss = dss.Circuit.LineLosses()[0]
    record_loss[i] = loss
    totalpower = dss.Circuit.TotalPower()[0]
    record_totalpower[i] = - totalpower
    record_losspercent[i] =  record_loss[i]/record_totalpower[i]
    ###########PhaseOne##############
    ###########G_11##################
    OutR_11 = signal_12*R_com['1_1_2'] + signal_13*R_com['1_1_3'] + signal_14*R_com['1_1_4']
    OutX_11 = signal_12*X_com['1_1_2'] + signal_13*X_com['1_1_3'] + signal_14*X_com['1_1_4']
    for load in Loads_G_11:
        inner_R, inner_X = CalInner(G_11,load)
        pLoadIni_11[load] = pLoadIni_11[load] - step_pq*(2*(pLoadIni_11[load] - pLoadIni_11_restore[load]) - OutR_11 - inner_R + a*loss)
        qLoadIni_11[load] = qLoadIni_11[load] - step_pq*(2*(qLoadIni_11[load] - qLoadIni_11_restore[load]) - OutX_11 - inner_X)
        pLoadIni_11[load] = load_change * pLoadIni_11[load]
        qLoadIni_11[load] = load_change * qLoadIni_11[load]
        ini_p = pLoadIni_11_restore[load]
        #print(ini_p)
        ini_q = qLoadIni_11_restore[load]
        #print(ini_q)
        pLoadIni_11[load],qLoadIni_11[load] = project(pLoadIni_11[load],qLoadIni_11[load],ini_p,ini_q)
        command = "edit load." + load + " kw=" + str(pLoadIni_11[load]) + " kvar=" + str(qLoadIni_11[load])
        dss.run_command(command)
    record_p_11[i] = pLoadIni_11[Target_11]
    record_q_11[i] = qLoadIni_11[Target_11]
    ###########G_12##################
    OutR_12 = signal_11*R_com['1_1_2'] + signal_13*R_com['1_2_3'] + signal_14*R_com['1_2_4']
    OutX_12 = signal_11*X_com['1_1_2'] + signal_13*X_com['1_2_3'] + signal_14*X_com['1_2_4']
    for load in Loads_G_12:
        inner_R, inner_X = CalInner(G_12,load)
        pLoadIni_12[load] = pLoadIni_12[load] - step_pq*(2*(pLoadIni_12[load] - pLoadIni_12_restore[load]) - OutR_12 - inner_R + a*loss)
        qLoadIni_12[load] = qLoadIni_12[load] - step_pq*(2*(qLoadIni_12[load] - qLoadIni_12_restore[load]) - OutX_12 - inner_X)
        pLoadIni_12[load] = load_change * pLoadIni_12[load]
        qLoadIni_12[load] = load_change * qLoadIni_12[load]
        ini_p = pLoadIni_12_restore[load]
        ini_q = qLoadIni_12_restore[load]
        pLoadIni_12[load],qLoadIni_12[load] = project(pLoadIni_12[load],qLoadIni_12[load],ini_p,ini_q)
        command = "edit load." + load + " kw=" + str(pLoadIni_12[load]) + " kvar=" + str(qLoadIni_12[load])
        dss.run_command(command)
        record_p_12[i] = pLoadIni_11[Target_12]
        record_q_12[i] = qLoadIni_11[Target_12]
    ###########G_13##################
    OutR_13 = signal_11*R_com['1_1_3'] + signal_12*R_com['1_2_3'] + signal_14*R_com['1_3_4']
    OutX_13 = signal_11*X_com['1_1_3'] + signal_12*X_com['1_2_3'] + signal_14*X_com['1_3_4']
    for load in Loads_G_13:
        inner_R, inner_X = CalInner(G_13,load)
        pLoadIni_13[load] = pLoadIni_13[load] - step_pq*(2*(pLoadIni_13[load] - pLoadIni_13_restore[load]) - OutR_13 - inner_R+ a*loss)
        qLoadIni_13[load] = qLoadIni_13[load] - step_pq*(2*(qLoadIni_13[load] - qLoadIni_13_restore[load]) - OutX_13 - inner_X)
        pLoadIni_13[load] = load_change * pLoadIni_13[load]
        qLoadIni_13[load] = load_change * qLoadIni_13[load]
        ini_p = pLoadIni_13_restore[load]
        ini_q = qLoadIni_13_restore[load]
        pLoadIni_13[load],qLoadIni_13[load] = project(pLoadIni_13[load],qLoadIni_13[load],ini_p,ini_q)
        command = "edit load." + load + " kw=" + str(pLoadIni_13[load]) + " kvar=" + str(qLoadIni_13[load])
        dss.run_command(command)
        record_p_13[i] = pLoadIni_11[Target_13]
        record_q_13[i] = qLoadIni_11[Target_13]
    ###########G_14##################
    OutR_14 = signal_11*R_com['1_1_4'] + signal_12*R_com['1_2_4'] + signal_13*R_com['1_3_4']
    OutX_14 = signal_11*X_com['1_1_4'] + signal_12*X_com['1_2_4'] + signal_13*X_com['1_3_4']
    for load in Loads_G_14:
        inner_R, inner_X = CalInner(G_14,load)
        pLoadIni_14[load] = pLoadIni_14[load] - step_pq*(2*(pLoadIni_14[load] - pLoadIni_14_restore[load]) - OutR_14 - inner_R+ a*loss)
        qLoadIni_14[load] = qLoadIni_14[load] - step_pq*(2*(qLoadIni_14[load] -qLoadIni_14_restore[load]) - OutX_14 - inner_X)
        pLoadIni_14[load] = load_change * pLoadIni_14[load]
        qLoadIni_14[load] = load_change * qLoadIni_14[load]
        ini_p = pLoadIni_14_restore[load]
        ini_q = qLoadIni_14_restore[load]
        pLoadIni_14[load],qLoadIni_14[load] = project(pLoadIni_14[load],qLoadIni_14[load],ini_p,ini_q)
        command = "edit load." + load + " kw=" + str(pLoadIni_14[load]) + " kvar=" + str(qLoadIni_14[load])
        dss.run_command(command)
        record_p_14[i] = pLoadIni_11[Target_14]
        record_q_14[i] = qLoadIni_11[Target_14]
    ###########PhaseTWo###############
    ###########G_21##################
    OutR_21 = signal_22*R_com['2_1_2'] + signal_23*R_com['2_1_3'] + signal_24*R_com['2_1_4']
    OutX_21 = signal_22*X_com['2_1_2'] + signal_23*X_com['2_1_3'] + signal_24*X_com['2_1_4']
    for load in Loads_G_21:
        inner_R, inner_X = CalInner(G_21,load)
        pLoadIni_21[load] = pLoadIni_21[load] - step_pq*(2*(pLoadIni_21[load] - pLoadIni_21_restore[load]) - OutR_21 - inner_R+ a*loss)
        qLoadIni_21[load] = qLoadIni_21[load] - step_pq*(2*(qLoadIni_21[load] -qLoadIni_21_restore[load]) - OutX_21 - inner_X)
        pLoadIni_21[load] = load_change * pLoadIni_21[load]
        qLoadIni_21[load] = load_change * qLoadIni_21[load]
        ini_p = pLoadIni_21_restore[load]
        ini_q = qLoadIni_21_restore[load]
        pLoadIni_21[load],qLoadIni_21[load] = project(pLoadIni_21[load],qLoadIni_21[load],ini_p,ini_q)
        command = "edit load." + load + " kw=" + str(pLoadIni_21[load]) + " kvar=" + str(qLoadIni_21[load])
        dss.run_command(command)
    ###########G_22##################
    OutR_22 = signal_21*R_com['2_1_2'] + signal_23*R_com['2_2_3'] + signal_24*R_com['2_2_4']
    OutX_22 = signal_21*X_com['2_1_2'] + signal_23*X_com['2_2_3'] + signal_24*X_com['2_2_4']
    for load in Loads_G_22:
        inner_R, inner_X = CalInner(G_22,load)
        pLoadIni_22[load] = pLoadIni_22[load] - step_pq*(2*(pLoadIni_22[load] - pLoadIni_22_restore[load]) - OutR_22 - inner_R+ a*loss)
        qLoadIni_22[load] = qLoadIni_22[load] - step_pq*(2*(qLoadIni_22[load] -qLoadIni_22_restore[load]) - OutX_22 - inner_X)
        pLoadIni_22[load] = load_change * pLoadIni_22[load]
        qLoadIni_22[load] = load_change * qLoadIni_22[load]
        ini_p = pLoadIni_22_restore[load]
        ini_q = qLoadIni_22_restore[load]
        pLoadIni_22[load],qLoadIni_22[load] = project(pLoadIni_22[load],qLoadIni_22[load],ini_p,ini_q)
        command = "edit load." + load + " kw=" + str(pLoadIni_22[load]) + " kvar=" + str(qLoadIni_22[load])
        dss.run_command(command)
    ###########G_23##################
    OutR_23 = signal_21*R_com['2_1_3'] + signal_22*R_com['2_2_3'] + signal_24*R_com['2_3_4']
    OutX_23 = signal_21*X_com['2_1_3'] + signal_22*X_com['2_2_3'] + signal_24*X_com['2_3_4']
    for load in Loads_G_23:
        inner_R, inner_X = CalInner(G_23,load)
        pLoadIni_23[load] = pLoadIni_23[load] - step_pq*(2*(pLoadIni_23[load] - pLoadIni_23_restore[load]) - OutR_23 - inner_R+ a*loss)
        qLoadIni_23[load] = qLoadIni_23[load] - step_pq*(2*(qLoadIni_23[load] -qLoadIni_23_restore[load]) - OutX_23 - inner_X)
        pLoadIni_23[load] = load_change * pLoadIni_23[load]
        qLoadIni_23[load] = load_change * qLoadIni_23[load]
        ini_p = pLoadIni_23_restore[load]
        ini_q = qLoadIni_23_restore[load]
        pLoadIni_23[load],qLoadIni_23[load] = project(pLoadIni_23[load],qLoadIni_23[load],ini_p,ini_q)
        command = "edit load." + load + " kw=" + str(pLoadIni_23[load]) + " kvar=" + str(qLoadIni_23[load])
        dss.run_command(command)
    ###########G_24##################
    OutR_24 = signal_21*R_com['2_1_4'] + signal_22*R_com['2_2_4'] + signal_23*R_com['2_3_4']
    OutX_24 = signal_21*X_com['2_1_4'] + signal_22*X_com['2_2_4'] + signal_23*X_com['2_3_4']
    for load in Loads_G_24:
        inner_R, inner_X = CalInner(G_24,load)
        pLoadIni_24[load] = pLoadIni_24[load] - step_pq*(2*(pLoadIni_24[load] - pLoadIni_24_restore[load]) - OutR_24 - inner_R+ a*loss)
        qLoadIni_24[load] = qLoadIni_24[load] - step_pq*(2*(qLoadIni_24[load] -qLoadIni_24_restore[load]) - OutX_24 - inner_X)
        pLoadIni_24[load] = load_change * pLoadIni_24[load]
        qLoadIni_24[load] = load_change * qLoadIni_24[load]
        ini_p = pLoadIni_24_restore[load]
        ini_q = qLoadIni_24_restore[load]
        pLoadIni_24[load],qLoadIni_24[load] = project(pLoadIni_24[load],qLoadIni_24[load],ini_p,ini_q)
        command = "edit load." + load + " kw=" + str(pLoadIni_24[load]) + " kvar=" + str(qLoadIni_24[load])
        dss.run_command(command)
    ###########PhaseThree###############
    ###########G_31##################
    OutR_31 = signal_32*R_com['3_1_2'] + signal_33*R_com['3_1_3'] + signal_34*R_com['3_1_4']
    OutX_31 = signal_32*X_com['3_1_2'] + signal_33*X_com['3_1_3'] + signal_34*X_com['3_1_4']
    for load in Loads_G_31:
        inner_R, inner_X = CalInner(G_31,load)
        pLoadIni_31[load] = pLoadIni_31[load] - step_pq*(2*(pLoadIni_31[load] - pLoadIni_31_restore[load]) - OutR_31 - inner_R+ a*loss)
        qLoadIni_31[load] = qLoadIni_31[load] - step_pq*(2*(qLoadIni_31[load] -qLoadIni_31_restore[load]) - OutX_31 - inner_X)
        pLoadIni_31[load] = load_change * pLoadIni_31[load]
        qLoadIni_31[load] = load_change * qLoadIni_31[load]
        ini_p = pLoadIni_31_restore[load]
        ini_q = qLoadIni_31_restore[load]
        pLoadIni_31[load],qLoadIni_31[load] = project(pLoadIni_31[load],qLoadIni_31[load],ini_p,ini_q)
        command = "edit load." + load + " kw=" + str(pLoadIni_31[load]) + " kvar=" + str(qLoadIni_31[load])
        dss.run_command(command)
    ###########G_32##################
    OutR_32 = signal_31*R_com['3_1_2'] + signal_33*R_com['3_2_3'] + signal_34*R_com['3_2_4']
    OutX_32 = signal_31*X_com['3_1_2'] + signal_33*X_com['3_2_3'] + signal_34*X_com['3_2_4']
    for load in Loads_G_32:
        inner_R, inner_X = CalInner(G_32,load)
        pLoadIni_32[load] = pLoadIni_32[load] - step_pq*(2*(pLoadIni_32[load] - pLoadIni_32_restore[load]) - OutR_32 - inner_R+ a*loss)
        qLoadIni_32[load] = qLoadIni_32[load] - step_pq*(2*(qLoadIni_32[load] -qLoadIni_32_restore[load]) - OutX_32 - inner_X)
        pLoadIni_32[load] = load_change * pLoadIni_32[load]
        qLoadIni_32[load] = load_change * qLoadIni_32[load]
        ini_p = pLoadIni_32_restore[load]
        ini_q = qLoadIni_32_restore[load]
        pLoadIni_32[load],qLoadIni_32[load] = project(pLoadIni_32[load],qLoadIni_32[load],ini_p,ini_q)
        command = "edit load." + load + " kw=" + str(pLoadIni_32[load]) + " kvar=" + str(qLoadIni_32[load])
        dss.run_command(command)
    ###########G_33##################
    OutR_33 = signal_31*R_com['3_1_3'] + signal_32*R_com['3_2_3'] + signal_34*R_com['3_3_4']
    OutX_33 = signal_31*X_com['3_1_3'] + signal_32*X_com['3_2_3'] + signal_34*X_com['3_3_4']
    for load in Loads_G_33:
        inner_R, inner_X = CalInner(G_33,load)
        pLoadIni_33[load] = pLoadIni_33[load] - step_pq*(2*(pLoadIni_33[load] - pLoadIni_33_restore[load]) - OutR_33 - inner_R+ a*loss)
        qLoadIni_33[load] = qLoadIni_33[load] - step_pq*(2*(qLoadIni_33[load] -qLoadIni_33_restore[load]) - OutX_33 - inner_X)
        pLoadIni_33[load] = load_change * pLoadIni_33[load]
        qLoadIni_33[load] = load_change * qLoadIni_33[load]
        ini_p = pLoadIni_33_restore[load]
        ini_q = qLoadIni_33_restore[load]
        pLoadIni_33[load],qLoadIni_33[load] = project(pLoadIni_33[load],qLoadIni_33[load],ini_p,ini_q)
        command = "edit load." + load + " kw=" + str(pLoadIni_33[load]) + " kvar=" + str(qLoadIni_33[load])
        dss.run_command(command)
    ###########G_34##################
    OutR_34 = signal_31*R_com['3_1_4'] + signal_32*R_com['3_2_4'] + signal_33*R_com['3_3_4']
    OutX_34 = signal_31*X_com['3_1_4'] + signal_32*X_com['3_2_4'] + signal_33*X_com['3_3_4']
    for load in Loads_G_34:
        inner_R, inner_X = CalInner(G_34,load)
        pLoadIni_34[load] = pLoadIni_34[load] - step_pq*(2*(pLoadIni_34[load] - pLoadIni_34_restore[load]) - OutR_34 - inner_R+ a*loss)
        qLoadIni_34[load] = qLoadIni_34[load] - step_pq*(2*(qLoadIni_34[load] -qLoadIni_34_restore[load]) - OutX_34 - inner_X)
        pLoadIni_34[load] = load_change * pLoadIni_34[load]
        qLoadIni_34[load] = load_change * qLoadIni_34[load]
        ini_p = pLoadIni_34_restore[load]
        ini_q = qLoadIni_34_restore[load]
        pLoadIni_34[load],qLoadIni_34[load] = project(pLoadIni_34[load],qLoadIni_34[load],ini_p,ini_q)
        command = "edit load." + load + " kw=" + str(pLoadIni_34[load]) + " kvar=" + str(qLoadIni_34[load])
        dss.run_command(command)

    dss.run_command("Solve") 
    YVol = circuit.YNodeVArray()
    AllNodeVoltage = Voltage(YVol,node_number)
    for j in range(node_number):
        Mu_Upper[j] = max(Mu_Upper[j] + step_mu*(AllNodeVoltage[j]-VUpper[j]),0)
        Mu_Lower[j] = max(Mu_Lower[j] + step_mu*(VLower[j]-AllNodeVoltage[j]),0)
    #########record###################
    record_name = LoadToNode[Target_11]
    record_index = NameToIndex[record_name]
    record_mU_11[i] = Mu_Upper[record_index]
    record_mL_11[i] = Mu_Lower[record_index]
    record_v_11[i]  = AllNodeVoltage[record_index]/VBase[record_index]
    print("CurrentVoltage11: "+repr(AllNodeVoltage[record_index]/VBase[record_index]))
    print("Mu_U11: " + repr(Mu_Upper[record_index]))
    print("Mu_L11: " + repr(Mu_Lower[record_index]))
    print("P11: "+ repr(pLoadIni_11[Target_11]))
    print("q11: "+ repr(qLoadIni_11[Target_11]))

    record_name = LoadToNode[Target_12]
    record_index = NameToIndex[record_name]
    record_mU_12[i] = Mu_Upper[record_index]
    record_mL_12[i] = Mu_Lower[record_index]
    record_v_12[i]  = AllNodeVoltage[record_index]/VBase[record_index]
    print("CurrentVoltage12: "+repr(AllNodeVoltage[record_index]/VBase[record_index]))
    print("Mu_U12: " + repr(Mu_Upper[record_index]))
    print("Mu_L12: " + repr(Mu_Lower[record_index]))
    print("P12: "+ repr(pLoadIni_11[Target_12]))
    print("q12: "+ repr(qLoadIni_11[Target_12]))

    record_name = LoadToNode[Target_13]
    record_index = NameToIndex[record_name]
    record_mU_13[i] = Mu_Upper[record_index]
    record_mL_13[i] = Mu_Lower[record_index]
    record_v_13[i]  = AllNodeVoltage[record_index]/VBase[record_index]
    print("CurrentVoltage13: "+repr(AllNodeVoltage[record_index]/VBase[record_index]))
    print("Mu_U13: " + repr(Mu_Upper[record_index]))
    print("Mu_L13: " + repr(Mu_Lower[record_index]))
    print("P13: "+ repr(pLoadIni_11[Target_13]))
    print("q13: "+ repr(qLoadIni_11[Target_13]))

    record_name = LoadToNode[Target_14]
    record_index = NameToIndex[record_name]
    record_mU_14[i] = Mu_Upper[record_index]
    record_mL_14[i] = Mu_Lower[record_index]
    record_v_14[i]  = AllNodeVoltage[record_index]/VBase[record_index]
    print("CurrentVoltage14: "+repr(AllNodeVoltage[record_index]/VBase[record_index]))
    print("Mu_U14: " + repr(Mu_Upper[record_index]))
    print("Mu_L14: " + repr(Mu_Lower[record_index]))
    print("P14: "+ repr(pLoadIni_11[Target_14]))
    print("q14: "+ repr(qLoadIni_11[Target_14]))

    ##################################
    signal_11 = CalSignal(G_11)
    signal_12 = CalSignal(G_12)
    signal_13 = CalSignal(G_13)
    signal_14 = CalSignal(G_14)

    signal_21 = CalSignal(G_21)
    signal_22 = CalSignal(G_22)
    signal_23 = CalSignal(G_23)
    signal_24 = CalSignal(G_24)

    signal_31 = CalSignal(G_31)
    signal_32 = CalSignal(G_32)
    signal_33 = CalSignal(G_33)
    signal_34 = CalSignal(G_34)
    print(signal_11,signal_12,signal_13,signal_14,signal_21,signal_22,signal_23,signal_24,signal_31,signal_32,signal_33,signal_34)
t1 = time.time()
#for node in list(G_11.nodes):
#    print(AllNodeVoltage[NameToIndex[node]]/VBase[NameToIndex[node]],BaseVoltage[NameToIndex[node]]/VBase[NameToIndex[node]])

print(t1-t0)
#plt.plot(timeLine, record_p)
#plt.plot(timeLine, record_q)
#plt.plot(timeLine, record_mU)
#plt.plot(timeLine, record_mL)
plt.figure(1)
plot_v_1=plt.plot(timeLine, record_v_11,'red')
plot_v_2=plt.plot(timeLine, record_v_12,'green')
plot_v_3=plt.plot(timeLine, record_v_13,'yellow')
plot_v_4=plt.plot(timeLine, record_v_14,'black')
plt.xlabel('Iteration number')
plt.ylabel('Voltage magnitude, p.u.')
plt.title('Voltage Convergence')
plt.grid(True)
plt.legend((plot_v_1[0], plot_v_2[0],plot_v_3[0], plot_v_4[0]), ('Subtree 1', 'Subtree 2','Subtree 3','Subtree 4'))



plt.figure(2)
length = len(AllNodeNames)
timeLine = list(range(length))
unit_voltage = []
unit_voltage_initial = []
for node in AllNodeNames:
    unit_voltage.append(AllNodeVoltage[NameToIndex[node]]/VBase[NameToIndex[node]])
    unit_voltage_initial.append(AllNodeVoltage_initial[NameToIndex[node]]/VBase[NameToIndex[node]])
plot_vc_1=plt.plot(timeLine,unit_voltage_initial)
plot_vc_2=plt.plot(timeLine,unit_voltage)
plt.xlabel('Node index')
plt.ylabel('Voltage magnitude, p.u.')
plt.title('Controlled Voltage')
plt.grid(True)
plt.legend((plot_vc_1[0], plot_vc_2[0]), ('Voltage w/o control', 'Voltage w/ control'))


plt.figure(3)
timeLine = list(range(iteration))
plt.plot(timeLine,record_loss)

plt.figure(4)
timeLine = list(range(iteration))
plt.plot(timeLine,record_losspercent)

#plt.figure(5)
#timeLine = list(range(iteration))
#plt.plot(timeLine,record_totalpower)

plt.show()
