# -*- coding: utf-8 -*-
"""
Created on Thu Aug  9 13:20:23 2018

@author: xzhou
"""

import numpy as np
from scipy.sparse import lil_matrix
import scipy.sparse.linalg as sp
import scipy.sparse as sparse
import math

def linear_voltage_model(Y00,Y01,Y11_inv, BIBC, V_vector_noLoad, V1,slack_no):
    # voltage linearlization
    V1_conj = np.conj(V1)
    V1_conj_inv = 1 / V1_conj
    coeff_Vp = Y11_inv * V1_conj_inv  # to accomodate kW/kVar
    coeff_Vq = -1j * coeff_Vp
    coeff_Vm = np.array(V_vector_noLoad[slack_no:])

    # voltage magnitude linearization
    m = coeff_Vm

    m_inv = 1 / coeff_Vm
    coeff_Vmag_k = abs(m)
    A = m_inv * coeff_Vp
    B = m_inv * coeff_Vq
    coeff_Vmag_p = coeff_Vmag_k * A.real
    coeff_Vmag_q = coeff_Vmag_k * B.real

    # # current linearization
    # coeff_I_p = BIBC*Y11*coeff_Vp
    # coeff_I_q = BIBC*Y11*coeff_Vq
    # coeff_I_r = BIBC*Y11*coeff_Vm + BIBC*Y10*V0
    #
    # # current magnitude linearization
    # r = coeff_I_r
    # coeff_Imag_p = []
    # coeff_Imag_q = []
    # for ii in range(len(r)):
    #     diag_r = r[ii]
    #     diag_r_inv = 1 / diag_r
    #     abs_diag_r = abs(diag_r)
    #     A = diag_r_inv * coeff_I_p[ii, :]
    #     B = diag_r_inv * coeff_I_q[ii, :]
    #     coeff_Imag_p.append(abs_diag_r * A.real)
    #     coeff_Imag_q.append(abs_diag_r * B.real)
    # coeff_Imag_p = np.array(coeff_Imag_p)
    # coeff_Imag_q = np.array(coeff_Imag_q)
    # coeff_Imag_k = abs(r)

    # # substation power linearization
    # diag_V0 = np.matrix([[complex(0, 0)] * slack_no] * slack_no)
    # for ii in range(slack_no):
    #     diag_V0[ii,ii] = V0[ii]
    # coeff_sub_g = diag_V0*np.conj(Y00)*np.matrix(np.conj(V0)).transpose()+diag_V0*np.conj(Y01)*np.matrix(np.conj(coeff_Vm)).transpose()
    # coeff_sub_p = diag_V0*np.conj(Y01)*np.conj(coeff_Vp)
    # coeff_sub_q = diag_V0*np.conj(Y01)*np.conj(coeff_Vq)

    # return [coeff_Vp,coeff_Vq,coeff_Vm,coeff_Vmag_p,coeff_Vmag_q,coeff_Vmag_k,coeff_I_p,
    #         coeff_I_q,coeff_I_r,coeff_Imag_p,coeff_Imag_q,coeff_Imag_k,coeff_sub_p,coeff_sub_q,coeff_sub_g]
    coeff_sub_p = coeff_sub_q = coeff_sub_g = []

    return [coeff_Vp, coeff_Vq, coeff_Vm, coeff_Vmag_p, coeff_Vmag_q, coeff_Vmag_k, coeff_sub_p, coeff_sub_q, coeff_sub_g]

def validate_linear_model(coeff_Vp,coeff_Vq,coeff_Vm,PQ_node,slack_number):
    V_cal = coeff_Vm + np.dot(coeff_Vp,np.array([np.real(ii)*1000 for ii in PQ_node[slack_number:]])) + np.dot(coeff_Vq,np.array([np.imag(ii)*1000 for ii in PQ_node[slack_number:]]))
    v_cal_1 = coeff_Vm + np.dot(coeff_Vp,np.conj(PQ_node[slack_number:]*1000))
    #coeff_Vp*Pnode + coeff_Vq*Qnode + coeff_Vm
    return [V_cal,v_cal_1]

def costFun(x,dual_upper,dual_lower,v1_pu,coeff_p,coeff_q,NPV,control_bus_index,Vupper,Vlower):
    # cost_function = coeff_p*(Pmax-P)^2+coeff_q*Q^2+dual_upper*(v1-1.05)+dual_lower*(0.95-v1)
    f1 = 0
    for ii in range(NPV):
        f1 = f1 + coeff_p*(x[ii])*(x[ii])+coeff_q*x[ii+NPV]*x[ii+NPV]
    f = f1 + abs(sum(dual_upper*(np.array(v1_pu)[control_bus_index]-Vupper)))+ abs(sum(dual_lower*(Vlower-np.array(v1_pu)[control_bus_index])))
    return f

def PV_costFun_gradient_distributed(x, coeff_p, coeff_q):#, Pmax):
    grad_P = -2*coeff_p*(x[0])
    grad_Q = 2*coeff_q*x[1]
    return [grad_P,grad_Q]

def PV_costFun_gradient(x, coeff_p, coeff_q):#, Pmax):
    grad = np.zeros(len(x))
    for ii in range(int(len(x)/2)):
        grad[ii] = -2*coeff_p*(x[ii])
        grad[ii+int(len(x)/2)] = 2*coeff_q*x[ii+int(len(x)/2)]
    return grad

def voltage_constraint_gradient(AllNodeNames,node_withPV, dual_upper, dual_lower, coeff_Vmag_p, coeff_Vmag_q):
    node_noslackbus = AllNodeNames
    node_noslackbus[0:3] = []
    grad_upper = np.matrix([0] * len(node_noslackbus)*2).transpose()
    grad_lower = np.matrix([0] * len(node_noslackbus)*2).transpose()
    count = 0
    for node in node_noslackbus:
        if node in node_withPV:
            grad_upper[count] = dual_upper.transpose()*coeff_Vmag_p[:,count]
            grad_upper[count+len(node_noslackbus)] = dual_upper.transpose() * coeff_Vmag_q[:,count]
            grad_lower[count] = -dual_lower.transpose() * coeff_Vmag_p[:, count]
            grad_lower[count + len(node_noslackbus)] = -dual_lower.transpose() * coeff_Vmag_q[:, count]
        count = count + 1
    return [grad_upper,grad_lower]

def current_constraint_gradient(AllNodeNames,node_withPV, dual_upper,coeff_Imag_p, coeff_Imag_q):
    node_noslackbus = AllNodeNames
    node_noslackbus[0:3] = []
    grad_upper = np.matrix([0] * len(node_noslackbus)*2).transpose()
    count = 0
    for node in node_noslackbus:
        if node in node_withPV:
            grad_upper[count] = dual_upper.transpose()*coeff_Imag_p[:,count]
            grad_upper[count+len(node_noslackbus)] = dual_upper.transpose() * coeff_Imag_q[:,count]
        count = count + 1
    return grad_upper

def voltage_constraint(V1_mag):
    g = V1_mag-1.05
    g.append(0.95-V1_mag)
    return g

def current_constraint(I1_mag,Imax):
    g = []
    g.append(I1_mag-Imax)
    return g

def project_dualvariable(mu):
    for ii in range(len(mu)):
        mu[ii] = max(mu[ii],0)
    return mu

def project_PV(x,Sinv):
    num = len(Sinv)
    for ii in range(num):
        if  x[ii] < 0:
            x[ii] = 0

        Qmax = math.sqrt(Sinv[ii]*Sinv[ii]-x[ii]*x[ii])
        if x[ii+num] > Qmax:
            x[ii+num] = Qmax
        # elif x[ii + num] < 0:
        #     x[ii + num] = 0
        elif x[ii+num] < -Qmax:
            x[ii+num] = -Qmax
    return x

def dual_update(mu,coeff_mu,constraint):
    mu_new = mu + coeff_mu*constraint
    mu_new = project_dualvariable(mu_new)
    return mu_new



def matrix_cal_for_subPower(V0, Y00, Y01, Y11, V1_noload):
    diag_V0 = np.matrix([[complex(0, 0)] * 3] * 3)
    diag_V0[0, 0] = V0[0]
    diag_V0[1, 1] = V0[1]
    diag_V0[2, 2] = V0[2]
    K = diag_V0 * Y01.conj() * np.linalg.inv(Y11.conj())
    g = diag_V0 * Y00.conj() * np.matrix(V0).transpose().conj() + diag_V0 * Y01.conj() * V1_noload.conj()

    return[K,g]

def subPower_PQ(V1, PQ_node, K, g):
    diag_V1 = np.matrix([[complex(0, 0)] * len(V1)] * len(V1))
    for ii in range(len(V1)):
        diag_V1[ii, ii] = V1[ii]
    M = K * np.linalg.inv(diag_V1)
    MR = M.real
    MI = M.imag
    P0 = g.real + (MR.dot(PQ_node.real)*1000 - MI.dot(PQ_node.imag)*1000)
    Q0 = g.imag + (MR.dot(PQ_node.imag)*1000 + MI.dot(PQ_node.real)*1000)

    P0 = P0/1000
    Q0 = Q0/1000 # convert to kW/kVar

    return [P0, Q0, M]

def sub_costFun_gradient(x, sub_ref, coeff_sub, sub_measure, M, node_withPV):
    grad_a = np.matrix([0] * len(x)).transpose()
    grad_b = np.matrix([0] * len(x)).transpose()
    grad_c = np.matrix([0] * len(x)).transpose()

    MR = M.real
    MI = M.imag
    count = 0
    for node in node_withPV:
        grad_a[count] = -MR[0, int(node)]
        grad_b[count] = -MR[1, int(node)]
        grad_c[count] = -MR[2, int(node)]

        grad_a[count + len(node_withPV)] = MI[0, int(node)]
        grad_b[count + len(node_withPV)] = MI[1, int(node)]
        grad_c[count + len(node_withPV)] = MI[2, int(node)]

        count = count + 1

    res = coeff_sub * ((sub_measure[0] - sub_ref[0]) *1000* grad_a + (sub_measure[1] - sub_ref[1])*1000 * grad_b
                       + (sub_measure[2] - sub_ref[2])*1000 * grad_c)
    res = res/1000

    return res

def projection(x,xmax,xmin):
    for ii in range(len(x)):
        if x.item(ii) > xmax[ii]:
            x[ii] = xmax[ii]
        if x.item(ii) < xmin[ii]:
            x[ii] = xmin[ii]
    return x
