import opendssdirect as dss
import numpy as np
import csv
import dss_function
import opt_function
import os
import math
import types
import inspect
import pickle
import networkx as nx


def Voltage(YVol,NodeNum):
    YMag = [0]*NodeNum
    for i in range(NodeNum):
        YMag[i] = math.sqrt(YVol[2*i]**2 + YVol[2*i+1]**2)
    return YMag
def BoundVol(AllNodeNames,circuit):
    length = len(AllNodeNames)
    VUpper = [0]*length
    VLower = [0]*length
    for i in range(length):
        circuit.SetActiveBus(AllNodeNames[i])
        base = dss.Bus.kVBase()*1000
        VUpper[i] = base*1.05
        VLower[i] = base*0.95
    return VUpper,VLower

def getRXMatrix(File):
    file_open = open(File,'rb')
    [R,X] = pickle.load(file_open) 
    return R,X
def getPartition(File):
    file_open = open(File,'rb')
    [G,G_1,G_2,G_3,G_4,G_main] = pickle.load(file_open)
    return G,G_1,G_2,G_3,G_4,G_main

def getLoadPartition(File):
    file_open = open(File,'rb')
    [LoadToNode,LoadToCluster,Loads_G_11,Loads_G_12,Loads_G_13,Loads_G_14,Loads_G_1main,Loads_G_21,Loads_G_22,Loads_G_23,Loads_G_24,Loads_G_2main,Loads_G_31,Loads_G_32,Loads_G_33,Loads_G_34,Loads_G_3main] = pickle.load(file_open)
    return LoadToNode,LoadToCluster,Loads_G_11,Loads_G_12,Loads_G_13,Loads_G_14,Loads_G_1main,Loads_G_21,Loads_G_22,Loads_G_23,Loads_G_24,Loads_G_2main,Loads_G_31,Loads_G_32,Loads_G_33,Loads_G_34,Loads_G_3main
def Mapping(AllNodeNames):
    NameToIndex = {}
    IndexToName = {}
    i = 0
    for name in AllNodeNames:
        NameToIndex[name] = i
        IndexToName[i] = name
        i+=1
    return NameToIndex,IndexToName



MainDir = os.path.dirname(os.getcwd())
dss.run_command("Compile 'C:/Users/lzy11/Desktop/11000_node_system/11000_node_system/MasterWang.dss'")
circuit = dss.Circuit

AllNodeNames = circuit.YNodeOrder()
AllNodeNames = [str(node) for node in AllNodeNames]
node_number = len(AllNodeNames)

############getData##############
File_RX = 'C:/Users/lzy11/Desktop/11000_node_system/python/result_RX/RXMatrix_3.data'
File_Phase1 = 'C:/Users/lzy11/Desktop/11000_node_system/python/result_Partition/PhaseOne.data'
File_Phase2 = 'C:/Users/lzy11/Desktop/11000_node_system/python/result_Partition/PhaseTwo.data'
File_Phase3 = 'C:/Users/lzy11/Desktop/11000_node_system/python/result_Partition/PhaseThree.data'
File_load = 'C:/Users/lzy11/Desktop/11000_node_system/python/result_Partition/LoadPartition.data'
G_1,G_11,G_12,G_13,G_14,G_1main = getPartition(File_Phase1) 
G_2,G_21,G_22,G_23,G_24,G_2main = getPartition(File_Phase2)
G_3,G_31,G_32,G_33,G_34,G_3main = getPartition(File_Phase3)  
LoadToNode,LoadToCluster,Loads_G_11,Loads_G_12,Loads_G_13,Loads_G_14,Loads_G_1main,Loads_G_21,Loads_G_22,Loads_G_23,Loads_G_24,Loads_G_2main,Loads_G_31,Loads_G_32,Loads_G_33,Loads_G_34,Loads_G_3main = getLoadPartition(File_load)
NameToIndex, IndexToName = Mapping(AllNodeNames)
RMatrix,XMatrix = getRXMatrix(File_RX)
VUpper,VLower = BoundVol(AllNodeNames,circuit)

# LoadName = []
# for item in list(LoadName_lower):
#     LoadName.append(item.upper())
# print(LoadName)
#Ynode = circuit.YNodeOrder()
#YVol = circuit.YNodeVArray()
#circuit.SetActiveBus('M1069365.1')
#base = dss.Bus.kVBase()*1000
#print(len(base))
#print(base)

Mu_Upper = [0]*node_number
Mu_Lower = [0]*node_number
step_mu = 0.01 
#########read all nodes' voltages##############
YVol = circuit.YNodeVArray()
AllNodeVoltage = Voltage(YVol,node_number)
AllLoadNames = dss.Loads.AllNames()
print(len(AllLoadNames))

#loadName = 'Load.t21384215a'
#circuit.SetActiveElement(loadName)
#p = dss.Loads.kW()
#p = dss.run_command("? Load.t21384215a.kvar")
#print(p)

#load = dss.Loads.First()
#while(load):
#    P = dss.Loads.kW()
#    load = dss.Loads.Next()
#    #print(load)


def RX_Com(G1,G2):
    Name1 = list(G1.nodes)[0]
    Name2 = list(G2.nodes)[0]
    Index1 = NameToIndex[Name1]
    Index2 = NameToIndex[Name2]
    weightR = RMatrix[Index1,Index2]
    weightX = XMatrix[Index1,Index2]
    return weightR,weightX



R_com = {}
X_com = {}

######PhaseOne################
weightR,weightX = RX_Com(G_11,G_12)
R_com['1_1_2'] = weightR
X_com['1_1_2'] = weightX
######################
weightR,weightX = RX_Com(G_11,G_13)
R_com['1_1_3'] = weightR
X_com['1_1_3'] = weightX
######################
weightR,weightX = RX_Com(G_11,G_14)
R_com['1_1_4'] = weightR
X_com['1_1_4'] = weightX
######################
weightR,weightX = RX_Com(G_12,G_13)
R_com['1_2_3'] = weightR
X_com['1_2_3'] = weightX
######################
weightR,weightX = RX_Com(G_12,G_14)
R_com['1_2_4'] = weightR
X_com['1_2_4'] = weightX
######################
weightR,weightX = RX_Com(G_13,G_14)
R_com['1_3_4'] = weightR
X_com['1_3_4'] = weightX

######PhaseTwo################
weightR,weightX = RX_Com(G_21,G_22)
R_com['2_1_2'] = weightR
X_com['2_1_2'] = weightX
######################
weightR,weightX = RX_Com(G_21,G_23)
R_com['2_1_3'] = weightR
X_com['2_1_3'] = weightX
######################
weightR,weightX = RX_Com(G_21,G_24)
R_com['2_1_4'] = weightR
X_com['2_1_4'] = weightX
######################
weightR,weightX = RX_Com(G_22,G_23)
R_com['2_2_3'] = weightR
X_com['2_2_3'] = weightX
######################
weightR,weightX = RX_Com(G_22,G_24)
R_com['2_2_4'] = weightR
X_com['2_2_4'] = weightX
######################
weightR,weightX = RX_Com(G_23,G_24)
R_com['2_3_4'] = weightR
X_com['2_3_4'] = weightX
######PhaseThree################
weightR,weightX = RX_Com(G_31,G_32)
R_com['3_1_2'] = weightR
X_com['3_1_2'] = weightX
######################
weightR,weightX = RX_Com(G_31,G_33)
R_com['3_1_3'] = weightR
X_com['3_1_3'] = weightX
######################
weightR,weightX = RX_Com(G_31,G_34)
R_com['3_1_4'] = weightR
X_com['3_1_4'] = weightX
######################
weightR,weightX = RX_Com(G_32,G_33)
R_com['3_2_3'] = weightR
X_com['3_2_3'] = weightX
######################
weightR,weightX = RX_Com(G_32,G_34)
R_com['3_2_4'] = weightR
X_com['3_2_4'] = weightX
######################
weightR,weightX = RX_Com(G_33,G_34)
R_com['3_3_4'] = weightR
X_com['3_3_4'] = weightX


#print(R_com['3_1_2'])
for i in range(node_number):
    Mu_Upper[i] = max(Mu_Upper[i] + 0.01*(AllNodeVoltage[i]-VUpper[i]),0)
    Mu_Lower[i] = max(Mu_Lower[i] + 0.01*(VLower[i]-AllNodeVoltage[i]),0)


###########initalPV##############
def getinitalPV(G):
    P_initial = {}
    Q_initial = {}
    for load in G:
        loadKW = '? Load.' + load.lower() + '.kw'
        loadKVar = '? Load.' + load.lower() + '.kvar'
        p = dss.run_command(loadKW)
        q = dss.run_command(loadKVar)
        P_initial[load] = float(p)
        Q_initial[load] = float(q)
    return P_initial,Q_initial

#phaseOne
pLoadIni_11, qLoadIni_11 = getinitalPV(Loads_G_11)
pLoadIni_12, qLoadIni_12 = getinitalPV(Loads_G_12)
pLoadIni_13, qLoadIni_13 = getinitalPV(Loads_G_13)
pLoadIni_14, qLoadIni_14 = getinitalPV(Loads_G_14)
#phaseTwo
pLoadIni_21, qLoadIni_21 = getinitalPV(Loads_G_21)
pLoadIni_22, qLoadIni_22 = getinitalPV(Loads_G_22)
pLoadIni_23, qLoadIni_23 = getinitalPV(Loads_G_23)
pLoadIni_24, qLoadIni_24 = getinitalPV(Loads_G_24)
#phaseThree
pLoadIni_31, qLoadIni_31 = getinitalPV(Loads_G_31)
pLoadIni_32, qLoadIni_32 = getinitalPV(Loads_G_32)
pLoadIni_33, qLoadIni_33 = getinitalPV(Loads_G_33)
pLoadIni_34, qLoadIni_34 = getinitalPV(Loads_G_34)

##########fixed initial load
#phaseOne
pLoadIni_11_restore, qLoadIni_11_restore = getinitalPV(Loads_G_11)
pLoadIni_12_restore, qLoadIni_12_restore = getinitalPV(Loads_G_12)
pLoadIni_13_restore, qLoadIni_13_restore = getinitalPV(Loads_G_13)
pLoadIni_14_restore, qLoadIni_14_restore = getinitalPV(Loads_G_14)
#phaseTwo
pLoadIni_21_restore, qLoadIni_21_restore = getinitalPV(Loads_G_21)
pLoadIni_22_restore, qLoadIni_22_restore = getinitalPV(Loads_G_22)
pLoadIni_23_restore, qLoadIni_23_restore = getinitalPV(Loads_G_23)
pLoadIni_24_restore, qLoadIni_24_restore = getinitalPV(Loads_G_24)
#phaseThree
pLoadIni_31_restore, qLoadIni_31_restore = getinitalPV(Loads_G_31)
pLoadIni_32_restore, qLoadIni_32_restore = getinitalPV(Loads_G_32)
pLoadIni_33_restore, qLoadIni_33_restore = getinitalPV(Loads_G_33)
pLoadIni_34_restore, qLoadIni_34_restore = getinitalPV(Loads_G_34)


###calculate the S_k
def CalSignal(G):
    IndexSet = []
    signal = 0
    for node in list(G.nodes):
        IndexSet.append(NameToIndex[node])
    for index in IndexSet:
         signal += (Mu_Upper[index] - Mu_Lower[index])
    return signal
###Calculate the Inner_signal
def CalInner(G,Load):
    Node = LoadToNode[Load]
    inner_R = 0
    inner_X = 0
    for node in list(G.nodes):
        inner_R += RMatrix[NameToIndex[Node],NameToIndex[node]]
        inner_X += XMatrix[NameToIndex[Node],NameToIndex[node]]
    return inner_R,inner_X
signal_11 = CalSignal(G_11)
signal_12 = CalSignal(G_12)
signal_13 = CalSignal(G_13)
signal_14 = CalSignal(G_14)

signal_21 = CalSignal(G_21)
signal_22 = CalSignal(G_22)
signal_23 = CalSignal(G_23)
signal_24 = CalSignal(G_24)

signal_31 = CalSignal(G_31)
signal_32 = CalSignal(G_32)
signal_33 = CalSignal(G_33)
signal_34 = CalSignal(G_34)

step_pq = 0.01
####G_11
OutR_11 = signal_12*R_com['1_1_2'] + signal_13*R_com['1_1_3'] + signal_14*R_com['1_1_4']
OutX_11 = signal_12*X_com['1_1_2'] + signal_13*X_com['1_1_3'] + signal_14*X_com['1_1_4']


for load in Loads_G_11:
    inner_R, inner_X = CalInner(G_11,load)
    #print(type(qLoadIni_11[load]))
    #print(qLoadIni_11[load])
    pLoadIni_11[load] = pLoadIni_11[load] - step_pq*(2*(pLoadIni_11[load] - pLoadIni_11_restore[load]) + OutR_11 + inner_R)
    qLoadIni_11[load] = qLoadIni_11[load] - step_pq*(2*(qLoadIni_11[load] -qLoadIni_11_restore[load]) + OutX_11 + inner_X)
    command = "edit load." + load + "kw=" + str(pLoadIni_11[load]) + " kvar=" + str(qLoadIni_11[load])
    dss.run_command(command)
dss.run_command("Solve")