# -*- coding: utf-8 -*-
"""
Created on Thu Aug  9 12:45:20 2018

@author: xzhou
"""

#import win32com.client
import opendssdirect as dss
import numpy as np
import csv
import dss_function
import opt_function
import os
import types
import inspect



control_flag = 1
MainDir = os.path.dirname(os.getcwd())
#try:
#	DSSObj = win32com.client.Dispatch("OpenDSSEngine.DSS")
#except:
#	print("Unable to start the OpenDSS Engine")
#	raise SystemExit

#DSSText = DSSObj.Text
#DSSCircuit = DSSObj.ActiveCircuit 
#DSSSolution = DSSCircuit.Solution

# Load the circuit
dss.run_command("Compile 'C:/Users/lzy11/Desktop/11000_node_system/11000_node_system/MasterWang.dss'")
#dss.run_command("Set voltagebases = [115, 12.47, 0.480, 0.4157, 0.208, 0.12]")
#dss.run_command("Calcvoltagebases")
#dss.run_command("Buscoords  Buscoords.dss")
#dss.run_command("Set controlmode=Off")
#dss.run_command("Set MarkCapacitors=Yes")
#dss.run_command("New Energymeter.m1 Line.ln5815900-1 1")
#dss.run_command("New Energymeter.m2 Line.333 1")


# Disable all the original controls
#DSSText.Command = "Set controlmode=off"

#dss.run_command('solve')
#DSSText.Command = "Show Voltage LN Nodes"
#dss.run_command('Plot Circuit Power Max=2000 dots=n labels=n  C1=Blue  1ph=3')
#dss.run_command('Plot Circuit voltage Max=0 n n  C1=$00FF0000 C2=$FF00FF')

circuit = dss.Circuit

print(circuit.Name())



# ------- get Ymatrix --------------
#dss.run_command('batchedit Load..* enabled=no')
#dss.run_command('batchedit Capacitor..* enabled=no')
#dss.run_command('solve')
#dss.run_command('show Y')


#for name, module in inspect.getmembers(dss):
#    if isinstance(module, types.ModuleType) and not name.startswith('_'):
#        print(f'dss.{name}')

#dss.utils.loads_to_dataframe()


AllNodeNames = circuit.YNodeOrder()
AllNodeNames = [str(node) for node in AllNodeNames]
node_number = len(AllNodeNames)
#print(AllNodeNames)
Ynode = circuit.YNodeOrder()
#print(Ynode)

YVol = circuit.YNodeVArray()
#print(YVol)
#print(len(YVol))
#print(len(Ynode))
##########compute the magnitude
circuit.SetActiveBus('M1069365.1')
base = dss.Bus.kVBase()*1000
#print(len(base))
print(base)
#print(AllNodeNames)
#print("-------------------------------------------")
#result = []
#for item in AllNodeNames:
#    if(item[-2:]=='.3'):
#x        result.append(item[:-2]+'.1')
#print(result)

NodeVmag = circuit.AllNodeVmagPUByPhase(1)
print(len(NodeVmag))
print(NodeVmag)

Vbase_allnode = [0]*node_number
ii = 0
for node in AllNodeNames:
    circuit.SetActiveBus(node)
    Vbase_allnode[ii] = dss.Bus.kVBase()*1000
    ii = ii + 1
slack_number = 1
with open('result_nodename.csv','w') as f:
    csvwriter = csv.writer(f)
    for ii in range(node_number):
        csvwriter.writerow([AllNodeNames[ii]])
f.close()
Ysparse_file = os.path.join(os.getcwd(),str(circuit.Name()).upper()+'_SystemY.txt')
[Y00,Y01,Y10,Y11,Y11_sparse,Y11_inv] = dss_function.construct_Ymatrix(Ysparse_file, slack_number,node_number)
# check the correctness of Ymatrix using: I=Y*V
AllNodeVolt_noLoad = circuit.YNodeVArray()
V_vector_noLoad = [complex(0,0)]*node_number
for ii in range(node_number):
    V_vector_noLoad[ii] = complex(AllNodeVolt_noLoad[ii*2],AllNodeVolt_noLoad[ii*2+1])

# --------- get Load Information ----------
dss.run_command('BatchEdit Load..* enabled=yes')
dss.run_command('BatchEdit Capacitor..* enabled=yes')
dss.run_command('redirect pvsystems_high.dss')
#dss.run_command('Redirect LoadShape.dss')



if control_flag == 0:
    dss.run_command('BatchEdit PVSystem..* yearly=PVshape_1sec')

dss.run_command('solve')
[Load,totalLoadkW] = dss_function.get_loads(dss,circuit)

# --------- get PV Information ------------
PVSystem = dss_function.get_pvSystems(dss)
NPV = len(PVSystem)
PV_power_perStep = []
nodeIndex_withPV = []
PV_inverter_size = []
for pv in PVSystem:
    circuit.SetActiveElement(pv["name"])
    PV_power_perStep.append([-ii for ii in dss.CktElement.Powers()[0:2]])
    nodeIndex_withPV.append(AllNodeNames[slack_number:].index(pv["bus"].upper()))
    PV_inverter_size.append(float(pv['kVA']))


#if control_flag == 1:
#    PV_Pmax = []
#    with open(os.path.join(MainDir,'result_highPV\PVoutput_P.csv'),'r') as f:
#        csvreader = csv.reader(f)
#        for row in csvreader:
#            PV_Pmax.append([-float(ii) for ii in row])


# ********************* Start Optimization **********************************
# # sub_a_ref = np.random.uniform(low=1400,high=1500,size=1440)
# # sub_b_ref = np.random.uniform(low=1400,high=1500,size=1440)
# # sub_c_ref = np.random.uniform(low=1400,high=1500,size=1440)

control_bus = AllNodeNames[slack_number:]#['_N_EDIST_OH_TRANSFORMER_BANK_236133596_277.3']
control_bus_index = [AllNodeNames[slack_number:].index(ii) for ii in control_bus]
Vlower = 0.96
Vupper = 1.04

stepsize = 10
Tmax = 1440*2
startH = 0 # in hour
dss.run_command('set mode=yearly')
dss.run_command('set number=1')
dss.run_command('set stepsize='+ str(stepsize) +'s')
dss.run_command('set hour='+str(startH))
present_step = 1
res_allVolt = []
res_PV_Pout = []
res_PV_Qout = []
subKW = []
subKVAr = []
loadDemandKw = []
loadDemandKvar = []
pvGenerationKw = []
pvGenerationKvar = []
v = []
vmin = []
vmax = []
vmean = []
regPos = []
capState = []
losses = []
PV_Ppower_output = []
PV_Qpower_output = []
buffer_count = 10

# --- Initialize the files to write results
resFolder = os.path.join(MainDir,'result')
if not os.path.exists(resFolder):
    os.mkdir(resFolder)
result_file = os.path.join(resFolder,'result.csv')
if os.path.exists(result_file):
    os.remove(result_file)
fn = open(result_file, 'a')
# header with nodenames for saving voltage file
regNames = dss.RegControls.AllNames()
hRegNames = [None] * len(regNames)
for i, n in enumerate(regNames):
    hRegNames[i] = str(n)
hRegNames = str(hRegNames)[1:-1]

capNames = dss.Capacitors.AllNames()
hCapNames = [None] * len(capNames)
for i, n in enumerate(capNames):
    hCapNames[i] = str(n)
hCapNames = str(hCapNames)[1:-1]

headerStats = 'Minute,Load Demand (MW), Load Demand (MVAr), ' \
             'Sub Power (MW),Sub Reactive Power (MVar),' \
             'PVGeneration(MW),PVGeneration(MVAr),' \
             'Vavg (p.u.),Vmax (p.u.),Vmin (p.u.),' + hCapNames +',' + ',Active Losses(MW),'
#fn.write(bytes(headerStats + '\n'))
fn.write(headerStats + '\n')

volt_file = os.path.join(resFolder,'voltage.csv')
if os.path.exists(volt_file):
    os.remove(volt_file)
vn = open(volt_file, 'a')
vn.write(','.join(AllNodeNames) + '\n')
# ----------------------

# Define control coefficients
coeff_p = 5
coeff_q = 1
# coeff_sub = 1
# coeff_grad = 0.3
stepsize_x = 1
stepsize_mu = 50

# mu_Vmag_upper0 = np.zeros(node_number-slack_number)
# mu_Vmag_lower0 = np.zeros(node_number-slack_number)
mu_Vmag_upper0 = np.zeros(len(control_bus))
mu_Vmag_lower0 = np.zeros(len(control_bus))

x1 = np.concatenate([np.ones(NPV)*10,np.ones(NPV)*10]) # in W/Var PV_Pmax[startH*60-2]
record_v = []
V1_err = []
while present_step <= Tmax-startH*60:
    h = dss.Solution.DblHour()
    print('****************** time step= '+ str(present_step) + ' : ' + str(h) +'*****************')
    if control_flag == 1:
        if present_step > 1:
            record_v.append(v1_pu)

#        PVmax = PV_Pmax[present_step - 1 + 60 * startH]

        for iter_count in range(int(60/stepsize)):
            count = 0
            # ------ apply the setpoint ------
            for pv in PVSystem:
                command = 'edit ' + str(pv["name"]) + ' Pmpp=' + str(x1[count]) + ' kvar=' + str(x1[count + NPV])
                print(command)
                dss.run_command('edit ' + str(pv["name"]) + ' Pmpp=' + str(x1[count]) + ' kvar=' + str(x1[count + NPV]))
                count = count + 1
            dss.run_command('solve')

            # ------- get x0 using feedback -------
            PV_power_perStep = []
            for pv in PVSystem:
                circuit.SetActiveElement(pv["name"])
                PV_power_perStep.append([-ii for ii in dss.CktElement.Powers()[0:2]])

            x0 = np.zeros(2 * NPV)
            for ii in range(NPV):
                x0[ii] = PV_power_perStep[ii][0]
                x0[ii + NPV] = PV_power_perStep[ii][1]

            V1_order = circuit.YNodeOrder()
            V1_complex = circuit.YNodeVArray()
            V1_temp = [complex(0, 0)] * node_number
            for ii in range(node_number):
                V1_temp[ii] = complex(V1_complex[ii * 2], V1_complex[ii * 2 + 1])

            V1 = dss_function.re_orgnaize_for_volt(V1_temp,AllNodeNames,V1_order)
            V1[:slack_number] = []

            [coeff_Vp, coeff_Vq, coeff_Vm, coeff_Vmag_p, coeff_Vmag_q, coeff_Vmag_k, coeff_sub_p, coeff_sub_q,
                 coeff_sub_g] =opt_function.linear_voltage_model(Y00,Y01,Y11_inv,[],V_vector_noLoad, V1, slack_number)

            # ********* Calculate gradient and update primal(X) variables ***********

            PVcost_fun_gradient = opt_function.PV_costFun_gradient(x0, coeff_p, coeff_q)
            
            #, PVmax)

            Vmag_upper_gradient = np.concatenate((np.dot(coeff_Vmag_p[np.ix_(control_bus_index,nodeIndex_withPV)].transpose(),mu_Vmag_upper0),np.dot(coeff_Vmag_q[np.ix_(control_bus_index,nodeIndex_withPV)].transpose(),mu_Vmag_upper0)),axis=0)
            Vmag_lower_gradient = np.concatenate(
                (np.dot(coeff_Vmag_p[np.ix_(control_bus_index, nodeIndex_withPV)].transpose(), mu_Vmag_lower0),
                np.dot(coeff_Vmag_q[np.ix_(control_bus_index, nodeIndex_withPV)].transpose(), mu_Vmag_lower0)), axis=0)
            Vmag_gradient = Vmag_upper_gradient - Vmag_lower_gradient

            x1 = x0 - stepsize_x*(PVcost_fun_gradient+np.array(Vmag_gradient))
            x1 = opt_function.project_PV(x1,PV_inverter_size)

            # ------- Check the correctness of linear power flow model ---------
            [PQ_load, PQ_PV, PQ_node] = dss_function.get_PQnode(dss, circuit, Load, PVSystem, AllNodeNames)
            [V1_cal,V1_cal_1] = opt_function.validate_linear_model(coeff_Vp,coeff_Vq,coeff_Vm,PQ_node,slack_number)
            #coeff_Vmag_k + np.dot(coeff_Vmag_p,np.real([ii*1000 for ii in np.real(PQ_node[slack_number:])])) + np.dot(coeff_Vmag_q,np.imag([ii*1000 for ii in np.real(PQ_node[slack_number:])]))
            V1_err_step = [abs(abs(ii)-abs(jj))/abs(jj)*100 for ii,jj in zip(V1_cal.tolist(),V1)]
            #print(max(V1_err_step))
            # with open('V_compare.csv', 'w') as f:
            #     csvwriter = csv.writer(f)
            #     csvwriter.writerows([V1,V1_cal,V1_cal_1])

            # ********* Calculate gradient and update dual(mu) variables ***********
            v1_mag = [abs(vv) for vv in V1]
            v1_pu = []
            ii=slack_number
            for vv in v1_mag:
                v1_pu.append(vv/Vbase_allnode[ii])
                ii = ii + 1
            mu_Vmag_lower1 = mu_Vmag_lower0 + stepsize_mu*(Vlower-np.array([v1_pu[ii] for ii in control_bus_index]))
            mu_Vmag_upper1 = mu_Vmag_upper0 + stepsize_mu*(np.array([v1_pu[ii] for ii in control_bus_index])-Vupper)
            mu_Vmag_lower1 = opt_function.project_dualvariable(mu_Vmag_lower1)
            mu_Vmag_upper1 = opt_function.project_dualvariable(mu_Vmag_upper1)

            # ********** update both primal and dual *******************
            mu_Vmag_upper0 = mu_Vmag_upper1
            mu_Vmag_lower0 = mu_Vmag_lower1

            # ------ calculate the cost function ------
            if iter_count == 0 or iter_count == int(60/stepsize)-1:
                objFun = opt_function.costFun(x1, mu_Vmag_upper0, mu_Vmag_lower0, v1_pu, coeff_p, coeff_q, NPV, control_bus_index, Vupper, Vlower)
                print('Objective Function = ' + str(objFun))
                print(x1)

        V1_err.append(V1_err_step)

    elif control_flag == 0:
        dss.run_command('solve')

    # ********** save results ****************
    res = dss_function.result(circuit, dss)
    subKW.append(res['totalPower'][0])
    subKVAr.append(res['totalPower'][1])
    loadDemandKw.append(res['totalLoadPower'][0])
    loadDemandKvar.append(res['totalLoadPower'][1])
    pvGenerationKw.append(res['totalPVpower'][0])
    pvGenerationKvar.append(res['totalPVpower'][1])
    temp = res['AllVolt_Yorder']
    allnodeV_mes = [abs(vv) for vv in temp]
    allnodeV_mes_pu = []
    ii = 0
    for vv in allnodeV_mes:
        allnodeV_mes_pu.append(vv/Vbase_allnode[ii])
        ii = ii + 1
    v.append(allnodeV_mes_pu)
    vmax.append(max(res['AllVoltage']))
    vmin.append(min(res['AllVoltage']))
    vmean.append(sum(res['AllVoltage']) / len(res['AllVoltage']))
    regPos.append(res['RegTap'])
    capState.append(res['CapState'])
    losses.append(res['loss'][0] / 1000)
    PV_Ppower_output.append(res['PV_Poutput'])
    PV_Qpower_output.append(res['PV_Qoutput'])
    print(res['totalPVpower'][0])

    if present_step % buffer_count == 0:
        nstep = int(np.ceil(present_step))
        last = present_step // buffer_count * buffer_count - buffer_count
        tseries = np.asarray(range(last, nstep))
        d = np.column_stack((tseries, np.asarray(loadDemandKw) / 1000, np.asarray(loadDemandKvar) / 1000,
                             np.asarray(subKW) / 1000, np.asarray(subKVAr) / 1000, np.asarray(pvGenerationKw) / 1000,
                             np.asarray(pvGenerationKvar) / 1000,
                             np.asarray(vmean), np.asarray(vmax), np.asarray(vmin), np.asarray(capState),
                             np.asarray(losses) / 1000))
        np.savetxt(fn, d, fmt='%.8e', delimiter=',')
        d = np.row_stack(v)
        np.savetxt(vn, d, fmt='%.6e', delimiter=',')
        subKW = []
        subKVAr = []
        v = []
        loadDemandKw = []
        loadDemandKvar = []
        pvGenerationKw = []
        pvGenerationKvar = []
        vmin = []
        vmax = []
        vmean = []
        regPos = []
        capState = []
        losses = []

    present_step = present_step + 1

print('\n********** Processing results ! ********************\n')
nstep = int(np.ceil(Tmax-startH*60))
last = present_step // buffer_count * buffer_count
tseries = np.asarray(range(last, nstep))
if loadDemandKvar:
    d = np.column_stack((tseries, np.asarray(loadDemandKw) / 1000, np.asarray(loadDemandKvar) / 1000,
                         np.asarray(subKW) / 1000, np.asarray(subKVAr) / 1000, np.asarray(pvGenerationKw) / 1000,
                         np.asarray(pvGenerationKvar) / 1000,
                         np.asarray(vmean), np.asarray(vmax), np.asarray(vmin), np.asarray(capState),
                         np.asarray(losses) / 1000)) #np.asarray(regPos),
    np.savetxt(fn, d, fmt='%.8e', delimiter=',')
if v:
    d = np.row_stack(v)
np.savetxt(vn, d, fmt='%.6e', delimiter=',')
fn.flush()
vn.flush()

with open(os.path.join(resFolder,'PVoutput_P.csv'),'w') as f:
    csvwriter = csv.writer(f)
    csvwriter.writerows(PV_Ppower_output)

with open(os.path.join(resFolder,'PVoutput_Q.csv'),'w') as f:
    csvwriter = csv.writer(f)
    csvwriter.writerows(PV_Qpower_output)

with open('V_compare.csv','w') as f:
    csvwriter = csv.writer(f)
    csvwriter.writerows(V1_err)