# Created by Zhiyuan Liu, University of Colorado, Boulder
# and Xinyang Zhou, NREL
import networkx as nx
import matplotlib.pyplot as plt
import opendssdirect as dss
import numpy as np
import os
from numpy.linalg import inv
from itertools import combinations
import pickle
import time


path = "../11000_node_system/Lines.dss"

G = nx.Graph()
with open(path) as file:
        lines = file.readlines()
        i = 0
        for line in lines:
            if line[0]=='N':
                i =i+1
                temp = line.split(' ')
                temp = [item for item in temp if item!='']
                #print(temp[2][5:],temp[3][5:])
                index = temp[2].find('.')
                index2 = temp[3].find('.')
                if index == -1: #3 phases
                    #G.add_node(temp[2][5:].upper(),Set_phase = [0,1,2])
                    #G.add_node(temp[3][5:].upper(),Set_phase = [0,1,2])    
                    G.add_edge(temp[2][5:].upper(),temp[3][5:].upper(),Num_phase = 3, Set_phase = [0,1,2], z = np.zeros((3,3), dtype=complex))
                        
                if index!=-1: 
                    num_phase = 0
                    set_phase = []
                    if temp[2][index:]=='.1':
                        num_phase = 1
                        set_phase = [0]
                    elif temp[2][index:]=='.2':    
                        num_phase = 1
                        set_phase = [1]
                    elif temp[2][index:]=='.3':    
                        num_phase = 1
                        set_phase = [2]
                    elif temp[2][index:]=='.1.2':    
                        num_phase = 2
                        set_phase = [0,1]
                    elif temp[2][index:]=='.1.3':    
                        num_phase = 2
                        set_phase = [0,2]
                    elif temp[2][index:]=='.2.3':    
                        num_phase = 2
                        set_phase = [1,2]
                    elif temp[2][index:]=='.1.2.3':    
                        num_phase = 3
                        set_phase = [0,1,2]
                    else:
                        print("error")
                        exit(0)
#                     if  temp[2][5:index].upper() not in G:
#                         G.add_node(temp[2][5:index].upper(),Set_phase = set_phase)
#                     elif  temp[2][5:index].upper() in G:
#                         old = G.node[temp[2][5:index].upper()]['Set_phase']
#                         #print(old)#E182745
#                         #print(set_phase)
#                         set_phase_new = list(set(old + set_phase))
#                         set_phase_new.sort()
#                         G.add_node(temp[2][5:index].upper(),Set_phase = set_phase_new)
#                     if  temp[3][5:index2].upper() not in G:
#                         G.add_node(temp[3][5:index2].upper(),Set_phase = set_phase)
#                     elif  temp[3][5:index2].upper() in G:
#                         old = G.node[temp[3][5:index2].upper()]['Set_phase']
#                         #print(old)#E182745
#                         #print(set_phase)
#                         set_phase_new = list(set(old + set_phase))
#                         set_phase_new.sort()
#                         G.add_node(temp[3][5:index2].upper(),Set_phase = set_phase_new)
                    G.add_edge(temp[2][5:index].upper(),temp[3][5:index2].upper(),Num_phase = num_phase, Set_phase = set_phase, z = np.zeros((3,3), dtype=complex))
file.close()   
print(G.node['E182745'])

G.add_edge('HVMV_SUB_HSB', 'SOURCEBUS',Num_phase = 3, Set_phase = [0,1,2], z = np.zeros((3,3), dtype=complex))
#G.node['HVMV_SUB_HSB']['Set_phase'] = [0,1,2]
#G.node['SOURCEBUS']['Set_phase'] = [0,1,2]
G.add_edge('REGXFMR_HVMV_SUB_LSB', '_HVMV_SUB_LSB',Num_phase = 3, Set_phase = [0,1,2], z = np.zeros((3,3), dtype=complex))
#G.node['REGXFMR_HVMV_SUB_LSB']['Set_phase'] = [0,1,2]
#G.node['_HVMV_SUB_LSB']['Set_phase'] = [0,1,2]
G.add_edge('REGXFMR_HVMV_SUB_LSB', 'HVMV_SUB_HSB',Num_phase = 3, Set_phase = [0,1,2], z = np.zeros((3,3), dtype=complex))
#G.node['REGXFMR_HVMV_SUB_LSB']['Set_phase'] = [0,1,2]
#G.node['HVMV_SUB_HSB']['Set_phase'] = [0,1,2]
G.add_edge('HVMV_SUB_48332','_HVMV_SUB_LSB',Num_phase = 3, Set_phase = [0,1,2], z = np.zeros((3,3), dtype=complex))
#G.node['HVMV_SUB_48332']['Set_phase'] = [0,1,2]
#G.node['_HVMV_SUB_LSB']['Set_phase'] = [0,1,2]
G.add_edge('SOURCEBUS','EPRI_CKT7',Num_phase = 3, Set_phase = [0,1,2], z = np.zeros((3,3), dtype=complex))
#G.node['SOURCEBUS']['Set_phase'] = [0,1,2]
#G.node['EPRI_CKT7']['Set_phase'] = [0,1,2]
G.add_edge('EPRI_CKT7','CKT7',Num_phase = 3, Set_phase = [0,1,2], z = np.zeros((3,3), dtype=complex))
#G.node['EPRI_CKT7']['Set_phase'] = [0,1,2]
#G.node['CKT7']['Set_phase'] = [0,1,2]
G.add_edge('CKT7','318412',Num_phase = 3, Set_phase = [0,1,2], z = np.zeros((3,3), dtype=complex))
#G.node['318412']['Set_phase'] = [0,1,2]
#G.node['CKT7']['Set_phase'] = [0,1,2]
#G.add_edge(,Num_phase = 3, Set_phase = [1,2,3], z = [])
#regulator
G.add_edge('REGXFMR_190-8593','190-8593',Num_phase = 3, Set_phase = [0,1,2], z = np.zeros((3,3), dtype=complex))
#G.node['REGXFMR_190-8593']['Set_phase'] = [0,1,2]
#G.node['190-8593']['Set_phase'] = [0,1,2]
G.add_edge('REGXFMR_190-8581','190-8581',Num_phase = 3, Set_phase = [0,1,2], z = np.zeros((3,3), dtype=complex))
#G.node['REGXFMR_190-8581']['Set_phase'] = [0,1,2]
#G.node['190-8581']['Set_phase'] = [0,1,2]
G.add_edge('REGXFMR_190-7361','190-7361',Num_phase = 3, Set_phase = [0,1,2], z = np.zeros((3,3), dtype=complex))
#G.node['REGXFMR_190-7361']['Set_phase'] = [0,1,2]
#G.node['190-7361']['Set_phase'] = [0,1,2]
#close switch to avoid circles

    
G.remove_edge('181932', '236965')
G.remove_edge('228-1353934-4_INT','193-103041')
G.remove_edge('228-961799-3_INT','193-46661')
G.remove_edge('181932', '181933')
G.remove_edge('D5837361-8_INT', 'E182745')
G.remove_edge('228-979371-2_INT', '193-48013')
G.remove_edge ('193-51796', '228-1048090-1_INT')
print(len(G.nodes))
print(len(G.edges))
print(nx.is_tree(G))


###create the index
MainDir = os.path.dirname(os.getcwd())
print(MainDir)
#loadFile = 'C:/Users/lzy11/Dropbox/Journal_Cluster/multi-phase_control/11000_node_system/Loadswenbo.dss'
dss.run_command("Compile 'C:/Users/XZHOU/Desktop/multi-phase_control/11000_node_system/MasterWang2.dss'")
#dss.run_command("Compile 'C:/Users/XZHOU/Desktop/multi-phase_control/11000_node_system/MasterWang2.dss'")
circuit = dss.Circuit
AllNodeNames = circuit.YNodeOrder()
AllNodeNames = [str(node) for node in AllNodeNames]
node_number = len(AllNodeNames)
#print(AllNodeNames)

NameToIndex = {}
IndexToName = {}

i = 1
for name in AllNodeNames:
    NameToIndex[name] = i
    IndexToName[i] = name
    i+=1

Y_path = "../11000_node_system/11000_systemY.txt"
ZMatrix = np.zeros(shape=(node_number+1,node_number+1),dtype=complex)
with open(Y_path) as file:
    lines = file.readlines()
    for line in lines:
        if(line[0]=='['):
            index1 = line.find(',')
            row = int(line[1:index1])
            index2 = line.find(']')
            col = int(line[index1+1:index2])
            index1 = line.find('=')
            index2 = line.find('+')
            real = float(line[index1+1:index2])
            index1 = line.find('j')
            imag = float(line[index1+1:])
            Y_complex = complex(real,imag)
            ZMatrix[row,col] = Y_complex
            ZMatrix[col,row] = Y_complex


#update the line z matrix
for edge in G.edges:
    num_phase = G[edge[0]][edge[1]]['Num_phase']
    set_phase = G[edge[0]][edge[1]]['Set_phase']
    if num_phase==1:
        phase1 = set_phase[0]
        row = NameToIndex[edge[0]+"."+str(phase1+1)]
        col = NameToIndex[edge[1]+"."+str(phase1+1)]
        G[edge[0]][edge[1]]['z'][phase1][phase1] = ZMatrix[row][col]
    elif num_phase==2:
        phase1 = set_phase[0]
        phase2 = set_phase[1]
        row = NameToIndex[edge[0]+"."+str(phase1+1)]
        col = NameToIndex[edge[1]+"."+str(phase1+1)]
        G[edge[0]][edge[1]]['z'][phase1][phase1] = ZMatrix[row][col]
        
        row = NameToIndex[edge[0]+"."+str(phase2+1)]
        col = NameToIndex[edge[1]+"."+str(phase2+1)]
        G[edge[0]][edge[1]]['z'][phase2][phase2] = ZMatrix[row][col]
        
        row = NameToIndex[edge[0]+"."+str(phase1+1)]
        col = NameToIndex[edge[1]+"."+str(phase2+1)]
        G[edge[0]][edge[1]]['z'][phase1][phase2] = ZMatrix[row][col]
        G[edge[0]][edge[1]]['z'][phase2][phase1] = ZMatrix[row][col]
    else:
        #print(set_phase)
        phase1 = set_phase[0]
        phase2 = set_phase[1]
        phase3 = set_phase[2]
        row = NameToIndex[edge[0]+"."+str(phase1+1)]
        col = NameToIndex[edge[1]+"."+str(phase1+1)]
        G[edge[0]][edge[1]]['z'][phase1][phase1] = ZMatrix[row][col]
        
        row = NameToIndex[edge[0]+"."+str(phase2+1)]
        col = NameToIndex[edge[1]+"."+str(phase2+1)]
        G[edge[0]][edge[1]]['z'][phase2][phase2] = ZMatrix[row][col]
        
        row = NameToIndex[edge[0]+"."+str(phase3+1)]
        col = NameToIndex[edge[1]+"."+str(phase3+1)]
        G[edge[0]][edge[1]]['z'][phase3][phase3] = ZMatrix[row][col]
        
        row = NameToIndex[edge[0]+"."+str(phase1+1)]
        col = NameToIndex[edge[1]+"."+str(phase2+1)]
        G[edge[0]][edge[1]]['z'][phase1][phase2] = ZMatrix[row][col]
        G[edge[0]][edge[1]]['z'][phase2][phase1] = ZMatrix[row][col]

        row = NameToIndex[edge[0]+"."+str(phase1+1)]
        col = NameToIndex[edge[1]+"."+str(phase3+1)]
        G[edge[0]][edge[1]]['z'][phase1][phase3] = ZMatrix[row][col]
        G[edge[0]][edge[1]]['z'][phase3][phase1] = ZMatrix[row][col]

        row = NameToIndex[edge[0]+"."+str(phase2+1)]
        col = NameToIndex[edge[1]+"."+str(phase3+1)]
        G[edge[0]][edge[1]]['z'][phase2][phase3] = ZMatrix[row][col]
        G[edge[0]][edge[1]]['z'][phase3][phase2] = ZMatrix[row][col]
    temp = G[edge[0]][edge[1]]['z']
    G[edge[0]][edge[1]]['z'] = - np.linalg.pinv(temp)  


############
G['HVMV_SUB_HSB']['REGXFMR_HVMV_SUB_LSB']['z'] = np.zeros(shape=(3,3),dtype=complex)
G['HVMV_SUB_HSB']['REGXFMR_HVMV_SUB_LSB']['z'][0,0] = 0+0j
G['HVMV_SUB_HSB']['REGXFMR_HVMV_SUB_LSB']['z'][1,1] = 0+0j#1.21396012e00+1.40088997e+01j
G['HVMV_SUB_HSB']['REGXFMR_HVMV_SUB_LSB']['z'][2,2] = 0+0j
#G['HVMV_SUB_HSB']['REGXFMR_HVMV_SUB_LSB']['z'][0,1] = 1.21396012e00-1.40088997e+01j
#G['HVMV_SUB_HSB']['REGXFMR_HVMV_SUB_LSB']['z'][1,0] = 1.21396012e00-1.40088997e+01j
#G['HVMV_SUB_HSB']['REGXFMR_HVMV_SUB_LSB']['z'][0,2] = 1.21396012e00-1.40088997e+01j
#G['HVMV_SUB_HSB']['REGXFMR_HVMV_SUB_LSB']['z'][2,0] = 1.21396012e00-1.40088997e+01j
#G['HVMV_SUB_HSB']['REGXFMR_HVMV_SUB_LSB']['z'][1,2] = 1.21396012e00+1.40088997e+01j
#G['HVMV_SUB_HSB']['REGXFMR_HVMV_SUB_LSB']['z'][2,1] = 1.21396012e00+1.40088997e+01j
#G['SOURCEBUS']['HVMV_SUB_HSB']['z'] = np.zeros(shape=(3,3),dtype=complex)


#print(nx.shortest_path(G,source='SOURCEBUS',target='L2973167'))
ToSource = {}
node_set = list(G.nodes)
node_set.remove('SOURCEBUS')
for node in node_set:
    paths = nx.shortest_path(G,source='SOURCEBUS',target=node)
    temp = np.zeros(shape=(3,3),dtype=complex)
    for i in range(len(paths)-1):
            temp += G[paths[i]][paths[i+1]]['z']
    ToSource[node] = temp.conjugate()
    node_other = paths[-2]
    G.node[node]['Set_phase'] = G[node_other][node]['Set_phase']
ToSource['SOURCEBUS'] = np.zeros(shape=(3,3),dtype=complex)
G.node['SOURCEBUS']['Set_phase'] = [0,1,2]

#node = 'M1209753'
#paths = nx.shortest_path(G,source='SOURCEBUS',target=node)
#node_other = paths[-2]
#print(paths)
#print(node_other)
#print(G[node_other][node]['Set_phase'])

#clusters
#('L3081380','M1142843'),('M1047515.1','M1047513.1'),('L3066815.1','196-29519.1'),('SOURCEBUS.1','EPRI_CKT7.1')
#####Cluster1#####
G_1 = nx.Graph()
num_phase = G['L3081380']['M1142843']['Num_phase']
set_phase = G['L3081380']['M1142843']['Set_phase']
z_restore = G['L3081380']['M1142843']['z']
G.remove_edge('L3081380','M1142843')
bfs = list(nx.bfs_edges(G,'L3081380'))
#print(len(bfs))
#print(bfs)
G.add_edge('L3081380','M1142843',Num_phase=num_phase,Set_phase=set_phase,z=z_restore)
G_1.add_edges_from(bfs)
#print(len(G_1.edges),len(G_1.nodes))

#####Cluster2#####
G_2 = nx.Graph()
num_phase = G['M1047515']['M1047513']['Num_phase']
set_phase = G['M1047515']['M1047513']['Set_phase']
z_restore = G['M1047515']['M1047513']['z']
G.remove_edge('M1047515','M1047513')
bfs = list(nx.bfs_edges(G,'M1047513'))
#print(len(bfs))
#print(bfs)
G.add_edge('M1047515','M1047513',Num_phase=num_phase,Set_phase=set_phase,z=z_restore)
G_2.add_edges_from(bfs)
#print(len(G_2.edges),len(G_2.nodes))

#####Cluster3#####
G_3 = nx.Graph()
num_phase = G['L3066815']['196-29519']['Num_phase']
set_phase = G['L3066815']['196-29519']['Set_phase']
z_restore = G['L3066815']['196-29519']['z']                                 
G.remove_edge('L3066815','196-29519')
bfs = list(nx.bfs_edges(G,'L3066815'))
#print(len(bfs))
#print(bfs)
G.add_edge('L3066815','196-29519',Num_phase=num_phase,Set_phase=set_phase,z=z_restore)
G_3.add_edges_from(bfs)
#print(len(G_3.edges),len(G_3.nodes))

#####Cluster4#####
G_4 = nx.Graph()
num_phase = G['SOURCEBUS']['EPRI_CKT7']['Num_phase']
set_phase = G['SOURCEBUS']['EPRI_CKT7']['Set_phase']
z_restore = G['SOURCEBUS']['EPRI_CKT7']['z']                                      
G.remove_edge('SOURCEBUS','EPRI_CKT7')
bfs = list(nx.bfs_edges(G,'EPRI_CKT7'))
G.add_edge('SOURCEBUS','EPRI_CKT7',Num_phase=num_phase,Set_phase=set_phase,z=z_restore)
G_4.add_edges_from(bfs)
#print(len(G_4.edges),len(G_4.nodes))

# main subtree
G_main = nx.Graph()
num_phase1 = G['L3081380']['M1142843']['Num_phase']
set_phase1 = G['L3081380']['M1142843']['Set_phase']
z_restore1 = G['L3081380']['M1142843']['z']
num_phase2 = G['M1047515']['M1047513']['Num_phase']
set_phase2 = G['M1047515']['M1047513']['Set_phase']
z_restore2 = G['M1047515']['M1047513']['z']
num_phase3 = G['L3066815']['196-29519']['Num_phase']
set_phase3 = G['L3066815']['196-29519']['Set_phase']
z_restore3 = G['L3066815']['196-29519']['z']    
num_phase4 = G['SOURCEBUS']['EPRI_CKT7']['Num_phase']
set_phase4 = G['SOURCEBUS']['EPRI_CKT7']['Set_phase']
z_restore4 = G['SOURCEBUS']['EPRI_CKT7']['z']  
G.remove_edge('SOURCEBUS','EPRI_CKT7')
G.remove_edge('L3066815','196-29519')
G.remove_edge('M1047515','M1047513')
G.remove_edge('L3081380','M1142843')
bfs = list(nx.bfs_edges(G,'M1142843'))
#print(bfs)
print(len(bfs))
G.add_edge('L3081380','M1142843',Num_phase=num_phase1,Set_phase=set_phase1,z=z_restore1)
G.add_edge('M1047515','M1047513',Num_phase=num_phase2,Set_phase=set_phase2,z=z_restore2)
G.add_edge('L3066815','196-29519',Num_phase=num_phase3,Set_phase=set_phase3,z=z_restore3)
G.add_edge('SOURCEBUS','EPRI_CKT7',Num_phase=num_phase4,Set_phase=set_phase4,z=z_restore4)
G_main.add_edges_from(bfs)
print(len(G_main.edges),len(G_main.nodes))

def set_phase(G_subtree):
    for node in G_subtree:
        G_subtree.node[node]['Set_phase'] = G.node[node]['Set_phase']
set_phase(G_1)
set_phase(G_2)
set_phase(G_3)
set_phase(G_4)
set_phase(G_main)

def clusterPhaseSet(G_subtree):
    result1 = []
    result2 = []
    result3 = []
    for node in G_subtree.nodes:
        phases = G.node[node]['Set_phase']
        if 0 in phases:
            result1.append(node)
        if 1 in phases:
            result2.append(node)
        if 2 in phases:
            result3.append(node)
    return result1,result2,result3
    
G_1_1, G_1_2, G_1_3 = clusterPhaseSet(G_1) #G_1_phase
G_2_1, G_2_2, G_2_3 = clusterPhaseSet(G_2)
G_3_1, G_3_2, G_3_3 = clusterPhaseSet(G_3)
G_4_1, G_4_2, G_4_3 = clusterPhaseSet(G_4)
G_main_1, G_main_2, G_main_3 = clusterPhaseSet(G_main)

##compute each clusters's first commom node.
#print(G_1.edges) #first node L3081380
G_1_directed = nx.DiGraph()
G_1_directed.add_edges_from(G_1.edges)
#print(G_1_directed.edges)
bfs = list(nx.bfs_edges(G_1_directed,'L3081380'))
print(len(bfs),len(G_1.nodes))
G_1_dic = {}
i = 0
for node in G_1.nodes:
    children = list(G_1_directed.successors(node))
    if len(children)==1:
        tree_1 = list(dict(nx.bfs_successors(G_1_directed, children[0])).values())
        tree_1_flat = [item for sublist in tree_1 for item in sublist]
        tree_1_flat.append(children[0])
        for succ in tree_1_flat:
            i+=1
            if node >= succ: #bigsmall
                G_1_dic[node+succ] = node
            else:
                G_1_dic[succ+node] = node
    elif len(children)==0:
        continue
    else: 
        for child in children:
            tree_1 = list(dict(nx.bfs_successors(G_1_directed, child)).values())
            tree_1_flat = [item for sublist in tree_1 for item in sublist]
            tree_1_flat.append(child)
            for succ in tree_1_flat:
                i+=1
                if node >= succ: #bigsmall
                    G_1_dic[node+succ] = node
                else:
                    G_1_dic[succ+node] = node
        comb = combinations(children,2)
        for nodes in list(comb):
            tree_1 = list(dict(nx.bfs_successors(G_1_directed, nodes[0])).values())
            tree_1_flat = [item for sublist in tree_1 for item in sublist]
            tree_1_flat.append(nodes[0])
            tree_2 = list(dict(nx.bfs_successors(G_1_directed, nodes[1])).values())
            tree_2_flat = [item for sublist in tree_2 for item in sublist]
            tree_2_flat.append(nodes[1])
            for node_1 in tree_1_flat:
                for node_2 in tree_2_flat:
                    i+=1
                    if node_1 >= node_2: #bigsmall
                        G_1_dic[node_1+node_2] = node
                    else:
                        G_1_dic[node_2+node_1] = node    
print(len(G_1_dic))
print(i)

def MakeDict(G_n):
    G_n_directed = nx.DiGraph()
    G_n_directed.add_edges_from(G_n.edges)
    G_n_dic = {}
    i = 0
    for node in G_n.nodes:
        G_n_dic[node+node] = node
        children = list(G_n_directed.successors(node))
        if len(children)==1:
            tree_1 = list(dict(nx.bfs_successors(G_n_directed, children[0])).values())
            tree_1_flat = [item for sublist in tree_1 for item in sublist]
            tree_1_flat.append(children[0])
            for succ in tree_1_flat:
                i+=1
                if node >= succ: #bigsmall
                    G_n_dic[node+succ] = node
                else:
                    G_n_dic[succ+node] = node
        elif len(children)==0:
            continue
        else: 
            for child in children:
                tree_1 = list(dict(nx.bfs_successors(G_n_directed, child)).values())
                tree_1_flat = [item for sublist in tree_1 for item in sublist]
                tree_1_flat.append(child)
                for succ in tree_1_flat:
                    i+=1
                    if node >= succ: #bigsmall
                        G_n_dic[node+succ] = node
                    else:
                        G_n_dic[succ+node] = node
            comb = combinations(children,2)
            for nodes in list(comb):
                tree_1 = list(dict(nx.bfs_successors(G_n_directed, nodes[0])).values())
                tree_1_flat = [item for sublist in tree_1 for item in sublist]
                tree_1_flat.append(nodes[0])
                tree_2 = list(dict(nx.bfs_successors(G_n_directed, nodes[1])).values())
                tree_2_flat = [item for sublist in tree_2 for item in sublist]
                tree_2_flat.append(nodes[1])
                for node_1 in tree_1_flat:
                    for node_2 in tree_2_flat:
                        i+=1
                        if node_1 >= node_2: #bigsmall
                            G_n_dic[node_1+node_2] = node
                        else:
                            G_n_dic[node_2+node_1] = node    
    return G_n_dic


G_1_dic = MakeDict(G_1)
print(len(G_1_dic),len(G_1.nodes)*(len(G_1.nodes)-1)/2 + len(G_1.nodes))
G_2_dic = MakeDict(G_2)
print(len(G_2_dic),len(G_2.nodes)*(len(G_2.nodes)-1)/2 + len(G_2.nodes))
G_3_dic = MakeDict(G_3)
print(len(G_3_dic),len(G_3.nodes)*(len(G_3.nodes)-1)/2 + len(G_3.nodes))
G_4_dic = MakeDict(G_4)
print(len(G_4_dic),len(G_4.nodes)*(len(G_4.nodes)-1)/2 + len(G_4.nodes))
G_main_dic = MakeDict(G_main)
print(len(G_main_dic),len(G_main.nodes)*(len(G_main.nodes)-1)/2 + len(G_main.nodes))


file_name = "G_dict.data"
file_pointer = open(file_name, 'wb')
pickle.dump([G_1_dic,G_2_dic,G_3_dic,G_4_dic,G_main_dic],file_pointer)
file_pointer.close()

## calculate the lCP for each cluster.
def crossCluster(G_1,G_2):
    node_1 = list(G_1.nodes)[0]
    node_2 = list(G_2.nodes)[0]
    path_1 = nx.dijkstra_path(G,'SOURCEBUS',node_1)
    path_2 = nx.dijkstra_path(G,'SOURCEBUS',node_2)
    minLen = min(len(path_1),len(path_2))
    for i in range(minLen):
        if path_1[i] == path_2[i]:
            node = path_1[i]
        else:
            break
    print(node)
    return ToSource[node]
G_12 = crossCluster(G_1,G_2)
print('--------------')
print(G_12)
G_13 = crossCluster(G_1,G_3)
print('--------------')
print(G_13)
G_14 = crossCluster(G_1,G_4)
print('--------------')
print(G_14)
G_23 = crossCluster(G_2,G_3)
print('--------------')
print(G_23)
G_24 = crossCluster(G_2,G_4)
print('--------------')
print(G_24)
G_34 = crossCluster(G_3,G_4)
print('--------------')
print(G_34)

## for all the loads. Find the mapping(load to node) and also phases for each load
#C:\Users\lzy11\Dropbox\Journal_Cluster\multi-phase_control\11000_node_system
loadFile = 'C:/Users/XZHOU/Desktop/multi-phase_control/11000_node_system/Loadswenbo.dss'
#loadFile = 'C:/Users/XZHOU/Desktop/multi-phase_control/11000_node_system/Loadswenbo.dss'
Loads_1 = {} ## key-value: LoadName-PhaseSet
Loads_2 = {}
Loads_3 = {}
Loads_4 = {}
Loads_main = {} 
LoadToNode = {} ## no phase extension

def whichCluster(LoadName,NodeName,PhaseSet):
    if NodeName in list(G_1.nodes):
        Loads_1[LoadName] = PhaseSet
    elif NodeName in list(G_2.nodes):
        Loads_2[LoadName] = PhaseSet
    elif NodeName in list(G_3.nodes):
        Loads_3[LoadName] = PhaseSet
    elif NodeName in list(G_4.nodes):
        Loads_4[LoadName] = PhaseSet
    elif NodeName in list(G_main.nodes):
        Loads_main[LoadName] = PhaseSet
    else:
        print("Error_whichCluster")
with open(loadFile) as file:
    lines = file.readlines()
    for line in lines:
        if line[0]=='N':
            temp = line.split(' ')
            temp = [item for item in temp if item!='']
            if temp[3][-6:]=='.1.2.3':
                LoadName = temp[1][5:]
                NodeName = temp[3][:-6]
                LoadToNode[LoadName] = NodeName
                whichCluster(LoadName,NodeName,[0,1,2])
            elif temp[3][-2:]=='.1':
                LoadName = temp[1][5:]
                NodeName = temp[3][:-2]
                LoadToNode[LoadName] = NodeName
                whichCluster(LoadName,NodeName,[0])    
            elif temp[3][-2:]=='.2':
                LoadName = temp[1][5:]
                NodeName = temp[3][:-2]
                LoadToNode[LoadName] = NodeName
                whichCluster(LoadName,NodeName,[1])
            elif temp[3][-2:]=='.3':
                LoadName = temp[1][5:]
                NodeName = temp[3][:-2]
                LoadToNode[LoadName] = NodeName
                whichCluster(LoadName,NodeName,[2])


####Control part
#### Circuit
#### AllNodeName
import math
import cmath
cmathexp = {}
cmathexp[0] = cmath.exp(-1j*2*math.pi*(0)/3) ### 0-0,1-1,2-2  
cmathexp[1] = cmath.exp(-1j*2*math.pi*(1)/3) ### 1-0，2-1
cmathexp[2] = cmath.exp(-1j*2*math.pi*(2)/3) ### 2-0,
cmathexp[-1] = cmath.exp(-1j*2*math.pi*(-1)/3) ### 0-1,1-2
cmathexp[-2] = cmath.exp(-1j*2*math.pi*(-2)/3) ### 0-2

##YVol contains real and image part.
def Voltage(YVol,NodeNum):
    YMag = [0]*NodeNum
    for i in range(NodeNum):
        YMag[i] = math.sqrt(YVol[2*i]**2 + YVol[2*i+1]**2)
    return YMag


###VBase, VUpper, VLower for each node
def BoundVol(AllNodeNames,circuit):
    length = len(AllNodeNames)
    VUpper = [0]*length
    VLower = [0]*length
    VBase  = [0]*length
    for i in range(length):
        circuit.SetActiveBus(AllNodeNames[i])
        base = dss.Bus.kVBase()*1000
        VUpper[i] = base*1.05
        VLower[i] = base*0.95
        VBase[i] = base
    return VUpper,VLower,VBase

###initialPV######## Load_Set is dictionary
def getInitialPV(Loads_Set):
    P_initial = {}
    Q_initial = {}
    for LoadName in Loads_Set.keys(): 
        loadKW = '? Load.' + LoadName.lower() + '.kw'
        loadKVar = '? Load.' + LoadName.lower() + '.kvar'
        p = dss.run_command(loadKW)
        q = dss.run_command(loadKVar)
        P_initial[LoadName] = float(p)
        Q_initial[LoadName] = float(q)
    return P_initial,Q_initial

def getInitialPV2(Loads_Set):
    P_initial = {}
    Q_initial = {}
    for LoadName in Loads_Set.keys(): 
        loadKW = '? Load.' + LoadName.lower() + '.kw'
        loadKVar = '? Load.' + LoadName.lower() + '.kvar'
        p = dss.run_command(loadKW)
        q = dss.run_command(loadKVar)
        P_initial[LoadName] = 0.8 * float(p)
        Q_initial[LoadName] = 0.8 * float(q)
    return P_initial,Q_initial

###CalSignal### \sum (mu_upper-mu_lower
def CalSignal(G_subtree):
    signal_all = [0]*3
    ### return 3 phase separately.
    for node in G_subtree.nodes:
        for phase in G_subtree.node[node]['Set_phase']:
            name = node + '.' + str(phase+1)
            index = NameToIndex[name]
            #print(index)
            signal_all[phase] += (Mu_Upper[index] - Mu_Lower[index])
    return signal_all

import cmath
## cmath.exp(1j*math.pi)
### return 2*inner_Signal.real,-2*inner_Signal.image
### input: one load and one load phase from the subtree, return the information 
### containing all the other phases from other nodes in this cluster. Phase_load
### should be [0,1,2]
def CalInner(G_subtree,G_subtree_dic,Load,Phase_load,G_subtree_1,G_subtree_2,G_subtree_3):
    node_load = LoadToNode[Load]
    #node_load_phase = node_load + '.' + str(Phase_load+1)
    #index_load = NameToIndex[node_load_phase]
    inner_Signal_1 = 0 + 0j
    inner_Signal_2 = 0 + 0j
    inner_Signal_3 = 0 + 0j
    #total1 = 0 
    #total2 = 0
    for node_other in G_subtree_1:
        if node_load >= node_other:
            com_node = G_subtree_dic[node_load+node_other]
        else:
            com_node = G_subtree_dic[node_other+node_load]
        Z = ToSource[com_node]
        Zji = Z[Phase_load,0]
        node_other_phase = node_other + '.1'
        index_other = NameToIndex[node_other_phase]
        Mu = Mu_Upper[index_other] - Mu_Lower[index_other]
        inner_Signal_1 += (Zji*Mu)
    inner_Signal_1 =  inner_Signal_1*cmathexp[0-Phase_load]
    
    for node_other in G_subtree_2:
        if node_load >= node_other:
            com_node = G_subtree_dic[node_load+node_other]
        else:
            com_node = G_subtree_dic[node_other+node_load]
        Z = ToSource[com_node]
        Zji = Z[Phase_load,1]
        node_other_phase = node_other + '.2'
        index_other = NameToIndex[node_other_phase]
        Mu = Mu_Upper[index_other] - Mu_Lower[index_other]
        inner_Signal_2 += (Zji*Mu)
    inner_Signal_2 =  inner_Signal_2*cmathexp[1-Phase_load]
    
    for node_other in G_subtree_3:
        if node_load >= node_other:
            com_node = G_subtree_dic[node_load+node_other]
        else:
            com_node = G_subtree_dic[node_other+node_load]
        Z = ToSource[com_node]
        Zji = Z[Phase_load,2]
        node_other_phase = node_other + '.3'
        index_other = NameToIndex[node_other_phase]
        Mu = Mu_Upper[index_other] - Mu_Lower[index_other]
        inner_Signal_3 += (Zji*Mu)
    inner_Signal_3 =  inner_Signal_3*cmathexp[2-Phase_load]
    inner_Signal = inner_Signal_1 + inner_Signal_2 + inner_Signal_3
    return 2*inner_Signal.real,-2*inner_Signal.imag

# def CalInner(G_subtree,G_subtree_dic,Load,Phase_load):
#     node_load = LoadToNode[Load]
#     node_load_phase = node_load + '.' + str(Phase_load+1)
#     index_load = NameToIndex[node_load_phase]
#     inner_Signal = 0 + 0j
#     #total1 = 0 
#     #total2 = 0
#     for node_other in G_subtree.nodes:
#         if node_load >= node_other:
#             com_node = G_subtree_dic[node_load+node_other]
#         else:
#             com_node = G_subtree_dic[node_other+node_load]
#         Z = ToSource[com_node]
#         Phase_set = G_subtree.node[node_other]['Set_phase']
#         for Phase_other in Phase_set:
#             node_other_phase = node_other + '.' + str(Phase_other+1)
#             index_other = NameToIndex[node_other_phase]
#             #start1 = time.time()
#             Zji = Z[Phase_load,Phase_other]
#             #start2 = time.time()
#             end = time.time()
#             Mu = Mu_Upper[index_other] - Mu_Lower[index_other]
#             #coef = cmath.exp(1j*2*math.pi*(Phase_load-Phase_other)/3)
#             coef = cmathexp[Phase_load-Phase_other] 
#             inner_Signal += (coef*Zji*Mu)
#             #total1 += (end-start1)
#             #total2 += (end-start2)
#     #print(total1,total2)
#     return 2*inner_Signal.real,-2*inner_Signal.imag

#########parameters
Mu_Upper = [0]*(node_number+1)
Mu_Lower = [0]*(node_number+1)
VUpper, VLower, VBase = BoundVol(AllNodeNames,circuit)
YVol = circuit.YNodeVArray()
AllNodeVoltage = Voltage(YVol,node_number)
BaseVoltage = Voltage(YVol,node_number)

AllNodeVoltage_initial = AllNodeVoltage


###get the initial (p,q) for each cluster
P_1,Q_1 = getInitialPV(Loads_1)
P_2,Q_2 = getInitialPV(Loads_2)
P_3,Q_3 = getInitialPV(Loads_3)
P_4,Q_4 = getInitialPV(Loads_4)
####save the value for future use
P_1_restore,Q_1_restore = getInitialPV(Loads_1)
P_2_restore,Q_2_restore = getInitialPV(Loads_2)
P_3_restore,Q_3_restore = getInitialPV(Loads_3)
P_4_restore,Q_4_restore = getInitialPV(Loads_4)


node_1 = G_1_1[16]
node_2 = G_2_1[30]
node_3 = G_3_1[29]
node_main= G_main_1[16]
node_4 = G_4_1[16]
print(node_1,node_2,node_3,node_4,node_main)


index_1 = NameToIndex[node_1+'.1']
index_2 = NameToIndex[node_2+'.1']
index_3 = NameToIndex[node_3+'.1']
index_4 = NameToIndex[node_4+'.1']
index_main = NameToIndex[node_main+'.1']


iteration = 500
coff = 1.5
step_mu = 1e-3
step_pq = 2e-3
a = 0.0
lambda_nes = 1
gamma_nes = 0

voltage_rec_1 = []
voltage_rec_2 = []
voltage_rec_3 = []
voltage_rec_4 = []
voltage_rec_main = []

signal_rec_1 = []
signal_rec_2 = []
signal_rec_3 = []
signal_rec_4 = []

record_loss = [0]*iteration
record_totalpower = [0]*iteration
record_losspercent = [0]*iteration

totalcost = [0]*iteration


record_losspercent = [0]*iteration



def project(num_p,num_q,ini_p,ini_q):
    p = 0
    q = 0
    if(ini_p > 0):
        p = min(max(num_p,0),coff*ini_p)
        q = min(max(num_q,0),coff*ini_q)
    else:
        p = max(min(num_p,0),coff*ini_p)
        q = max(min(num_q,0),coff*ini_q)
    return p,q
signal_1 = CalSignal(G_1)
signal_2 = CalSignal(G_2)
signal_3 = CalSignal(G_3)
signal_4 = CalSignal(G_4)
#print(signal_2)
start = time.time()

sum_time_1 = 0
sum_time_2 = 0
sum_time_3 = 0
sum_time_4 = 0

for i in range(iteration):
    
    print(i)
    
    lambda_nes_backup =  lambda_nes
    lambda_nes = (1+math.sqrt(1+4*lambda_nes_backup**2))/2
    gamma_nes = (1-lambda_nes_backup)/lambda_nes

    
    loss = dss.Circuit.LineLosses()[0]
    record_loss[i] = loss
    totalpower = dss.Circuit.TotalPower()[0]
    record_totalpower[i] = - totalpower
    record_losspercent[i] =  record_loss[i]/record_totalpower[i]
 
    
    outer_R_sum_11 = 0
    outer_R_sum_12 = 0
    outer_R_sum_13 = 0
    outer_R_sum_21 = 0
    outer_R_sum_22 = 0
    outer_R_sum_23 = 0
    outer_R_sum_31 = 0
    outer_R_sum_32 = 0
    outer_R_sum_33 = 0
    outer_R_sum_41 = 0
    outer_R_sum_42 = 0
    outer_R_sum_43 = 0
    
    outer_X_sum_11 = 0
    outer_X_sum_12 = 0
    outer_X_sum_13 = 0
    outer_X_sum_21 = 0
    outer_X_sum_22 = 0
    outer_X_sum_23 = 0
    outer_X_sum_31 = 0
    outer_X_sum_32 = 0
    outer_X_sum_33 = 0
    outer_X_sum_41 = 0
    outer_X_sum_42 = 0
    outer_X_sum_43 = 0
    
    outer_flag_sum_11 = 0
    outer_flag_sum_12 = 0
    outer_flag_sum_13 = 0
    outer_flag_sum_21 = 0
    outer_flag_sum_22 = 0
    outer_flag_sum_23 = 0
    outer_flag_sum_31 = 0
    outer_flag_sum_32 = 0
    outer_flag_sum_33 = 0
    outer_flag_sum_41 = 0
    outer_flag_sum_42 = 0
    outer_flag_sum_43 = 0
    
    compute_flag = 0
    

    start_time_1 = time.time()
    for LoadName, PhaseSet in Loads_1.items():
        NodeName = LoadToNode[LoadName]

           
        if len(PhaseSet) == 1:
            phase = PhaseSet[0]
            inner_R,inner_X = CalInner(G_1,G_1_dic,LoadName,phase,G_1_1,G_1_2,G_1_3)
            
            if phase == 0:
                if outer_flag_sum_11 == 0:
                    compute_flag = 1
                else:
                    compute_flag = 0                        
            elif phase == 1:
                if outer_flag_sum_12 == 0:
                    compute_flag = 1
                else:
                    compute_flag = 0    
            else:         #  phase ==2:
                if outer_flag_sum_13 == 0:
                    compute_flag = 1
                else:
                    compute_flag = 0
                    
            if compute_flag == 1:                            
                outter_R = 0
                coef  = cmathexp[0-phase]
                outter_R += coef*(signal_2[0]*G_12[phase,0] + signal_3[0]*G_13[phase,0] + signal_4[0]*G_14[phase,0])
                coef  = cmathexp[1-phase]
                outter_R += coef*(signal_2[1]*G_12[phase,1] + signal_3[1]*G_13[phase,1] + signal_4[1]*G_14[phase,1])
                coef  = cmathexp[2-phase]
                outter_R += coef*(signal_2[2]*G_12[phase,2] + signal_3[2]*G_13[phase,2] + signal_4[2]*G_14[phase,2])
                outter_R_sum = 2*outter_R.real
                outter_X_sum = -2*outter_R.imag 
                
                if phase == 0:
                    outer_flag_sum_11 = 1
                    outer_R_sum_11 = outter_R_sum                
                    outer_X_sum_11 = outter_X_sum     
                elif phase == 1:
                    outer_flag_sum_12 = 1   
                    outer_R_sum_12 = outter_R_sum                
                    outer_X_sum_12 = outter_X_sum
                else:         #  phase ==2:
                    outer_flag_sum_13 = 1            
                    outer_R_sum_13 = outter_R_sum                
                    outer_X_sum_13 = outter_X_sum
                    
            else: #compute_flag == 0: 
                if phase == 0:
                    outter_R_sum = outer_R_sum_11             
                    outter_X_sum = outer_X_sum_11      
                elif phase == 1:
                    outter_R_sum = outer_R_sum_12             
                    outter_X_sum = outer_X_sum_12   
                elif phase == 2:
                    outter_R_sum = outer_R_sum_13             
                    outter_X_sum = outer_X_sum_13                       
                    
            P_temp = P_1[LoadName]
            P_1[LoadName] = P_1[LoadName]- step_pq*(2*(P_1[LoadName] - P_1_restore[LoadName])  - outter_R_sum - inner_R + a*loss)
            P_1[LoadName] = (1-gamma_nes)*P_1[LoadName] + gamma_nes*P_temp
            Q_temp = Q_1[LoadName]
            Q_1[LoadName] = Q_1[LoadName]- step_pq*(2*(Q_1[LoadName] - Q_1_restore[LoadName]) - outter_X_sum - inner_X)
            Q_1[LoadName] = (1-gamma_nes)*Q_1[LoadName] + gamma_nes*Q_temp
            P_1[LoadName],Q_1[LoadName] = project(P_1[LoadName],Q_1[LoadName],P_1_restore[LoadName],Q_1_restore[LoadName])
            command = "edit load." + LoadName + " kw=" + str(P_1[LoadName]) + " kvar=" + str(Q_1[LoadName])
            dss.run_command(command)
            totalcost[i] = totalcost[i] + (P_1[LoadName] - P_1_restore[LoadName])**2 + (Q_1[LoadName] - Q_1_restore[LoadName])**2
    end_time_1 = time.time()
    sum_time_1 += end_time_1 - start_time_1
    
    
    start_time_2 = time.time()
    for LoadName, PhaseSet in Loads_2.items():
        NodeName = LoadToNode[LoadName]
        if len(PhaseSet) == 1:
            phase = PhaseSet[0]
            inner_R,inner_X = CalInner(G_2,G_2_dic,LoadName,phase,G_2_1,G_2_2,G_2_3)

            if phase == 0:
                if outer_flag_sum_21 == 0:
                    compute_flag = 1
                else:
                    compute_flag = 0                        
            elif phase == 1:
                if outer_flag_sum_22 == 0:
                    compute_flag = 1
                else:
                    compute_flag = 0    
            else:         #  phase ==2:
                if outer_flag_sum_23 == 0:
                    compute_flag = 1
                else:
                    compute_flag = 0
                    
            if compute_flag == 1:                            
                outter_R = 0
                coef  = cmathexp[0-phase]
                outter_R += coef*(signal_1[0]*G_12[phase,0] + signal_3[0]*G_23[phase,0] + signal_4[0]*G_24[phase,0])
                coef  = cmathexp[1-phase]
                outter_R += coef*(signal_1[1]*G_12[phase,1] + signal_3[1]*G_23[phase,1] + signal_4[1]*G_24[phase,1])
                coef  = cmathexp[2-phase]
                outter_R += coef*(signal_1[2]*G_12[phase,2] + signal_3[2]*G_23[phase,2] + signal_4[2]*G_24[phase,2])
                outter_R_sum = 2*outter_R.real
                outter_X_sum = -2*outter_R.imag
                
                if phase == 0:
                    outer_flag_sum_21 = 1
                    outer_R_sum_21 = outter_R_sum                
                    outer_X_sum_21 = outter_X_sum     
                elif phase == 1:
                    outer_flag_sum_22 = 1   
                    outer_R_sum_22 = outter_R_sum                
                    outer_X_sum_22 = outter_X_sum
                else:         #  phase ==2:
                    outer_flag_sum_23 = 1            
                    outer_R_sum_23 = outter_R_sum                
                    outer_X_sum_23 = outter_X_sum
                    
            else: #compute_flag == 0: 
                if phase == 0:
                    outter_R_sum = outer_R_sum_21             
                    outter_X_sum = outer_X_sum_21      
                elif phase == 1:
                    outter_R_sum = outer_R_sum_22             
                    outter_X_sum = outer_X_sum_22   
                elif phase == 2:
                    outter_R_sum = outer_R_sum_23             
                    outter_X_sum = outer_X_sum_23              
            
            
            P_temp = P_2[LoadName] 
            P_2[LoadName] = P_2[LoadName]- step_pq*(2*(P_2[LoadName] - P_2_restore[LoadName]) - outter_R_sum - inner_R + a*loss)
            P_2[LoadName] = (1-gamma_nes)*P_2[LoadName] + gamma_nes*P_temp
            Q_temp = Q_2[LoadName]
            Q_2[LoadName] = Q_2[LoadName]- step_pq*(2*(Q_2[LoadName] - Q_2_restore[LoadName]) - outter_X_sum - inner_X)
            Q_2[LoadName] = (1-gamma_nes)*Q_2[LoadName] + gamma_nes*Q_temp

            P_2[LoadName],Q_2[LoadName] = project(P_2[LoadName],Q_2[LoadName],P_2_restore[LoadName],Q_2_restore[LoadName])
            command = "edit load." + LoadName + " kw=" + str(P_2[LoadName]) + " kvar=" + str(Q_2[LoadName])
            dss.run_command(command)
            totalcost[i] = totalcost[i] + (P_2[LoadName] - P_2_restore[LoadName])**2 + (Q_2[LoadName] - Q_2_restore[LoadName])**2
        else:
            print('Error')
    
    end_time_2 = time.time()
    sum_time_2 += end_time_2 - start_time_2
    
    start_time_3 = time.time()
    for LoadName, PhaseSet in Loads_3.items():
        NodeName = LoadToNode[LoadName]
        if len(PhaseSet) == 1:
            phase = PhaseSet[0]
            inner_R,inner_X = CalInner(G_3,G_3_dic,LoadName,phase,G_3_1,G_3_2,G_3_3)
            
            if phase == 0:
                if outer_flag_sum_31 == 0:
                    compute_flag = 1
                else:
                    compute_flag = 0                        
            elif phase == 1:
                if outer_flag_sum_32 == 0:
                    compute_flag = 1
                else:
                    compute_flag = 0    
            else:         #  phase ==2:
                if outer_flag_sum_33 == 0:
                    compute_flag = 1
                else:
                    compute_flag = 0
                    
            if compute_flag == 1:                     
                outter_R = 0
                coef  = cmathexp[0-phase]
                outter_R += coef*(signal_1[0]*G_13[phase,0] + signal_2[0]*G_23[phase,0] + signal_4[0]*G_34[phase,0])
                coef  = cmathexp[1-phase]
                outter_R += coef*(signal_1[1]*G_13[phase,1] + signal_2[1]*G_23[phase,1] + signal_4[1]*G_34[phase,1])
                coef  = cmathexp[2-phase]
                outter_R += coef*(signal_1[2]*G_13[phase,2] + signal_2[2]*G_23[phase,2] + signal_4[2]*G_34[phase,2])
                outter_R_sum = 2*outter_R.real
                outter_X_sum = -2*outter_R.imag 

                if phase == 0:
                    outer_flag_sum_31 = 1
                    outer_R_sum_31 = outter_R_sum                
                    outer_X_sum_31 = outter_X_sum     
                elif phase == 1:
                    outer_flag_sum_32 = 1   
                    outer_R_sum_32 = outter_R_sum                
                    outer_X_sum_32 = outter_X_sum
                else:         #  phase ==2:
                    outer_flag_sum_33 = 1            
                    outer_R_sum_33 = outter_R_sum                
                    outer_X_sum_33 = outter_X_sum
                    
            else: #compute_flag == 0: 
                if phase == 0:
                    outter_R_sum = outer_R_sum_31             
                    outter_X_sum = outer_X_sum_31      
                elif phase == 1:
                    outter_R_sum = outer_R_sum_32             
                    outter_X_sum = outer_X_sum_32   
                elif phase == 2:
                    outter_R_sum = outer_R_sum_33             
                    outter_X_sum = outer_X_sum_33    
           
            P_temp = P_3[LoadName]
            P_3[LoadName] = P_3[LoadName]- step_pq*(2*(P_3[LoadName] - P_3_restore[LoadName]) - outter_R_sum - inner_R + a*loss)
            P_3[LoadName] = (1-gamma_nes)*P_3[LoadName] + gamma_nes*P_temp
            Q_temp = Q_3[LoadName]
            Q_3[LoadName] = Q_3[LoadName]- step_pq*(2*(Q_3[LoadName] - Q_3_restore[LoadName]) - outter_X_sum - inner_X)
            Q_3[LoadName] = (1-gamma_nes)*Q_3[LoadName] + gamma_nes*Q_temp
            P_3[LoadName],Q_3[LoadName] = project(P_3[LoadName],Q_3[LoadName],P_3_restore[LoadName],Q_3_restore[LoadName])
            command = "edit load." + LoadName + " kw=" + str(P_3[LoadName]) + " kvar=" + str(Q_3[LoadName])
            dss.run_command(command)
            totalcost[i] = totalcost[i] + (P_3[LoadName] - P_3_restore[LoadName])**2 + (Q_3[LoadName] - Q_3_restore[LoadName])**2

        else:
            print('Error')    
    end_time_3 = time.time()
    sum_time_3 += end_time_3 - start_time_3
    
    start_time_4 = time.time()
    for LoadName, PhaseSet in Loads_4.items():
        NodeName = LoadToNode[LoadName]
        if len(PhaseSet) == 1:
            phase = PhaseSet[0]
            inner_R,inner_X = CalInner(G_4,G_4_dic,LoadName,phase,G_4_1,G_4_2,G_4_3)
            if phase == 0:
                if outer_flag_sum_41 == 0:
                    compute_flag = 1
                else:
                    compute_flag = 0                        
            elif phase == 1:
                if outer_flag_sum_42 == 0:
                    compute_flag = 1
                else:
                    compute_flag = 0    
            else:         #  phase ==2:
                if outer_flag_sum_43 == 0:
                    compute_flag = 1
                else:
                    compute_flag = 0
                    
            if compute_flag == 1: 
                outter_R = 0
                coef  = cmathexp[0-phase]
                outter_R += coef*(signal_1[0]*G_14[phase,0] + signal_2[0]*G_24[phase,0] + signal_3[0]*G_34[phase,0])
                coef  = cmathexp[1-phase]
                outter_R += coef*(signal_1[1]*G_14[phase,1] + signal_2[1]*G_24[phase,1] + signal_3[1]*G_34[phase,1])
                coef  = cmathexp[2-phase]
                outter_R += coef*(signal_1[2]*G_14[phase,2] + signal_2[2]*G_24[phase,2] + signal_3[2]*G_34[phase,2])
                outter_R_sum = 2*outter_R.real
                outter_X_sum = -2*outter_R.imag 
                
                if phase == 0:
                    outer_flag_sum_41 = 1
                    outer_R_sum_41 = outter_R_sum                
                    outer_X_sum_41 = outter_X_sum     
                elif phase == 1:
                    outer_flag_sum_42 = 1   
                    outer_R_sum_42 = outter_R_sum                
                    outer_X_sum_42 = outter_X_sum
                else:         #  phase ==2:
                    outer_flag_sum_43 = 1            
                    outer_R_sum_43 = outter_R_sum                
                    outer_X_sum_43 = outter_X_sum
                    
            else: #compute_flag == 0: 
                if phase == 0:
                    outter_R_sum = outer_R_sum_41             
                    outter_X_sum = outer_X_sum_41      
                elif phase == 1:
                    outter_R_sum = outer_R_sum_42             
                    outter_X_sum = outer_X_sum_42   
                elif phase == 2:
                    outter_R_sum = outer_R_sum_43             
                    outter_X_sum = outer_X_sum_43              
            
            P_temp = P_4[LoadName]
            P_4[LoadName] = P_4[LoadName]- step_pq*(2*(P_4[LoadName] - P_4_restore[LoadName]) - outter_R_sum - inner_R + a*loss)
            P_4[LoadName] = (1-gamma_nes)*P_4[LoadName] + gamma_nes*P_temp
            Q_temp = Q_4[LoadName]
            Q_4[LoadName] = Q_4[LoadName]- step_pq*(2*(Q_4[LoadName] - Q_4_restore[LoadName]) - outter_X_sum - inner_X)
            Q_4[LoadName] = (1-gamma_nes)*Q_4[LoadName] + gamma_nes*P_temp
            P_4[LoadName],Q_4[LoadName] = project(P_4[LoadName],Q_4[LoadName],P_4_restore[LoadName],Q_4_restore[LoadName])
            command = "edit load." + LoadName + " kw=" + str(P_4[LoadName]) + " kvar=" + str(Q_4[LoadName])
            dss.run_command(command)
            totalcost[i] = totalcost[i] + (P_4[LoadName] - P_4_restore[LoadName])**2 + (Q_4[LoadName] - Q_4_restore[LoadName])**2

        else:
            continue
    end_time_4 = time.time()
    sum_time_4 += end_time_4 - start_time_4
        
    totalcost[i] = totalcost[i] + 0.5*a*loss**2
    
    dss.run_command("Solve")
    YVol = circuit.YNodeVArray()
    AllNodeVoltage = Voltage(YVol,node_number)
    for j in range(node_number):
        Mu_Upper[j+1] = max(Mu_Upper[j+1] + step_mu*(AllNodeVoltage[j]-VUpper[j]-1*Mu_Upper[j+1]),0)
        Mu_Lower[j+1] = max(Mu_Lower[j+1] + step_mu*(VLower[j]-AllNodeVoltage[j]-1*Mu_Lower[j+1]),0)
    signal_1 = CalSignal(G_1)
    signal_2 = CalSignal(G_2)
    signal_3 = CalSignal(G_3)
    signal_4 = CalSignal(G_4)

    voltage_rec_1.append(AllNodeVoltage[index_1-1]/VBase[index_1-1])
    voltage_rec_2.append(AllNodeVoltage[index_2-1]/VBase[index_2-1])
    voltage_rec_3.append(AllNodeVoltage[index_3-1]/VBase[index_3-1])
    voltage_rec_4.append(AllNodeVoltage[index_4-1]/VBase[index_4-1])
    voltage_rec_main.append(AllNodeVoltage[index_main-1]/VBase[index_main-1])

    signal_rec_1.append(signal_1)
    signal_rec_2.append(signal_2)
    signal_rec_3.append(signal_3)
    signal_rec_4.append(signal_4)

 #   print(AllNodeVoltage[index_1-1]/VBase[index_1-1],AllNodeVoltage[index_2-1]/VBase[index_2-1],AllNodeVoltage[index_3-1]/VBase[index_3-1],AllNodeVoltage[index_4-1]/VBase[index_4-1],AllNodeVoltage[index_main-1]/VBase[index_main-1])
    #print(signal_1,signal_2,signal_3,signal_4)
end = time.time()
print('Total time = ')
print(end-start)
print('Time by RC 1 = ')
print(sum_time_1)
print('Time by RC 2 = ')
print(sum_time_2)
print('Time by RC 3 = ')
print(sum_time_3)
print('Time by RC 4 = ')
print(sum_time_4)
print('Time by CC = ')
print(end-start-sum_time_1-sum_time_2-sum_time_3-sum_time_4)
print('Time under parallel = ')
print(end-start-sum_time_2-sum_time_3-sum_time_4)


#for node in G_1.nodes():
#    phase_set = G_1.node[node]['Set_phase']
#    for phase in phase_set:
#        node_name = node + '.' + str(phase+1) 
#        index = NameToIndex[node_name]
#        print(AllNodeVoltage[index-1]/VBase[index-1],BaseVoltage[index-1]/VBase[index-1])



timeLine = list(range(iteration))
plt.rcParams.update({'font.size':15})

plt.figure(1)
plot_v_1=plt.plot(timeLine, voltage_rec_1,'red')
plot_v_2=plt.plot(timeLine, voltage_rec_2,'green')
plot_v_3=plt.plot(timeLine, voltage_rec_3,'yellow')
plot_v_4=plt.plot(timeLine, voltage_rec_4,'black')
#plot_v_main=plt.plot(timeLine, voltage_rec_main,'black')

plt.xlabel('Iteration number')
plt.ylabel('Voltage magnitude, p.u.')
plt.title('Voltage Convergence (hierarchical)')
plt.grid(True)
plt.xlim((0, iteration-1))   # set the xlim to xmin, xmax
plt.ylim((0.85, 1.06))
plt.legend((plot_v_1[0], plot_v_2[0],plot_v_3[0], plot_v_4[0]), ('Subtree 1', 'Subtree 2','Subtree 3','Subtree 4'))
plt.savefig('../python/Result1.pdf')

plt.figure(2)
plot_s_1=plt.plot(timeLine, signal_rec_1,'red')
plot_s_2=plt.plot(timeLine, signal_rec_2,'green')
plot_s_3=plt.plot(timeLine, signal_rec_3,'yellow')
plot_s_4=plt.plot(timeLine, signal_rec_4,'black')

plt.xlabel('Iteration number')
plt.ylabel('Control signal')
plt.title('Signal Convergence')
plt.grid(True)
plt.xlim((0, iteration-1))

plt.legend((plot_s_1[0], plot_s_2[0],plot_s_3[0], plot_s_4[0]), ('AG 1', 'AG 2','AG 3','AG 4'))
plt.savefig('../python/Result2.pdf')




#f = open('store.3phase_regulator', 'wb')
#pickle.dump(AllNodeVoltage_initial, f)
#f.close()
#
#f = open('store.3phase_regulator', 'rb')
#AllNodeVoltage_regulator = pickle.load(f)
#f.close()

plt.figure(3)
length = len(AllNodeNames)
timeLine = list(range(length))
unit_voltage = []
unit_voltage_initial = []
#unit_voltage_regulator = []
for node in range(4518):
    unit_voltage.append(AllNodeVoltage[node]/VBase[node])
    unit_voltage_initial.append(AllNodeVoltage_initial[node]/VBase[node])
#    unit_voltage_regulator.append(AllNodeVoltage_regulator[node]/VBase[node])
plot_vc_1=plt.scatter(timeLine,unit_voltage_initial,s=30)
#plot_vc_2=plt.scatter(timeLine,unit_voltage_regulator,s=10)
plot_vc_3=plt.scatter(timeLine,unit_voltage,s=10)

#for i in range(len(unit_voltage)):
#    if unit_voltage[i]<0.95:
#        print("error")
#        print(unit_voltage[i])    
plt.xlabel('Node index on primary side')
plt.ylabel('Voltage magnitude, p.u.')
plt.title('Controlled Voltage')
plt.grid(True)
plt.legend((plot_vc_1, plot_vc_3), ('Voltage w/o control', 'Voltage w/ OPF control'))
#plt.legend((plot_vc_1, plot_vc_2,plot_vc_3), ('Voltage w/o control', 'Voltage w/ default control','Voltage w/ OPF control'))
plt.xlim((0, 4521))
plt.savefig('../python/Result3.pdf')


#f = open('store.threephasevoltage', 'wb')
#pickle.dump(AllNodeVoltage, f)
#f.close()

#plt.figure(4)
#timeLine = list(range(iteration))
#linelosspert_regulator_plot = []
#linelosspert_initial_plot = []
##
##
###font = {'family' : 'normal',
###        'weight' : 'bold',
###        'size'   : 22}
##
#for i in range(iteration):
#    linelosspert_regulator_plot.append(0.07299)
##    linelosspert_initial_plot.append(0.06534)
#    linelosspert_initial_plot.append(0.0616)
#
#    
#plot_loss1 = plt.plot(timeLine,linelosspert_initial_plot, 'r--')
#plot_loss2 = plt.plot(timeLine,linelosspert_regulator_plot,'b^')
#plot_loss3 = plt.plot(timeLine,record_losspercent,'g')
#plt.xlabel('Iteration number')
#plt.ylabel('Lineloss ratio')
#plt.title('Lineloss Minimization')
#plt.grid(True)
#plt.legend((plot_loss1[0], plot_loss2[0],plot_loss3[0]), ('Lineloss w/o control', 'Lineloss w/ default control','Lineloss w/ OPF control'))
#plt.xlim((0, iteration-1))   # set the xlim to xmin, xmax
#plt.ylim(0.02, 0.08)     # set the xlim to xmin, xmax

#
plt.figure(5)
timeLine = list(range(iteration))

plot_cost = plt.plot(timeLine,totalcost, 'r--')
#totalcost_plot = totalcost000[0:1999]
#plot_cost2 = plt.plot(timeLine,totalcost000, 'b--')


plt.xlabel('Iteration number')
plt.ylabel('Total Cost')
#plt.title('Multi-Phase Algorithm')
plt.title('Two-Level Algorithm')
plt.grid(True)
#plt.legend((plot_loss1[0], plot_loss2[0],plot_loss3[0]), ('Lineloss w/o control', 'Lineloss w/ default control','Lineloss w/ OPF control'))
#plt.xlim((0, iteration-1))   # set the xlim to xmin, xmax
#plt.ylim(0.02, 0.08)     # set the xlim to xmin, xmax
#plt.ylim((10000, 45000))  
plt.xlim((0,iteration-1))
#f = open('store.totalcost_multiphase', 'wb')
#pickle.dump(totalcost, f)
#f.close()

