#!/usr/bin/env python
# coding: utf-8

# # Hierarchical State Estimation
# 

# ## I. Data Load and Pre-process

# ### 0. The 110,000 nodes distribution network

# In[18]:


## the system initialize
import networkx as nx
import matplotlib.pyplot as plt
import opendssdirect as dss
import numpy as np
import os
from numpy.linalg import inv
from itertools import combinations
import pickle
import time
import copy
import matplotlib.pyplot as plt

## For data structure, we have the maximum 10 copies of 10k node networks
D = 10

# we build a graph G
def add_lines(G,path):
    with open(path) as file:
        lines = file.readlines()
        i = 0
        for line in lines:
            if line[0]=='N':
                i =i+1
                temp = line.split(' ')
                temp = [item for item in temp if item!='']
                #print(temp[2][5:],temp[3][5:])
                index = temp[2].find('.')
                index2 = temp[3].find('.')
                if index == -1: #3 phases
                    #G.add_node(temp[2][5:].upper(),Set_phase = [0,1,2])
                    #G.add_node(temp[3][5:].upper(),Set_phase = [0,1,2])    
                    G.add_edge(temp[2][5:].upper(),temp[3][5:].upper(),Num_phase = 3, Set_phase = [0,1,2], z = np.zeros((3,3), dtype=complex))
                        
                if index!=-1: 
                    num_phase = 0
                    set_phase = []
                    if temp[2][index:]=='.1':
                        num_phase = 1
                        set_phase = [0]
                    elif temp[2][index:]=='.2':    
                        num_phase = 1
                        set_phase = [1]
                    elif temp[2][index:]=='.3':    
                        num_phase = 1
                        set_phase = [2]
                    elif temp[2][index:]=='.1.2':    
                        num_phase = 2
                        set_phase = [0,1]
                    elif temp[2][index:]=='.1.3':    
                        num_phase = 2
                        set_phase = [0,2]
                    elif temp[2][index:]=='.2.3':    
                        num_phase = 2
                        set_phase = [1,2]
                    elif temp[2][index:]=='.1.2.3':    
                        num_phase = 3
                        set_phase = [0,1,2]
                    else:
                        print("error")
                        exit(0)
                    G.add_edge(temp[2][5:index].upper(),temp[3][5:index2].upper(),Num_phase = num_phase, Set_phase = set_phase, z = np.zeros((3,3), dtype=complex))
    file.close()   


path = "../110000_node_system/Lines.dss"
path_1 = "../110000_node_system/Lines_new1.dss"
path_2 = "../110000_node_system/Lines_new2.dss"
path_3 = "../110000_node_system/Lines_new3.dss"
path_4 = "../110000_node_system/Lines_new4.dss"
path_5 = "../110000_node_system/Lines_new5.dss"
path_6 = "../110000_node_system/Lines_new6.dss"
path_7 = "../110000_node_system/Lines_new7.dss"
path_8 = "../110000_node_system/Lines_new8.dss"
path_9 = "../110000_node_system/Lines_new9.dss"

G = nx.Graph()
add_lines(G,path)
add_lines(G,path_1)
add_lines(G,path_2)
add_lines(G,path_3)
add_lines(G,path_4)
add_lines(G,path_5)
add_lines(G,path_6)
add_lines(G,path_7)
add_lines(G,path_8)
add_lines(G,path_9)

## since the problem of memory, we only construct one copy for reference
G_standard = nx.Graph()
add_lines(G_standard,path)

## add_edges
G.add_edge('HVMV_SUB_HSB', 'SOURCEBUS',Num_phase = 3, Set_phase = [0,1,2], z = np.zeros((3,3), dtype=complex))
G_standard.add_edge('HVMV_SUB_HSB', 'SOURCEBUS',Num_phase = 3, Set_phase = [0,1,2], z = np.zeros((3,3), dtype=complex))
temp_name = 'HVMV_SUB_HSB'

for i in range(1,D):
    temp_1 = 'G' + str(i) + temp_name
    G.add_edge(temp_1, 'SOURCEBUS',Num_phase = 3, Set_phase = [0,1,2], z = np.zeros((3,3), dtype=complex))

G.add_edge('REGXFMR_HVMV_SUB_LSB', '_HVMV_SUB_LSB',Num_phase = 3, Set_phase = [0,1,2], z = np.zeros((3,3), dtype=complex))
G_standard.add_edge('REGXFMR_HVMV_SUB_LSB', '_HVMV_SUB_LSB',Num_phase = 3, Set_phase = [0,1,2], z = np.zeros((3,3), dtype=complex))
temp_name_1 = 'REGXFMR_HVMV_SUB_LSB'
temp_name_2 = '_HVMV_SUB_LSB'
for i in range(1,D):
    temp_1 = 'G' + str(i) + temp_name_1
    temp_2 = 'G' + str(i) + temp_name_2
    G.add_edge(temp_1, temp_2,Num_phase = 3, Set_phase = [0,1,2], z = np.zeros((3,3), dtype=complex))


G.add_edge('REGXFMR_HVMV_SUB_LSB', 'HVMV_SUB_HSB',Num_phase = 3, Set_phase = [0,1,2], z = np.zeros((3,3), dtype=complex))
G_standard.add_edge('REGXFMR_HVMV_SUB_LSB', 'HVMV_SUB_HSB',Num_phase = 3, Set_phase = [0,1,2], z = np.zeros((3,3), dtype=complex))
temp_name_1 = 'REGXFMR_HVMV_SUB_LSB'
temp_name_2 = 'HVMV_SUB_HSB'
## define our own structure to label the nodes in different
for i in range(1,D):
    temp_1 = 'G' + str(i) + temp_name_1
    temp_2 = 'G' + str(i) + temp_name_2
    G.add_edge(temp_1, temp_2,Num_phase = 3, Set_phase = [0,1,2], z = np.zeros((3,3), dtype=complex))

G.add_edge('HVMV_SUB_48332','_HVMV_SUB_LSB',Num_phase = 3, Set_phase = [0,1,2], z = np.zeros((3,3), dtype=complex))
G_standard.add_edge('HVMV_SUB_48332','_HVMV_SUB_LSB',Num_phase = 3, Set_phase = [0,1,2], z = np.zeros((3,3), dtype=complex))
temp_name_1 = 'HVMV_SUB_48332'
temp_name_2 = '_HVMV_SUB_LSB'
for i in range(1,D):
    temp_1 = 'G' + str(i) + temp_name_1
    temp_2 = 'G' + str(i) + temp_name_2
    G.add_edge(temp_1, temp_2,Num_phase = 3, Set_phase = [0,1,2], z = np.zeros((3,3), dtype=complex))
    
G.add_edge('SOURCEBUS','EPRI_CKT7',Num_phase = 3, Set_phase = [0,1,2], z = np.zeros((3,3), dtype=complex))
G_standard.add_edge('SOURCEBUS','EPRI_CKT7',Num_phase = 3, Set_phase = [0,1,2], z = np.zeros((3,3), dtype=complex))
temp_name = 'EPRI_CKT7'
for i in range(1,D):
    temp_1 = 'G' + str(i) + temp_name
    G.add_edge(temp_1, 'SOURCEBUS',Num_phase = 3, Set_phase = [0,1,2], z = np.zeros((3,3), dtype=complex))

G.add_edge('EPRI_CKT7','CKT7',Num_phase = 3, Set_phase = [0,1,2], z = np.zeros((3,3), dtype=complex))
G_standard.add_edge('EPRI_CKT7','CKT7',Num_phase = 3, Set_phase = [0,1,2], z = np.zeros((3,3), dtype=complex))
temp_name_1 = 'EPRI_CKT7'
temp_name_2 = 'CKT7'
for i in range(1,D):
    temp_1 = 'G' + str(i) + temp_name_1
    temp_2 = 'G' + str(i) + temp_name_2
    G.add_edge(temp_1, temp_2,Num_phase = 3, Set_phase = [0,1,2], z = np.zeros((3,3), dtype=complex))

G.add_edge('CKT7','318412',Num_phase = 3, Set_phase = [0,1,2], z = np.zeros((3,3), dtype=complex))
G_standard.add_edge('CKT7','318412',Num_phase = 3, Set_phase = [0,1,2], z = np.zeros((3,3), dtype=complex))
temp_name_1 = '318412'
temp_name_2 = 'CKT7'
for i in range(1,D):
    temp_1 = 'G' + str(i) + temp_name_1
    temp_2 = 'G' + str(i) + temp_name_2
    G.add_edge(temp_1, temp_2,Num_phase = 3, Set_phase = [0,1,2], z = np.zeros((3,3), dtype=complex))

G.add_edge('REGXFMR_190-8593','190-8593',Num_phase = 3, Set_phase = [0,1,2], z = np.zeros((3,3), dtype=complex))
G_standard.add_edge('REGXFMR_190-8593','190-8593',Num_phase = 3, Set_phase = [0,1,2], z = np.zeros((3,3), dtype=complex))
temp_name_1 = 'REGXFMR_190-8593'
temp_name_2 = '190-8593'
for i in range(1,D):
    temp_1 = 'G' + str(i) + temp_name_1
    temp_2 = 'G' + str(i) + temp_name_2
    G.add_edge(temp_1, temp_2,Num_phase = 3, Set_phase = [0,1,2], z = np.zeros((3,3), dtype=complex))

G.add_edge('REGXFMR_190-8581','190-8581',Num_phase = 3, Set_phase = [0,1,2], z = np.zeros((3,3), dtype=complex))
G_standard.add_edge('REGXFMR_190-8581','190-8581',Num_phase = 3, Set_phase = [0,1,2], z = np.zeros((3,3), dtype=complex))
temp_name_1 = 'REGXFMR_190-8581'
temp_name_2 = '190-8581'
for i in range(1,D):
    temp_1 = 'G' + str(i) + temp_name_1
    temp_2 = 'G' + str(i) + temp_name_2
    G.add_edge(temp_1, temp_2,Num_phase = 3, Set_phase = [0,1,2], z = np.zeros((3,3), dtype=complex))

G.add_edge('REGXFMR_190-7361','190-7361',Num_phase = 3, Set_phase = [0,1,2], z = np.zeros((3,3), dtype=complex))
G_standard.add_edge('REGXFMR_190-7361','190-7361',Num_phase = 3, Set_phase = [0,1,2], z = np.zeros((3,3), dtype=complex))
temp_name_1 = 'REGXFMR_190-7361'
temp_name_2 = '190-7361'
for i in range(1,D):
    temp_1 = 'G' + str(i) + temp_name_1
    temp_2 = 'G' + str(i) + temp_name_2
    G.add_edge(temp_1, temp_2,Num_phase = 3, Set_phase = [0,1,2], z = np.zeros((3,3), dtype=complex))

G_standard.remove_edge('181932', '236965')
G.remove_edge('181932', '236965')
G.remove_edge('G1181932', 'G1236965')
G.remove_edge('G2181932', 'G2236965')
G.remove_edge('G3181932', 'G3236965')
G.remove_edge('G4181932', 'G4236965')
G.remove_edge('G5181932', 'G5236965')
G.remove_edge('G6181932', 'G6236965')
G.remove_edge('G7181932', 'G7236965')
G.remove_edge('G8181932', 'G8236965')
G.remove_edge('G9181932', 'G9236965')

G.remove_edge('228-1353934-4_INT','193-103041')
G_standard.remove_edge('228-1353934-4_INT','193-103041')
G.remove_edge('G1228-1353934-4_INT','G1193-103041')
G.remove_edge('G2228-1353934-4_INT','G2193-103041')
G.remove_edge('G3228-1353934-4_INT','G3193-103041')
G.remove_edge('G4228-1353934-4_INT','G4193-103041')
G.remove_edge('G5228-1353934-4_INT','G5193-103041')
G.remove_edge('G6228-1353934-4_INT','G6193-103041')
G.remove_edge('G7228-1353934-4_INT','G7193-103041')
G.remove_edge('G8228-1353934-4_INT','G8193-103041')
G.remove_edge('G9228-1353934-4_INT','G9193-103041')

G.remove_edge('228-961799-3_INT','193-46661')
G_standard.remove_edge('228-961799-3_INT','193-46661')
G.remove_edge('G1228-961799-3_INT','G1193-46661')
G.remove_edge('G2228-961799-3_INT','G2193-46661')
G.remove_edge('G3228-961799-3_INT','G3193-46661')
G.remove_edge('G4228-961799-3_INT','G4193-46661')
G.remove_edge('G5228-961799-3_INT','G5193-46661')
G.remove_edge('G6228-961799-3_INT','G6193-46661')
G.remove_edge('G7228-961799-3_INT','G7193-46661')
G.remove_edge('G8228-961799-3_INT','G8193-46661')
G.remove_edge('G9228-961799-3_INT','G9193-46661')

G.remove_edge('181932', '181933')
G_standard.remove_edge('181932', '181933')
G.remove_edge('G1181932', 'G1181933')
G.remove_edge('G2181932', 'G2181933')
G.remove_edge('G3181932', 'G3181933')
G.remove_edge('G4181932', 'G4181933')
G.remove_edge('G5181932', 'G5181933')
G.remove_edge('G6181932', 'G6181933')
G.remove_edge('G7181932', 'G7181933')
G.remove_edge('G8181932', 'G8181933')
G.remove_edge('G9181932', 'G9181933')


G.remove_edge('D5837361-8_INT', 'E182745')
G_standard.remove_edge('D5837361-8_INT', 'E182745')
G.remove_edge('G1D5837361-8_INT', 'G1E182745')
G.remove_edge('G2D5837361-8_INT', 'G2E182745')
G.remove_edge('G3D5837361-8_INT', 'G3E182745')
G.remove_edge('G4D5837361-8_INT', 'G4E182745')
G.remove_edge('G5D5837361-8_INT', 'G5E182745')
G.remove_edge('G6D5837361-8_INT', 'G6E182745')
G.remove_edge('G7D5837361-8_INT', 'G7E182745')
G.remove_edge('G8D5837361-8_INT', 'G8E182745')
G.remove_edge('G9D5837361-8_INT', 'G9E182745')


G.remove_edge('228-979371-2_INT', '193-48013')
G_standard.remove_edge('228-979371-2_INT', '193-48013')
G.remove_edge('G1228-979371-2_INT', 'G1193-48013')
G.remove_edge('G2228-979371-2_INT', 'G2193-48013')
G.remove_edge('G3228-979371-2_INT', 'G3193-48013')
G.remove_edge('G4228-979371-2_INT', 'G4193-48013')
G.remove_edge('G5228-979371-2_INT', 'G5193-48013')
G.remove_edge('G6228-979371-2_INT', 'G6193-48013')
G.remove_edge('G7228-979371-2_INT', 'G7193-48013')
G.remove_edge('G8228-979371-2_INT', 'G8193-48013')
G.remove_edge('G9228-979371-2_INT', 'G9193-48013')

G.remove_edge ('193-51796', '228-1048090-1_INT')
G_standard.remove_edge ('193-51796', '228-1048090-1_INT')
G.remove_edge ('G1193-51796', 'G1228-1048090-1_INT')
G.remove_edge ('G2193-51796', 'G2228-1048090-1_INT')
G.remove_edge ('G3193-51796', 'G3228-1048090-1_INT')
G.remove_edge ('G4193-51796', 'G4228-1048090-1_INT')
G.remove_edge ('G5193-51796', 'G5228-1048090-1_INT')
G.remove_edge ('G6193-51796', 'G6228-1048090-1_INT')
G.remove_edge ('G7193-51796', 'G7228-1048090-1_INT')
G.remove_edge ('G8193-51796', 'G8228-1048090-1_INT')
G.remove_edge ('G9193-51796', 'G9228-1048090-1_INT')

print('The Number of Nodes is ')
print(len(G.nodes))
print('The Number of Edges is')
print(len(G.edges))
print('Is this network pure tree ?')
print(nx.is_tree(G))
# print(nx.is_tree(G_standard))


# ### 1. In this section, we recall the names of all nodes from pre-defined OpenDSS file, and build a dictionary for conveniently searching index and name of nodes. And then we formulate ZMatrix of 10k standard network in the multi-phase situation.

# In[2]:


MainDir = os.path.dirname(os.getcwd())
print(MainDir)
dss.run_command("Compile 'C:/Users/XZHOU/Desktop/multi-phase_control/110000_node_system/MasterWang2.dss'")
circuit = dss.Circuit
AllNodeNames = circuit.YNodeOrder()
AllNodeNames = [str(node) for node in AllNodeNames]
node_number = len(AllNodeNames)


NameToIndex = {}
IndexToName = {}

i = 1
for name in AllNodeNames:
    NameToIndex[name] = i
    IndexToName[i] = name
    i+=1
    
Y_path = "C:/Users/XZHOU/Desktop/multi-phase_control/11000_node_system/11000_systemY.txt"  
ZMatrix = np.zeros(shape=(node_number+1,node_number+1),dtype=complex)
with open(Y_path) as file:
    lines = file.readlines()
    for line in lines:
        if(line[0]=='['):
            index1 = line.find(',')
            row = int(line[1:index1])
            index2 = line.find(']')
            col = int(line[index1+1:index2])
            index1 = line.find('=')
            index2 = line.find('+')
            real = float(line[index1+1:index2])
            index1 = line.find('j')
            imag = float(line[index1+1:])
            Y_complex = complex(real,imag)
            ZMatrix[row,col] = Y_complex
            ZMatrix[col,row] = Y_complex

#update the line z matrix
for edge in G_standard.edges:
    num_phase = G_standard[edge[0]][edge[1]]['Num_phase']
    set_phase = G_standard[edge[0]][edge[1]]['Set_phase']
    if num_phase==1:
        phase1 = set_phase[0]
        row = NameToIndex[edge[0]+"."+str(phase1+1)]
        col = NameToIndex[edge[1]+"."+str(phase1+1)]
        G_standard[edge[0]][edge[1]]['z'][phase1][phase1] = ZMatrix[row][col]
    elif num_phase==2:
        phase1 = set_phase[0]
        phase2 = set_phase[1]
        row = NameToIndex[edge[0]+"."+str(phase1+1)]
        col = NameToIndex[edge[1]+"."+str(phase1+1)]
        G_standard[edge[0]][edge[1]]['z'][phase1][phase1] = ZMatrix[row][col]
        
        row = NameToIndex[edge[0]+"."+str(phase2+1)]
        col = NameToIndex[edge[1]+"."+str(phase2+1)]
        G_standard[edge[0]][edge[1]]['z'][phase2][phase2] = ZMatrix[row][col]
        
        row = NameToIndex[edge[0]+"."+str(phase1+1)]
        col = NameToIndex[edge[1]+"."+str(phase2+1)]
        G_standard[edge[0]][edge[1]]['z'][phase1][phase2] = ZMatrix[row][col]
        G_standard[edge[0]][edge[1]]['z'][phase2][phase1] = ZMatrix[row][col]
    else:
        #print(set_phase)
        phase1 = set_phase[0]
        phase2 = set_phase[1]
        phase3 = set_phase[2]
        row = NameToIndex[edge[0]+"."+str(phase1+1)]
        col = NameToIndex[edge[1]+"."+str(phase1+1)]
        G_standard[edge[0]][edge[1]]['z'][phase1][phase1] = ZMatrix[row][col]
        
        row = NameToIndex[edge[0]+"."+str(phase2+1)]
        col = NameToIndex[edge[1]+"."+str(phase2+1)]
        G_standard[edge[0]][edge[1]]['z'][phase2][phase2] = ZMatrix[row][col]
        
        row = NameToIndex[edge[0]+"."+str(phase3+1)]
        col = NameToIndex[edge[1]+"."+str(phase3+1)]
        G_standard[edge[0]][edge[1]]['z'][phase3][phase3] = ZMatrix[row][col]
        
        row = NameToIndex[edge[0]+"."+str(phase1+1)]
        col = NameToIndex[edge[1]+"."+str(phase2+1)]
        G_standard[edge[0]][edge[1]]['z'][phase1][phase2] = ZMatrix[row][col]
        G_standard[edge[0]][edge[1]]['z'][phase2][phase1] = ZMatrix[row][col]

        row = NameToIndex[edge[0]+"."+str(phase1+1)]
        col = NameToIndex[edge[1]+"."+str(phase3+1)]
        G_standard[edge[0]][edge[1]]['z'][phase1][phase3] = ZMatrix[row][col]
        G_standard[edge[0]][edge[1]]['z'][phase3][phase1] = ZMatrix[row][col]

        row = NameToIndex[edge[0]+"."+str(phase2+1)]
        col = NameToIndex[edge[1]+"."+str(phase3+1)]
        G_standard[edge[0]][edge[1]]['z'][phase2][phase3] = ZMatrix[row][col]
        G_standard[edge[0]][edge[1]]['z'][phase3][phase2] = ZMatrix[row][col]
    temp = G_standard[edge[0]][edge[1]]['z']
    G_standard[edge[0]][edge[1]]['z'] =  -np.linalg.pinv(temp)  

ToSource = {}
node_set = list(G_standard.nodes)
node_set.remove('SOURCEBUS')
for node in node_set:
    paths = nx.shortest_path(G_standard,source='SOURCEBUS',target=node)
    temp = np.zeros(shape=(3,3),dtype=complex)
    for i in range(len(paths)-1):
            temp += G_standard[paths[i]][paths[i+1]]['z']
    ToSource[node] = temp.conjugate()
    node_other = paths[-2]
    G_standard.node[node]['Set_phase'] = G_standard[node_other][node]['Set_phase']
ToSource['SOURCEBUS'] = np.zeros(shape=(3,3),dtype=complex)
G_standard.node['SOURCEBUS']['Set_phase'] = [0,1,2]


# ### 2. Re-do the name index process for 10 times, to let all 100k nodes have their own identity.

# In[3]:


MainDir = os.path.dirname(os.getcwd())
print(MainDir)
dss.run_command("Compile 'C:/Users/XZHOU/Desktop/multi-phase_control/110000_node_system/Master100k.dss'")
circuit = dss.Circuit
AllNodeNames = circuit.YNodeOrder()
AllNodeNames = [str(node) for node in AllNodeNames]
node_number = len(AllNodeNames)
print(len(AllNodeNames))

NameToIndex = {}
IndexToName = {}

i = 1
for name in AllNodeNames:
    NameToIndex[name] = i
    IndexToName[i] = name
    i+=1
    
list(G.neighbors('SOURCEBUS'))


# ### 3. Create all clusters in multi-phases for all copies, 1-10.

# In[4]:


## create cluster_1 of all graph 1--10
G_1 = [] 
for i in range(D):
    g_1 = nx.Graph()
    base_name_1 = 'L3081380'
    base_name_2 = 'M1142843'
    if i != 0:
        base_name_1 = 'G' + str(i) + base_name_1
        base_name_2 = 'G' + str(i) + base_name_2
    num_phase = G[base_name_1][base_name_2]['Num_phase']
    set_phase = G[base_name_1][base_name_2]['Set_phase']
    #z_restore = G[base_name_1][base_name_2]['z']
    G.remove_edge(base_name_1,base_name_2)
    bfs = list(nx.bfs_edges(G,base_name_1))
#    print(len(bfs))
    #print(bfs)
    G.add_edge(base_name_1,base_name_2,Num_phase=num_phase,Set_phase=set_phase)#,z=z_restore)
    g_1.add_edges_from(bfs)
#    print(len(g_1.edges),len(g_1.nodes))
    G_1.append(g_1)

G_2 = []
for i in range(D):
    g_2 = nx.Graph()
    base_name_1 = 'M1047515'
    base_name_2 = 'M1047513'
    if i != 0:
        base_name_1 = 'G' + str(i) + base_name_1
        base_name_2 = 'G' + str(i) + base_name_2
    num_phase = G[base_name_1][base_name_2]['Num_phase']
    set_phase = G[base_name_1][base_name_2]['Set_phase']
    #z_restore = G[base_name_1][base_name_2]['z']
    G.remove_edge(base_name_1,base_name_2)
    bfs = list(nx.bfs_edges(G,base_name_2))
#    print(len(bfs))
    #print(bfs)
    G.add_edge(base_name_1,base_name_2,Num_phase=num_phase,Set_phase=set_phase)#,z=z_restore)
    g_2.add_edges_from(bfs)
#    print(len(g_2.edges),len(g_2.nodes))
    G_2.append(g_2)

G_3 = []
for i in range(D):
    g_3 = nx.Graph()
    base_name_1 = 'L3066815'
    base_name_2 = '196-29519'
    if i != 0:
        base_name_1 = 'G' + str(i) + base_name_1
        base_name_2 = 'G' + str(i) + base_name_2
    num_phase = G[base_name_1][base_name_2]['Num_phase']
    set_phase = G[base_name_1][base_name_2]['Set_phase']
    #z_restore = G[base_name_1][base_name_2]['z']
    G.remove_edge(base_name_1,base_name_2)
    bfs = list(nx.bfs_edges(G,base_name_1))
#    print(len(bfs))
    #print(bfs)
    G.add_edge(base_name_1,base_name_2,Num_phase=num_phase,Set_phase=set_phase)#,z=z_restore)
    g_3.add_edges_from(bfs)
#    print(len(g_3.edges),len(g_3.nodes))
    G_3.append(g_3)
    
G_4 = []
for i in range(D):
    g_4 = nx.Graph()
    base_name_1 = 'SOURCEBUS'
    base_name_2 = 'EPRI_CKT7'
    if i != 0:
        #base_name_1 = 'G' + str(i) + base_name_1
        base_name_2 = 'G' + str(i) + base_name_2
    num_phase = G[base_name_1][base_name_2]['Num_phase']
    set_phase = G[base_name_1][base_name_2]['Set_phase']
    #z_restore = G[base_name_1][base_name_2]['z']
    #print(i,base_name_1,base_name_2)
    G.remove_edge(base_name_1,base_name_2)
    bfs = list(nx.bfs_edges(G,base_name_2))
#    print(len(bfs))
    #print(bfs)
    G.add_edge(base_name_1,base_name_2,Num_phase=num_phase,Set_phase=set_phase)#,z=z_restore)
    #print(i,base_name_1,base_name_2)
    g_4.add_edges_from(bfs)
#    print(len(g_4.edges),len(g_4.nodes))
    G_4.append(g_4)

G_main = []
g_main = nx.Graph()
num_phase1 = G['L3081380']['M1142843']['Num_phase']
set_phase1 = G['L3081380']['M1142843']['Set_phase']
#z_restore1 = G['L3081380']['M1142843']['z']
num_phase2 = G['M1047515']['M1047513']['Num_phase']
set_phase2 = G['M1047515']['M1047513']['Set_phase']
#z_restore2 = G['M1047515']['M1047513']['z']
num_phase3 = G['L3066815']['196-29519']['Num_phase']
set_phase3 = G['L3066815']['196-29519']['Set_phase']
#z_restore3 = G['L3066815']['196-29519']['z']    
num_phase4 = G['SOURCEBUS']['EPRI_CKT7']['Num_phase']
set_phase4 = G['SOURCEBUS']['EPRI_CKT7']['Set_phase']
#z_restore4 = G['SOURCEBUS']['EPRI_CKT7']['z']  

print(list(G.neighbors('SOURCEBUS')))
set_phase_1 = []
num_phase_1 = []
#z_restore_1 = []
set_phase_2 = []
num_phase_2 = []
#z_restore_2 = []
name_1 = 'EPRI_CKT7'
name_2 = 'HVMV_SUB_HSB'
for i in range(1,D):
    temp_1 = 'G' + str(i) + name_1
    temp_2 = 'G' + str(i) + name_2
    num_phase_1.append(G['SOURCEBUS'][temp_1]['Num_phase'])
    num_phase_2.append(G['SOURCEBUS'][temp_2]['Num_phase'])
    set_phase_1.append(G['SOURCEBUS'][temp_1]['Set_phase'])
    set_phase_2.append(G['SOURCEBUS'][temp_2]['Set_phase'])
   # z_restore_1.append(G['SOURCEBUS'][temp_1]['z'])
    #z_restore_2.append(G['SOURCEBUS'][temp_2]['z'])  
    G.remove_edge('SOURCEBUS',temp_1)
    G.remove_edge('SOURCEBUS',temp_2)
G.remove_edge('SOURCEBUS','EPRI_CKT7')
G.remove_edge('L3066815','196-29519')
G.remove_edge('M1047515','M1047513')
G.remove_edge('L3081380','M1142843')
bfs = list(nx.bfs_edges(G,'M1142843'))
#print(bfs)
#print(len(bfs))
G.add_edge('L3081380','M1142843',Num_phase=num_phase1,Set_phase=set_phase1)#,z=z_restore1)
G.add_edge('M1047515','M1047513',Num_phase=num_phase2,Set_phase=set_phase2)#,z=z_restore2)
G.add_edge('L3066815','196-29519',Num_phase=num_phase3,Set_phase=set_phase3)#,z=z_restore3)
G.add_edge('SOURCEBUS','EPRI_CKT7',Num_phase=num_phase4,Set_phase=set_phase4)#,z=z_restore4)
for i in range(1,D):
    temp_1 = 'G' + str(i) + name_1
    temp_2 = 'G' + str(i) + name_2
    G.add_edge('SOURCEBUS',temp_1,Num_phase=num_phase_1[i-1],Set_phase=set_phase_1[i-1])#,z=z_restore_1[i-1])
    G.add_edge('SOURCEBUS',temp_2,Num_phase=num_phase_2[i-1],Set_phase=set_phase_1[i-1])#,z=z_restore_2[i-1])
g_main.add_edges_from(bfs)
G_main.append(g_main)
for i in range(1,D):
    temp = nx.Graph()
    temp_bfs = []
    for item in bfs:
        edge_1 = item[0]
        if item[0] != 'SOURCEBUS':
            edge_1 = 'G' + str(i) + item[0]
        edge_2 = item[1]
        if item[1] != 'SOURCEBUS':
            edge_2 = 'G' + str(i) + item[1]
        temp_bfs.append((edge_1,edge_2))
    temp.add_edges_from(temp_bfs)
    G_main.append(temp)

def clusterPhaseSet(list):
    result1 = []
    result2 = []
    result3 = []
    i = 0
    for graph in list:
        temp1 = []
        temp2 = []
        temp3 = []
        for node in graph.nodes:
            if node == 'SOURCEBUS' or i == 0:
                phases = G_standard.node[node]['Set_phase']
            else:
                phases = G_standard.node[node[2:]]['Set_phase']
            if 0 in phases:
                temp1.append(node)
            if 1 in phases:
                temp2.append(node)
            if 2 in phases:
                temp3.append(node)
        result1.append(temp1)
        result2.append(temp2)
        result3.append(temp3)
        i = i+1
    return result1,result2,result3
G_1_1, G_1_2, G_1_3 = clusterPhaseSet(G_1) # G_1_phase 1,2,3
G_2_1, G_2_2, G_2_3 = clusterPhaseSet(G_2) # G_2_phase 1,2,3
G_3_1, G_3_2, G_3_3 = clusterPhaseSet(G_3) # G_3_phase 1,2,3
G_4_1, G_4_2, G_4_3 = clusterPhaseSet(G_4) # G_4_phase 1,2,3
G_main_1, G_main_2, G_main_3 = clusterPhaseSet(G_main)

def MakeDict(G_n):
    G_n_directed = nx.DiGraph()
    G_n_directed.add_edges_from(G_n.edges)
    G_n_dic = {}
    i = 0
    for node in G_n.nodes:
        G_n_dic[node+node] = node
        children = list(G_n_directed.successors(node))
        if len(children)==1:
            tree_1 = list(dict(nx.bfs_successors(G_n_directed, children[0])).values())
            tree_1_flat = [item for sublist in tree_1 for item in sublist]
            tree_1_flat.append(children[0])
            for succ in tree_1_flat:
                i+=1
                if node >= succ: #bigsmall
                    G_n_dic[node+succ] = node
                else:
                    G_n_dic[succ+node] = node
        elif len(children)==0:
            continue
        else: 
            for child in children:
                tree_1 = list(dict(nx.bfs_successors(G_n_directed, child)).values())
                tree_1_flat = [item for sublist in tree_1 for item in sublist]
                tree_1_flat.append(child)
                for succ in tree_1_flat:
                    i+=1
                    if node >= succ: #bigsmall
                        G_n_dic[node+succ] = node
                    else:
                        G_n_dic[succ+node] = node
            comb = combinations(children,2)
            for nodes in list(comb):
                tree_1 = list(dict(nx.bfs_successors(G_n_directed, nodes[0])).values())
                tree_1_flat = [item for sublist in tree_1 for item in sublist]
                tree_1_flat.append(nodes[0])
                tree_2 = list(dict(nx.bfs_successors(G_n_directed, nodes[1])).values())
                tree_2_flat = [item for sublist in tree_2 for item in sublist]
                tree_2_flat.append(nodes[1])
                for node_1 in tree_1_flat:
                    for node_2 in tree_2_flat:
                        i+=1
                        if node_1 >= node_2: #bigsmall
                            G_n_dic[node_1+node_2] = node
                        else:
                            G_n_dic[node_2+node_1] = node    
    return G_n_dic

G_1_dic = []
for i in range(D):
    temp = MakeDict(G_1[i])
    G_1_dic.append(temp)

G_2_dic = []
for i in range(D):
    temp = MakeDict(G_2[i])
    G_2_dic.append(temp)
G_3_dic = []
for i in range(D):
    temp = MakeDict(G_3[i])
    G_3_dic.append(temp)
G_4_dic = []
for i in range(D):
    temp = MakeDict(G_4[i])
    G_4_dic.append(temp)
    
G_main_dic = []
for i in range(D):
    temp = MakeDict(G_main[i])
    G_main_dic.append(temp)
    
#file_name = "G_dict.data"
#file_pointer = open(file_name, 'wb')
#pickle.dump([G_1_dic,G_2_dic,G_3_dic,G_4_dic,G_main_dic],file_pointer)
#file_pointer.close()


## calculate the lCP for each cluster.
def crossCluster(G_1,G_2):
    node_1 = list(G_1.nodes)[0]
    node_2 = list(G_2.nodes)[0]
    path_1 = nx.dijkstra_path(G,'SOURCEBUS',node_1)
    path_2 = nx.dijkstra_path(G,'SOURCEBUS',node_2)
    minLen = min(len(path_1),len(path_2))
    for i in range(minLen):
        if path_1[i] == path_2[i]:
            node = path_1[i]
        else:
            break
#    print(node)
    return ToSource[node]

### all LCP are the same, so we don't repeat
G_12 = crossCluster(G_1[0],G_2[0])
G_13 = crossCluster(G_1[0],G_3[0])
G_14 = crossCluster(G_1[0],G_4[0])
G_23 = crossCluster(G_2[0],G_3[0])
G_24 = crossCluster(G_2[0],G_4[0])
G_34 = crossCluster(G_3[0],G_4[0])


# ### 4. Process the load files: For all loads. Find the mapping (load to node) and also phases for each load

# In[5]:


loadFile = 'C:/Users/XZHOU/Desktop/multi-phase_control/110000_node_system/Loadswenbo.dss'
Loads_1 = {} ## key-value: LoadName-PhaseSet
Loads_2 = {}
Loads_3 = {}
Loads_4 = {}
Loads_main = {} 
LoadToNode = {} ## no phase extension


def whichCluster(LoadName,NodeName,PhaseSet):
    if NodeName in list(G_1[0].nodes):
        Loads_1[LoadName] = PhaseSet
    elif NodeName in list(G_2[0].nodes):
        Loads_2[LoadName] = PhaseSet
    elif NodeName in list(G_3[0].nodes):
        Loads_3[LoadName] = PhaseSet
    elif NodeName in list(G_4[0].nodes):
        Loads_4[LoadName] = PhaseSet
    elif NodeName in list(G_main[0].nodes):
        Loads_main[LoadName] = PhaseSet
    else:
        print(NodeName,PhaseSet)
        print("Error_whichCluster")
with open(loadFile) as file:
    lines = file.readlines()
    for line in lines:
        if line[0]=='N':
            temp = line.split(' ')
            temp = [item for item in temp if item!='']
            if temp[3][-6:]=='.1.2.3':
                LoadName = temp[1][5:]
                NodeName = temp[3][:-6]
                LoadToNode[LoadName] = NodeName
                whichCluster(LoadName,NodeName,[0,1,2])
            elif temp[3][-2:]=='.1':
                LoadName = temp[1][5:]
                NodeName = temp[3][:-2]
                LoadToNode[LoadName] = NodeName
                whichCluster(LoadName,NodeName,[0])
            elif temp[3][-2:]=='.2':
                LoadName = temp[1][5:]
                NodeName = temp[3][:-2]
                LoadToNode[LoadName] = NodeName
                whichCluster(LoadName,NodeName,[1])
            elif temp[3][-2:]=='.3':
                LoadName = temp[1][5:]
                NodeName = temp[3][:-2]
                LoadToNode[LoadName] = NodeName
                whichCluster(LoadName,NodeName,[2])


# ## II. Distributed Control Algorithm Design

# ### 5. Define the phase shift functions, voltage capture function (with OpenDSS).

# In[6]:


####Control part
#### Circuit
#### AllNodeName
import math
import cmath
cmathexp = {}
cmathexp[0] = cmath.exp(1j*2*math.pi*(0)/3) ### 0-0,1-1,2-2  
cmathexp[1] = cmath.exp(1j*2*math.pi*(1)/3) ### 1-0，2-1
cmathexp[2] = cmath.exp(1j*2*math.pi*(2)/3) ### 2-0,
cmathexp[-1] = cmath.exp(1j*2*math.pi*(-1)/3) ### 0-1,1-2
cmathexp[-2] = cmath.exp(1j*2*math.pi*(-2)/3) ### 0-2

##YVol contains real and image part.
def Voltage(YVol,NodeNum):
    YMag = [0]*NodeNum
    for i in range(NodeNum):
        YMag[i] = math.sqrt(YVol[2*i]**2 + YVol[2*i+1]**2)
    return YMag

###VBase, VUpper, VLower for each node
def BoundVol(AllNodeNames,circuit):
    length = len(AllNodeNames)
    VUpper = [0]*length
    VLower = [0]*length
    VBase  = [0]*length
    for i in range(length):
        circuit.SetActiveBus(AllNodeNames[i])
        base = dss.Bus.kVBase()*1000
        VUpper[i] = base*1.05
        VLower[i] = base*0.95
        VBase[i] = base
    return VUpper,VLower,VBase

###initialPV######## Load_Set is dictionary
### Here we add a for loop to have load initialPV for 1 -- 10
def getInitialPV(Loads_Set):
    P_initial = {}
    Q_initial = {}
    for LoadName in Loads_Set.keys():
        loadKW = '? Load.' + LoadName.lower() + '.kw'
        loadKVar = '? Load.' + LoadName.lower() + '.kvar'
        p = dss.run_command(loadKW)
        q = dss.run_command(loadKVar)
        P_initial[LoadName] = float(p)
        Q_initial[LoadName] = float(q)
        for i in range(1,D):
            temp = 'G'+str(i) +LoadName
            loadKW = '? Load.' + temp.lower() + '.kw'
            loadKVar = '? Load.' + temp.lower() + '.kvar'
            p = dss.run_command(loadKW)
            q = dss.run_command(loadKVar)
            P_initial[temp] = float(p)
            Q_initial[temp] = float(q)
    return P_initial,Q_initial


# ### 6. Calculate the Signal Communication Signal

# In[7]:


def CalSignal(List):
    signal = []
    i = 0
    for graph in List:
        signal_all = [0]*3
    ### return 3 phase separately.
        for node in graph.nodes:
            transNode = node
            if i == 0 or node == 'SOURCEBUS':
                transNode = node
            else:
                transNode = node[2:]
            for phase in G_standard.node[transNode]['Set_phase']:
                name = node + '.' + str(phase+1)
                index = NameToIndex[name]
                #print(index)
                ####
#                signal_all[phase] += (Mu_Upper[index] - Mu_Lower[index]) #comment out
                if V_fix[index] != 0: # Add this comment for SE algorithm
                    signal_all[phase] += (V_est[index] - V_fix[index])
                ####
        signal.append(signal_all)
        i = i+1
    return signal


# ### 7. Calculate the Signal Communication Signal

# In[8]:


def CalInner(G_subtree,G_subtree_dic,Load,Phase_load,G_subtree_1,G_subtree_2,G_subtree_3,K):      
    node_load = LoadToNode[Load]
    if K != 0:
        node_load = 'G' + str(K) + node_load
    #node_load_phase = node_load + '.' + str(Phase_load+1)
    #index_load = NameToIndex[node_load_phase]
    inner_Signal_1 = 0 + 0j
    inner_Signal_2 = 0 + 0j
    inner_Signal_3 = 0 + 0j
    #total1 = 0 
    #total2 = 0
    for node_other in G_subtree_1:
        if node_load >= node_other:
            com_node = G_subtree_dic[node_load+node_other]
        else:
            com_node = G_subtree_dic[node_other+node_load]
        if K==0:
            Z = ToSource[com_node]
        else: 
            Z = ToSource[com_node[2:]]       
            
        Zji = Z[Phase_load,0]
        node_other_phase = node_other + '.1'
        index_other = NameToIndex[node_other_phase]
        ################################################
        if V_fix[index_other] != 0:
            Mu = V_est[index_other] - V_fix[index_other]
        else:
            Mu = 0
        inner_Signal_1 += (Zji*Mu)       
        ################################################     
    inner_Signal_1 =  inner_Signal_1*cmathexp[0-Phase_load]
    
    for node_other in G_subtree_2:
        if node_load >= node_other:
            com_node = G_subtree_dic[node_load+node_other]
        else:
            com_node = G_subtree_dic[node_other+node_load]
        if K==0:
            Z = ToSource[com_node]
        else: 
            Z = ToSource[com_node[2:]]
        Zji = Z[Phase_load,1]
        node_other_phase = node_other + '.2'
        index_other = NameToIndex[node_other_phase]
        ################################################
        if V_fix[index_other] != 0:
            Mu = V_est[index_other] - V_fix[index_other]
        else:
            Mu = 0
        inner_Signal_2 += (Zji*Mu) 
        ################################################
    inner_Signal_2 =  inner_Signal_2*cmathexp[1-Phase_load]
    
    for node_other in G_subtree_3:
        if node_load >= node_other:
            com_node = G_subtree_dic[node_load+node_other]
        else:
            com_node = G_subtree_dic[node_other+node_load]
        if K==0:
            Z = ToSource[com_node]
        else: 
            Z = ToSource[com_node[2:]]
        Zji = Z[Phase_load,2]
        node_other_phase = node_other + '.3'
        index_other = NameToIndex[node_other_phase]
        #temp = Mu_Upper[index_other] - Mu_Lower[index_other]
        #ran = random.randint(1,11)
        #if ran < 4:
        #    temp = random.randint(-100,100)
        ################################################
        if V_fix[index_other] != 0:
            Mu = V_est[index_other] - V_fix[index_other]
        else:
            Mu = 0
        inner_Signal_3 += (Zji*Mu) 
        ################################################
    inner_Signal_3 =  inner_Signal_3*cmathexp[2-Phase_load]
    inner_Signal = inner_Signal_1 + inner_Signal_2 + inner_Signal_3
    return 2*inner_Signal.real,-2*inner_Signal.imag


# ### 8. Design the estimation functions for load (p,q)

# In[9]:


def estimation(real_1,real_2,error):
    estimate_1 = {}
    estimate_2 = {}
    estimate_3 = {}
    estimate_4 = {}
#    error=0.5
    for key,value in real_1.items():
        temp = value*(1.0+np.random.normal(0,error,1))
        estimate_1[key] = temp
        estimate_3[key] = temp
    for key,value in real_2.items():
        temp = value*(1.0+np.random.normal(0,error,1))
        estimate_2[key] = temp
        estimate_4[key] = temp
    return estimate_1,estimate_2,estimate_3,estimate_4


# ### 9. Loads all node voltages and estimate all loads (p,q).

# In[10]:


Mu_Upper = [0]*(node_number+1)
Mu_Lower = [0]*(node_number+1)

V_fix  = [0]*(node_number+1)
V_est  =[1]*(node_number+1)

VUpper, VLower, VBase = BoundVol(AllNodeNames,circuit)
YVol = circuit.YNodeVArray()
AllNodeVoltage = Voltage(YVol,node_number)
BaseVoltage = Voltage(YVol,node_number)
AllNodeVoltage_initial = AllNodeVoltage

###get the initial (p,q) for each cluster
P_1,Q_1 = getInitialPV(Loads_1)
P_2,Q_2 = getInitialPV(Loads_2)
P_3,Q_3 = getInitialPV(Loads_3)
P_4,Q_4 = getInitialPV(Loads_4)

####save the value for future use
P_1_real,Q_1_real = getInitialPV(Loads_1)
P_2_real,Q_2_real = getInitialPV(Loads_2)
P_3_real,Q_3_real = getInitialPV(Loads_3)
P_4_real,Q_4_real = getInitialPV(Loads_4)

####get the estimation of (p,q) ____(estimateion,fix)
error = 0.00
P_1,Q_1,P_1_restore,Q_1_restore = estimation(P_1_real,Q_1_real,error)
P_2,Q_2,P_2_restore,Q_2_restore = estimation(P_2_real,Q_2_real,error)
P_3,Q_3,P_3_restore,Q_3_restore = estimation(P_3_real,Q_3_real,error)
P_4,Q_4,P_4_restore,Q_4_restore = estimation(P_4_real,Q_4_real,error)


# ### 10. Re-scale all loads initialization points (p,q), and get initial voltage from OpenDSS for different copies 1-10.

# In[11]:


###############################################################################
# Set different initialization points
D = 10
for LoadName, PhaseSet in Loads_1.items():
        NodeName = LoadToNode[LoadName]
        for H in range(0,D):
            NodeName = LoadToNode[LoadName]
            if len(PhaseSet) == 1:
                if H == 0:
                    LoadName_1 =  LoadName
                    NodeName_1 =  NodeName 
                else:
                    LoadName_1 = 'G' + str(H) + LoadName
                    NodeName_1 = 'G' + str(H) + NodeName                            
                P_1_restore[LoadName_1] = (1-H/3)*P_1_restore[LoadName_1]
                P_1[LoadName_1] = P_1_restore[LoadName_1]
                Q_1_restore[LoadName_1] = (1-H/3)*Q_1_restore[LoadName_1]
                Q_1[LoadName_1] = Q_1_restore[LoadName_1]
                command = "edit load." + LoadName_1 + " kw=" + str(P_1[LoadName_1]) + " kvar=" + str(Q_1[LoadName_1])
                dss.run_command(command)

for LoadName, PhaseSet in Loads_2.items():
        NodeName = LoadToNode[LoadName]
        for H in range(0,D):
            NodeName = LoadToNode[LoadName]
            if len(PhaseSet) == 1:
                if H == 0:
                    LoadName_1 =  LoadName
                    NodeName_1 =  NodeName 
                else:
                    LoadName_1 = 'G' + str(H) + LoadName
                    NodeName_1 = 'G' + str(H) + NodeName                            
                P_2_restore[LoadName_1] = (1-H/3)*P_2_restore[LoadName_1]
                P_2[LoadName_1] = P_2_restore[LoadName_1]
                Q_2_restore[LoadName_1] = (1-H/3)*Q_2_restore[LoadName_1]
                Q_2[LoadName_1] = Q_2_restore[LoadName_1]
                command = "edit load." + LoadName_1 + " kw=" + str(P_2[LoadName_1]) + " kvar=" + str(Q_2[LoadName_1])
                dss.run_command(command)
                
for LoadName, PhaseSet in Loads_3.items():
        NodeName = LoadToNode[LoadName]
        for H in range(0,D):
            NodeName = LoadToNode[LoadName]
            if len(PhaseSet) == 1:
                if H == 0:
                    LoadName_1 =  LoadName
                    NodeName_1 =  NodeName 
                else:
                    LoadName_1 = 'G' + str(H) + LoadName
                    NodeName_1 = 'G' + str(H) + NodeName                            
                P_3_restore[LoadName_1] = (1-H/3)*P_3_restore[LoadName_1]
                P_3[LoadName_1] = P_3_restore[LoadName_1]
                Q_3_restore[LoadName_1] = (1-H/3)*Q_3_restore[LoadName_1]
                Q_3[LoadName_1] = Q_3_restore[LoadName_1]
                command = "edit load." + LoadName_1 + " kw=" + str(P_3[LoadName_1]) + " kvar=" + str(Q_3[LoadName_1])
                dss.run_command(command)

for LoadName, PhaseSet in Loads_4.items():
        NodeName = LoadToNode[LoadName]
        for H in range(0,D):
            NodeName = LoadToNode[LoadName]
            if len(PhaseSet) == 1:
                if H == 0:
                    LoadName_1 =  LoadName
                    NodeName_1 =  NodeName 
                else:
                    LoadName_1 = 'G' + str(H) + LoadName
                    NodeName_1 = 'G' + str(H) + NodeName                            
                P_4_restore[LoadName_1] = (1-H/3)*P_4_restore[LoadName_1]
                P_4[LoadName_1] = P_4_restore[LoadName_1]
                Q_4_restore[LoadName_1] = (1-H/3)*Q_4_restore[LoadName_1]
                Q_4[LoadName_1] = Q_4_restore[LoadName_1]
                command = "edit load." + LoadName_1 + " kw=" + str(P_4[LoadName_1]) + " kvar=" + str(Q_4[LoadName_1])
                dss.run_command(command)

dss.run_command("Solve")
YVol = circuit.YNodeVArray()
AllNodeVoltage = Voltage(YVol,node_number)
AllNodeVoltage_initial = AllNodeVoltage

### save the value for future use
P_1_real,Q_1_real = getInitialPV(Loads_1)
P_2_real,Q_2_real = getInitialPV(Loads_2)
P_3_real,Q_3_real = getInitialPV(Loads_3)
P_4_real,Q_4_real = getInitialPV(Loads_4)

### get the estimation of (p,q) ____(estimateion,fix)
error = 0.5
P_1,Q_1,P_1_restore,Q_1_restore = estimation(P_1_real,Q_1_real,error)
P_2,Q_2,P_2_restore,Q_2_restore = estimation(P_2_real,Q_2_real,error)
P_3,Q_3,P_3_restore,Q_3_restore = estimation(P_3_real,Q_3_real,error)
P_4,Q_4,P_4_restore,Q_4_restore = estimation(P_4_real,Q_4_real,error)


# ### 11. Define a function to randomly place the sensors for voltage measurement.

# In[12]:


### Here, we add measurement function to have measurement data of voltage V_fix
from random import choices
###
def measureSet(ratio,G_1_1,G_1_2,G_1_3,G_2_1,G_2_2,G_2_3,G_3_1,G_3_2,G_3_3,G_4_1,G_4_2,G_4_3,K):
    Set_index = []
    for i in range(0,K):    
        num = int(len(G_1_1[i])*ratio)
        selected_set = choices(G_1_1[i],k=num)
        G_1_1[i] = selected_set
        for node in selected_set:
            name = node + '.1'
            index = NameToIndex[name]
            Set_index.append(index)
            
        num = int(len(G_1_2[i])*ratio)
        selected_set = choices(G_1_2[i],k=num)
        G_1_2[i] = selected_set
        for node in selected_set:
            name = node + '.2'
            index = NameToIndex[name]
            Set_index.append(index)
            
        num = int(len(G_1_3[i])*ratio)
        selected_set = choices(G_1_3[i],k=num)
        G_1_3[i] = selected_set
        for node in selected_set:
            name = node + '.3'
            index = NameToIndex[name]
            Set_index.append(index)

        num = int(len(G_2_1[i])*ratio)
        selected_set = choices(G_2_1[i],k=num)
        G_2_1[i] = selected_set
        for node in selected_set:
            name = node + '.1'
            index = NameToIndex[name]
            Set_index.append(index)
                
        num = int(len(G_2_2[i])*ratio)
        selected_set = choices(G_2_2[i],k=num)
        G_2_2[i] = selected_set
        for node in selected_set:
            name = node + '.2'
            index = NameToIndex[name]
            Set_index.append(index)
            
        num = int(len(G_2_3[i])*ratio)
        selected_set = choices(G_2_3[i],k=num)
        G_2_3[i] = selected_set
        for node in selected_set:
            name = node + '.3'
            index = NameToIndex[name]
            Set_index.append(index)
              
        num = int(len(G_3_1[i])*ratio)
        selected_set = choices(G_3_1[i],k=num)
        G_3_1[i] = selected_set
        for node in selected_set:
            name = node + '.1'
            index = NameToIndex[name]
            Set_index.append(index)
        
        num = int(len(G_3_2[i])*ratio)
        selected_set = choices(G_3_2[i],k=num)
        G_3_2[i] = selected_set
        for node in selected_set:
            name = node + '.2'
            index = NameToIndex[name]
            Set_index.append(index)
        
        num = int(len(G_3_3[i])*ratio)
        selected_set = choices(G_3_3[i],k=num)
        G_3_3[i] = selected_set
        for node in selected_set:
            name = node + '.3'
            index = NameToIndex[name]
            Set_index.append(index)
    
        num = int(len(G_4_1[i])*ratio)
        selected_set = choices(G_4_1[i],k=num)
        G_4_1[i] = selected_set
        for node in selected_set:
            name = node + '.1'
            index = NameToIndex[name]
            Set_index.append(index)
       
        num = int(len(G_4_2[i])*ratio)
        selected_set = choices(G_4_2[i],k=num)
        G_4_2[i] = selected_set
        for node in selected_set:
            name = node + '.2'
            index = NameToIndex[name]
            Set_index.append(index)
    
        num = int(len(G_4_3[i])*ratio)
        selected_set = choices(G_4_3[i],k=num)
        G_4_3[i] = selected_set
        for node in selected_set:
            name = node + '.3'
            index = NameToIndex[name]
            Set_index.append(index)
    return Set_index


# ### 12. Randomly place the voltage measurement sensor in a prescribed rato

# In[13]:


ratio = 0.1
error = 0.01
Set_index = measureSet(ratio,G_1_1,G_1_2,G_1_3,G_2_1,G_2_2,G_2_3,G_3_1,G_3_2,G_3_3,G_4_1,G_4_2,G_4_3,D)
for index in Set_index:
    V_fix[index] = AllNodeVoltage[index-1]*(1.0+np.random.normal(0,error,1))


# ### 13. Pick up points for convergence checks at each cluster for different group, 1-10.

# In[14]:


node_1 = G_1_1[0][3]
node_2 = G_2_1[0][3]
node_3 = G_3_1[0][3]
node_4 = G_4_1[0][3]
node_main= G_main_1[0][3]

node_21 = G_1_1[1][3]
node_22 = G_2_1[1][3]
node_23 = G_3_1[1][3]
node_24 = G_4_1[1][3]
node_2main= G_main_1[1][3]

node_31 = G_1_1[2][3]
node_32 = G_2_1[2][3]
node_33 = G_3_1[2][3]
node_34 = G_4_1[2][3]
node_3main= G_main_1[2][3]

node_41 = G_1_1[3][3]
node_42 = G_2_1[3][3]
node_43 = G_3_1[3][3]
node_44 = G_4_1[3][3]
node_4main= G_main_1[3][3]

node_51 = G_1_1[4][3]
node_52 = G_2_1[4][3]
node_53 = G_3_1[4][3]
node_54 = G_4_1[4][3]
node_5main= G_main_1[4][3]

node_61 = G_1_1[5][3]
node_62 = G_2_1[5][3]
node_63 = G_3_1[5][3]
node_64 = G_4_1[5][3]
node_6main= G_main_1[5][3]

node_71 = G_1_1[6][3]
node_72 = G_2_1[6][3]
node_73 = G_3_1[6][3]
node_74 = G_4_1[6][3]
node_7main= G_main_1[6][3]

node_81 = G_1_1[7][3]
node_82 = G_2_1[7][3]
node_83 = G_3_1[7][3]
node_84 = G_4_1[7][3]
node_8main= G_main_1[7][3]

node_91 = G_1_1[8][3]
node_92 = G_2_1[8][3]
node_93 = G_3_1[8][3]
node_94 = G_4_1[8][3]
node_9main= G_main_1[8][3]

node_01 = G_1_1[9][3]
node_02 = G_2_1[9][3]
node_03 = G_3_1[9][3]
node_04 = G_4_1[9][3]
node_0main= G_main_1[9][3]

### substract the index for selected Nodes
index_1 = NameToIndex[node_1+'.1']
index_2 = NameToIndex[node_2+'.1']
index_3 = NameToIndex[node_3+'.1']
index_4 = NameToIndex[node_4+'.1']
index_main = NameToIndex[node_main+'.1']

index_21 = NameToIndex[node_21+'.1']
index_22 = NameToIndex[node_22+'.1']
index_23 = NameToIndex[node_23+'.1']
index_24 = NameToIndex[node_24+'.1']
index_2main = NameToIndex[node_2main+'.1']

index_31 = NameToIndex[node_31+'.1']
index_32 = NameToIndex[node_32+'.1']
index_33 = NameToIndex[node_33+'.1']
index_34 = NameToIndex[node_34+'.1']
index_3main = NameToIndex[node_3main+'.1']

index_41 = NameToIndex[node_41+'.1']
index_42 = NameToIndex[node_42+'.1']
index_43 = NameToIndex[node_43+'.1']
index_44 = NameToIndex[node_44+'.1']
index_4main = NameToIndex[node_4main+'.1']

index_51 = NameToIndex[node_51+'.1']
index_52 = NameToIndex[node_52+'.1']
index_53 = NameToIndex[node_53+'.1']
index_54 = NameToIndex[node_54+'.1']
index_5main = NameToIndex[node_5main+'.1']

index_61 = NameToIndex[node_61+'.1']
index_62 = NameToIndex[node_62+'.1']
index_63 = NameToIndex[node_63+'.1']
index_64 = NameToIndex[node_64+'.1']
index_6main = NameToIndex[node_6main+'.1']

index_71 = NameToIndex[node_71+'.1']
index_72 = NameToIndex[node_72+'.1']
index_73 = NameToIndex[node_73+'.1']
index_74 = NameToIndex[node_74+'.1']
index_7main = NameToIndex[node_7main+'.1']

index_81 = NameToIndex[node_81+'.1']
index_82 = NameToIndex[node_82+'.1']
index_83 = NameToIndex[node_83+'.1']
index_84 = NameToIndex[node_84+'.1']
index_8main = NameToIndex[node_8main+'.1']

index_91 = NameToIndex[node_91+'.1']
index_92 = NameToIndex[node_92+'.1']
index_93 = NameToIndex[node_93+'.1']
index_94 = NameToIndex[node_94+'.1']
index_9main = NameToIndex[node_9main+'.1']

index_01 = NameToIndex[node_01+'.1']
index_02 = NameToIndex[node_02+'.1']
index_03 = NameToIndex[node_03+'.1']
index_04 = NameToIndex[node_04+'.1']
index_0main = NameToIndex[node_0main+'.1']


# ### 14. Define the project function and initialize the voltage storation.

# In[15]:




def project(num_p,num_q,ini_p,ini_q):
    p = 0
    q = 0
    if(ini_p > 0):
        p = min(max(num_p,0),coff*ini_p)
        q = min(max(num_q,0),coff*ini_q)
    else:
        p = max(min(num_p,0),coff*ini_p)
        q = max(min(num_q,0),coff*ini_q)
    return p,q

signal_1 = CalSignal(G_1)
signal_2 = CalSignal(G_2)
signal_3 = CalSignal(G_3)
signal_4 = CalSignal(G_4)

voltage_rec_1 = []
voltage_rec_2 = []
voltage_rec_3 = []
voltage_rec_4 = []
voltage_rec_main = []

voltage_rec_21 = []
voltage_rec_22 = []
voltage_rec_23 = []
voltage_rec_24 = []
voltage_rec_2main = []

voltage_rec_31 = []
voltage_rec_32 = []
voltage_rec_33 = []
voltage_rec_34 = []
voltage_rec_3main = []

voltage_rec_41 = []
voltage_rec_42 = []
voltage_rec_43 = []
voltage_rec_44 = []
voltage_rec_4main = []

voltage_rec_51 = []
voltage_rec_52 = []
voltage_rec_53 = []
voltage_rec_54 = []
voltage_rec_5main = []

voltage_rec_61 = []
voltage_rec_62 = []
voltage_rec_63 = []
voltage_rec_64 = []
voltage_rec_6main = []

voltage_rec_71 = []
voltage_rec_72 = []
voltage_rec_73 = []
voltage_rec_74 = []
voltage_rec_7main = []

voltage_rec_81 = []
voltage_rec_82 = []
voltage_rec_83 = []
voltage_rec_84 = []
voltage_rec_8main = []

voltage_rec_91 = []
voltage_rec_92 = []
voltage_rec_93 = []
voltage_rec_94 = []
voltage_rec_9main = []

voltage_rec_01 = []
voltage_rec_02 = []
voltage_rec_03 = []
voltage_rec_04 = []
voltage_rec_0main = []

signal_rec_1 = []
signal_rec_2 = []
signal_rec_3 = []
signal_rec_4 = []

#record_losspercent = [0]*iteration


# ### 15. Main iteration algorithms

# In[21]:


## This set only one feeder is connected
D = 1
print('The number of groups is ', D)
start = time.time()
#temp_load = 't21396254a'

iteration = 10
coff = 2.5
#step_mu = 3.5e-4
step_pq = 5e-8/ratio*2
#lambda_nes = 1
#gamma_nes = 0
print('The number of iteration is ', iteration)
print('Simulation start !')

for i in range(iteration):
    print('# of iteration is: ', i)   
#    lambda_nes_backup =  lambda_nes
#    lambda_nes = (1+math.sqrt(1+4*lambda_nes_backup**2))/2
#    gamma_nes = (1-lambda_nes_backup)/lambda_nes
    gamma_nes = 0
    for LoadName, PhaseSet in Loads_1.items():
        NodeName = LoadToNode[LoadName]
#        if len(PhaseSet) == 1:            
        for H in range(0,D):
            NodeName = LoadToNode[LoadName]
#                if len(PhaseSet) == 1:              
            phase = PhaseSet[0]
            inner_R,inner_X = CalInner(G_1[H],G_1_dic[H],LoadName,phase,G_1_1[H],G_1_2[H],G_1_3[H],H)
                    
            outter_R = 0
            coef  = cmathexp[0-phase]
            outter_R += coef*(signal_2[H][0]*G_12[phase,0] + signal_3[H][0]*G_13[phase,0] + signal_4[H][0]*G_14[phase,0])
                    #coef = cmath.exp(1j*2*math.pi*(phase-1)/3)
            coef  = cmathexp[1-phase]
            outter_R += coef*(signal_2[H][1]*G_12[phase,1] + signal_3[H][1]*G_13[phase,1] + signal_4[H][1]*G_14[phase,1])
                    #coef = cmath.exp(1j*2*math.pi*(phase-2)/3)
            coef  = cmathexp[2-phase]
            outter_R += coef*(signal_2[H][2]*G_12[phase,2] + signal_3[H][2]*G_13[phase,2] + signal_4[H][2]*G_14[phase,2])
                    #print("outter_R")
                    #print(outter_R)
            outter_R_sum = 2*outter_R.real
            outter_X_sum = -2*outter_R.imag 
                    #print("outter_R_sum,outter_X_sum")
                    #print(outter_R_sum,outter_X_sum)
            
            if H == 0:
                LoadName_1 =  LoadName
                NodeName_1 =  NodeName 
            else:
                LoadName_1 = 'G' + str(H) + LoadName
                NodeName_1 = 'G' + str(H) + NodeName 
                        
                        
            P_1[LoadName_1] = P_1[LoadName_1]- step_pq*((error/0.5)**2*(P_1[LoadName_1] - P_1_restore[LoadName_1])  - outter_R_sum - inner_R)
            Q_1[LoadName_1] = Q_1[LoadName_1]- step_pq*((error/0.5)**2*(Q_1[LoadName_1] - Q_1_restore[LoadName_1]) - outter_X_sum - inner_X)
            P_1[LoadName_1],Q_1[LoadName_1] = project(P_1[LoadName_1],Q_1[LoadName_1],P_1_restore[LoadName_1],Q_1_restore[LoadName_1])
            command = "edit load." + LoadName_1 + " kw=" + str(P_1[LoadName_1]) + " kvar=" + str(Q_1[LoadName_1])
            dss.run_command(command)

    for LoadName, PhaseSet in Loads_2.items():
        NodeName = LoadToNode[LoadName]
#        if len(PhaseSet) == 1:            
        for H in range(0,D):
            NodeName = LoadToNode[LoadName]
#                if len(PhaseSet) == 1:              
            phase = PhaseSet[0]
            inner_R,inner_X = CalInner(G_2[H],G_2_dic[H],LoadName,phase,G_2_1[H],G_2_2[H],G_2_3[H],H)
                    
            outter_R = 0
                    #coef = cmath.exp(1j*2*math.pi*(phase-0)/3)
            coef  = cmathexp[0-phase]
                    #print(signal_2)
                    #print(coef,signal_2[phase],G_12[phase,0])
            outter_R += coef*(signal_1[H][0]*G_12[phase,0] + signal_3[H][0]*G_23[phase,0] + signal_4[H][0]*G_24[phase,0])
                    #coef = cmath.exp(1j*2*math.pi*(phase-1)/3)
            coef  = cmathexp[1-phase]
            outter_R += coef*(signal_1[H][1]*G_12[phase,1] + signal_3[H][1]*G_23[phase,1] + signal_4[H][1]*G_24[phase,1])
                    #coef = cmath.exp(1j*2*math.pi*(phase-2)/3)
            coef  = cmathexp[2-phase]
            outter_R += coef*(signal_1[H][2]*G_12[phase,2] + signal_3[H][2]*G_23[phase,2] + signal_4[H][2]*G_24[phase,2])
                    #print("outter_R")
                    #print(outter_R)
            outter_R_sum = 2*outter_R.real
            outter_X_sum = -2*outter_R.imag 
                    #print("outter_R_sum,outter_X_sum")
                    #print(outter_R_sum,outter_X_sum)
            
            if H == 0:
                LoadName_1 =  LoadName
                NodeName_1 =  NodeName 
            else:
                LoadName_1 = 'G' + str(H) + LoadName
                NodeName_1 = 'G' + str(H) + NodeName 
                        
            P_2[LoadName_1] = P_2[LoadName_1]- step_pq*((error/0.5)**2*(P_2[LoadName_1] - P_2_restore[LoadName_1])  - outter_R_sum - inner_R)
            Q_2[LoadName_1] = Q_2[LoadName_1]- step_pq*((error/0.5)**2*(Q_2[LoadName_1] - Q_2_restore[LoadName_1]) - outter_X_sum - inner_X)
            P_2[LoadName_1],Q_2[LoadName_1] = project(P_2[LoadName_1],Q_2[LoadName_1],P_2_restore[LoadName_1],Q_2_restore[LoadName_1])
            command = "edit load." + LoadName_1 + " kw=" + str(P_2[LoadName_1]) + " kvar=" + str(Q_2[LoadName_1])
            dss.run_command(command)

    for LoadName, PhaseSet in Loads_3.items():
        NodeName = LoadToNode[LoadName]
#        if len(PhaseSet) == 1:            
        for H in range(0,D):
            NodeName = LoadToNode[LoadName]
#                if len(PhaseSet) == 1:              
            phase = PhaseSet[0]
            inner_R,inner_X = CalInner(G_3[H],G_3_dic[H],LoadName,phase,G_3_1[H],G_3_2[H],G_3_3[H],H)
                    
            outter_R = 0
                    #coef = cmath.exp(1j*2*math.pi*(phase-0)/3)
            coef  = cmathexp[0-phase]
                    #print(signal_2)
                    #print(coef,signal_2[phase],G_12[phase,0])
            outter_R += coef*(signal_1[H][0]*G_13[phase,0] + signal_2[H][0]*G_23[phase,0] + signal_4[H][0]*G_34[phase,0])
                    #coef = cmath.exp(1j*2*math.pi*(phase-1)/3)
            coef  = cmathexp[1-phase]
            outter_R += coef*(signal_1[H][1]*G_13[phase,1] + signal_2[H][1]*G_23[phase,1] + signal_4[H][1]*G_34[phase,1])
                    #coef = cmath.exp(1j*2*math.pi*(phase-2)/3)
            coef  = cmathexp[2-phase]
            outter_R += coef*(signal_1[H][2]*G_13[phase,2] + signal_2[H][2]*G_23[phase,2] + signal_4[H][2]*G_34[phase,2])
                    #print("outter_R")
                    #print(outter_R)
            outter_R_sum = 2*outter_R.real
            outter_X_sum = -2*outter_R.imag 
                    #print("outter_R_sum,outter_X_sum")
                    #print(outter_R_sum,outter_X_sum)
            
            if H == 0:
                LoadName_1 =  LoadName
                NodeName_1 =  NodeName 
            else:
                LoadName_1 = 'G' + str(H) + LoadName
                NodeName_1 = 'G' + str(H) + NodeName 
                            
            P_3[LoadName_1] = P_3[LoadName_1]- step_pq*((error/0.5)**2*(P_3[LoadName_1] - P_3_restore[LoadName_1])  - outter_R_sum - inner_R)
            Q_3[LoadName_1] = Q_3[LoadName_1]- step_pq*((error/0.5)**2*(Q_3[LoadName_1] - Q_3_restore[LoadName_1]) - outter_X_sum - inner_X)
            P_3[LoadName_1],Q_3[LoadName_1] = project(P_3[LoadName_1],Q_3[LoadName_1],P_3_restore[LoadName_1],Q_3_restore[LoadName_1])
            command = "edit load." + LoadName_1 + " kw=" + str(P_3[LoadName_1]) + " kvar=" + str(Q_3[LoadName_1])
            dss.run_command(command)
            
    for LoadName, PhaseSet in Loads_4.items():
        NodeName = LoadToNode[LoadName]
#        if len(PhaseSet) == 1:            
        for H in range(0,D):
            NodeName = LoadToNode[LoadName]
#                if len(PhaseSet) == 1:              
            phase = PhaseSet[0]
            inner_R,inner_X = CalInner(G_4[H],G_4_dic[H],LoadName,phase,G_4_1[H],G_4_2[H],G_4_3[H],H)
            outter_R = 0
                    #coef = cmath.exp(1j*2*math.pi*(phase-0)/3)
            coef  = cmathexp[0-phase]
                    #print(signal_2)
                    #print(coef,signal_2[phase],G_12[phase,0])
            outter_R += coef*(signal_1[H][0]*G_14[phase,0] + signal_2[H][0]*G_24[phase,0] + signal_3[H][0]*G_34[phase,0])
                    #coef = cmath.exp(1j*2*math.pi*(phase-1)/3)
            coef  = cmathexp[1-phase]
            outter_R += coef*(signal_1[H][1]*G_14[phase,1] + signal_2[H][1]*G_24[phase,1] + signal_3[H][1]*G_34[phase,1])
                    #coef = cmath.exp(1j*2*math.pi*(phase-2)/3)
            coef  = cmathexp[2-phase]
            outter_R += coef*(signal_1[H][2]*G_14[phase,2] + signal_2[H][2]*G_24[phase,2] + signal_3[H][2]*G_34[phase,2])
                    #print("outter_R")
                    #print(outter_R)
            outter_R_sum = 2*outter_R.real
            outter_X_sum = -2*outter_R.imag 
                    #print("outter_R_sum,outter_X_sum")
                    #print(outter_R_sum,outter_X_sum)
            
            if H == 0:
                LoadName_1 =  LoadName
                NodeName_1 =  NodeName 
            else:
                LoadName_1 = 'G' + str(H) + LoadName
                NodeName_1 = 'G' + str(H) + NodeName 
                        
            P_4[LoadName_1] = P_4[LoadName_1]- step_pq*((error/0.5)**2*(P_4[LoadName_1] - P_4_restore[LoadName_1])  - outter_R_sum - inner_R)
            Q_4[LoadName_1] = Q_4[LoadName_1]- step_pq*((error/0.5)**2*(Q_4[LoadName_1] - Q_4_restore[LoadName_1]) - outter_X_sum - inner_X)
            P_4[LoadName_1],Q_4[LoadName_1] = project(P_4[LoadName_1],Q_4[LoadName_1],P_4_restore[LoadName_1],Q_4_restore[LoadName_1])
            command = "edit load." + LoadName_1 + " kw=" + str(P_4[LoadName_1]) + " kvar=" + str(Q_4[LoadName_1])
            dss.run_command(command)

    dss.run_command("Solve")
    YVol = circuit.YNodeVArray()
    AllNodeVoltage = Voltage(YVol,node_number)
    for j in range(node_number):
        V_est[j+1] = AllNodeVoltage[j]
    
    signal_1 = CalSignal(G_1)
    signal_2 = CalSignal(G_2)
    signal_3 = CalSignal(G_3)
    signal_4 = CalSignal(G_4)

    voltage_rec_1.append(AllNodeVoltage[index_1-1]/VBase[index_1-1])
    voltage_rec_2.append(AllNodeVoltage[index_2-1]/VBase[index_2-1])
    voltage_rec_3.append(AllNodeVoltage[index_3-1]/VBase[index_3-1])
    voltage_rec_4.append(AllNodeVoltage[index_4-1]/VBase[index_4-1])
    voltage_rec_main.append(AllNodeVoltage[index_main-1]/VBase[index_main-1])
    
    voltage_rec_21.append(AllNodeVoltage[index_21-1]/VBase[index_21-1])
    voltage_rec_22.append(AllNodeVoltage[index_22-1]/VBase[index_22-1])
    voltage_rec_23.append(AllNodeVoltage[index_23-1]/VBase[index_23-1])
    voltage_rec_24.append(AllNodeVoltage[index_24-1]/VBase[index_24-1])
    voltage_rec_2main.append(AllNodeVoltage[index_2main-1]/VBase[index_2main-1])

    voltage_rec_31.append(AllNodeVoltage[index_31-1]/VBase[index_31-1])
    voltage_rec_32.append(AllNodeVoltage[index_32-1]/VBase[index_32-1])
    voltage_rec_33.append(AllNodeVoltage[index_33-1]/VBase[index_33-1])
    voltage_rec_34.append(AllNodeVoltage[index_34-1]/VBase[index_34-1])
    voltage_rec_3main.append(AllNodeVoltage[index_3main-1]/VBase[index_3main-1])

    voltage_rec_41.append(AllNodeVoltage[index_41-1]/VBase[index_41-1])
    voltage_rec_42.append(AllNodeVoltage[index_42-1]/VBase[index_42-1])
    voltage_rec_43.append(AllNodeVoltage[index_43-1]/VBase[index_43-1])
    voltage_rec_44.append(AllNodeVoltage[index_44-1]/VBase[index_44-1])
    voltage_rec_4main.append(AllNodeVoltage[index_4main-1]/VBase[index_4main-1])
    
    voltage_rec_51.append(AllNodeVoltage[index_51-1]/VBase[index_51-1])
    voltage_rec_52.append(AllNodeVoltage[index_52-1]/VBase[index_52-1])
    voltage_rec_53.append(AllNodeVoltage[index_53-1]/VBase[index_53-1])
    voltage_rec_54.append(AllNodeVoltage[index_54-1]/VBase[index_54-1])
    voltage_rec_5main.append(AllNodeVoltage[index_5main-1]/VBase[index_5main-1])    

    voltage_rec_61.append(AllNodeVoltage[index_61-1]/VBase[index_61-1])
    voltage_rec_62.append(AllNodeVoltage[index_62-1]/VBase[index_62-1])
    voltage_rec_63.append(AllNodeVoltage[index_63-1]/VBase[index_63-1])
    voltage_rec_64.append(AllNodeVoltage[index_64-1]/VBase[index_64-1])
    voltage_rec_6main.append(AllNodeVoltage[index_6main-1]/VBase[index_6main-1])
    
    voltage_rec_71.append(AllNodeVoltage[index_71-1]/VBase[index_71-1])
    voltage_rec_72.append(AllNodeVoltage[index_72-1]/VBase[index_72-1])
    voltage_rec_73.append(AllNodeVoltage[index_73-1]/VBase[index_73-1])
    voltage_rec_74.append(AllNodeVoltage[index_74-1]/VBase[index_74-1])
    voltage_rec_7main.append(AllNodeVoltage[index_7main-1]/VBase[index_7main-1])    

    voltage_rec_81.append(AllNodeVoltage[index_81-1]/VBase[index_81-1])
    voltage_rec_82.append(AllNodeVoltage[index_82-1]/VBase[index_82-1])
    voltage_rec_83.append(AllNodeVoltage[index_83-1]/VBase[index_83-1])
    voltage_rec_84.append(AllNodeVoltage[index_84-1]/VBase[index_84-1])
    voltage_rec_8main.append(AllNodeVoltage[index_8main-1]/VBase[index_8main-1])

    voltage_rec_91.append(AllNodeVoltage[index_91-1]/VBase[index_91-1])
    voltage_rec_92.append(AllNodeVoltage[index_92-1]/VBase[index_92-1])
    voltage_rec_93.append(AllNodeVoltage[index_93-1]/VBase[index_93-1])
    voltage_rec_94.append(AllNodeVoltage[index_94-1]/VBase[index_94-1])
    voltage_rec_9main.append(AllNodeVoltage[index_9main-1]/VBase[index_9main-1])

    voltage_rec_01.append(AllNodeVoltage[index_01-1]/VBase[index_01-1])
    voltage_rec_02.append(AllNodeVoltage[index_02-1]/VBase[index_02-1])
    voltage_rec_03.append(AllNodeVoltage[index_03-1]/VBase[index_03-1])
    voltage_rec_04.append(AllNodeVoltage[index_04-1]/VBase[index_04-1])
    voltage_rec_0main.append(AllNodeVoltage[index_0main-1]/VBase[index_0main-1])


    signal_rec_1.append(signal_1)
    signal_rec_2.append(signal_2)
    signal_rec_3.append(signal_3)
    signal_rec_4.append(signal_4)

end = time.time()
print('Simulation ends!')
print('------------------------------------')
print('Simulation time is', end-start,'s')





# ### 16. Figure plot section

# In[17]:


timeLine = list(range(iteration))
plt.rcParams.update({'font.size':15})

timeLine = list(range(iteration))
plt.rcParams.update({'font.size':15})

plt.figure(1)
plot_v_1=plt.plot(timeLine, voltage_rec_1,'red')
plot_v_2=plt.plot(timeLine, voltage_rec_2,'green')
plot_v_3=plt.plot(timeLine, voltage_rec_3,'yellow')
plot_v_4=plt.plot(timeLine, voltage_rec_4,'black')
#plot_v_main=plt.plot(timeLine, voltage_rec_main,'black')

plt.xlabel('Iteration number')
plt.ylabel('Voltage magnitude, p.u.')
plt.title('Voltage Convergence 1')
plt.grid(True)
plt.xlim((0, iteration-1))   # set the xlim to xmin, xmax
plt.ylim((0.80, 1.50)) 
plt.legend((plot_v_1[0], plot_v_2[0],plot_v_3[0], plot_v_4[0]), ('AG 1', 'AG 2','AG 3','AG 4'))
#plt.savefig('../python_110000/Result1.pdf')
#plt.ylim(1, 1.05)


#plt.figure(2)
#plot_v_21=plt.plot(timeLine, voltage_rec_21,'red')
#plot_v_22=plt.plot(timeLine, voltage_rec_22,'green')
#plot_v_23=plt.plot(timeLine, voltage_rec_23,'yellow')
#plot_v_24=plt.plot(timeLine, voltage_rec_24,'black')
##plot_v_main=plt.plot(timeLine, voltage_rec_main,'black')
#
#plt.xlabel('Iteration number')
#plt.ylabel('Voltage magnitude, p.u.')
#plt.title('Voltage Convergence 2')
#plt.grid(True)
#plt.xlim((0, iteration-1))   # set the xlim to xmin, xmax
#plt.ylim((0.80, 1.50)) 
#plt.legend((plot_v_21[0], plot_v_22[0],plot_v_23[0], plot_v_24[0]), ('AG 1', 'AG 2','AG 3','AG 4'))
##plt.savefig('../python_110000/Result1.pdf')
##plt.ylim(1, 1.05)
#
#
#plt.figure(3)
#plot_v_31=plt.plot(timeLine, voltage_rec_31,'red')
#plot_v_32=plt.plot(timeLine, voltage_rec_32,'green')
#plot_v_33=plt.plot(timeLine, voltage_rec_33,'yellow')
#plot_v_34=plt.plot(timeLine, voltage_rec_34,'black')
##plot_v_main=plt.plot(timeLine, voltage_rec_main,'black')
#
#plt.xlabel('Iteration number')
#plt.ylabel('Voltage magnitude, p.u.')
#plt.title('Voltage Convergence 3')
#plt.grid(True)
#plt.xlim((0, iteration-1))   # set the xlim to xmin, xmax
#plt.ylim((0.80, 1.50)) 
#plt.legend((plot_v_31[0], plot_v_32[0],plot_v_33[0], plot_v_34[0]), ('AG 1', 'AG 2','AG 3','AG 4'))
##plt.savefig('../python_110000/Result1.pdf')
##plt.ylim(1, 1.05)
#
#
#plt.figure(4)
#plot_v_41=plt.plot(timeLine, voltage_rec_41,'red')
#plot_v_42=plt.plot(timeLine, voltage_rec_42,'green')
#plot_v_43=plt.plot(timeLine, voltage_rec_43,'yellow')
#plot_v_44=plt.plot(timeLine, voltage_rec_44,'black')
##plot_v_main=plt.plot(timeLine, voltage_rec_main,'black')
#
#plt.xlabel('Iteration number')
#plt.ylabel('Voltage magnitude, p.u.')
#plt.title('Voltage Convergence 4')
#plt.grid(True)
#plt.xlim((0, iteration-1))   # set the xlim to xmin, xmax
#plt.ylim((0.80, 1.50)) 
#plt.legend((plot_v_41[0], plot_v_42[0],plot_v_43[0], plot_v_44[0]), ('AG 1', 'AG 2','AG 3','AG 4'))
##plt.savefig('../python_110000/Result1.pdf')
##plt.ylim(1, 1.05)
#
#
#plt.figure(5)
#plot_v_51=plt.plot(timeLine, voltage_rec_51,'red')
#plot_v_52=plt.plot(timeLine, voltage_rec_52,'green')
#plot_v_53=plt.plot(timeLine, voltage_rec_53,'yellow')
#plot_v_54=plt.plot(timeLine, voltage_rec_54,'black')
##plot_v_main=plt.plot(timeLine, voltage_rec_main,'black')
#
#plt.xlabel('Iteration number')
#plt.ylabel('Voltage magnitude, p.u.')
#plt.title('Voltage Convergence 5')
#plt.grid(True)
#plt.xlim((0, iteration-1))   # set the xlim to xmin, xmax
#plt.ylim((0.80, 1.50)) 
#plt.legend((plot_v_51[0], plot_v_52[0],plot_v_53[0], plot_v_54[0]), ('AG 1', 'AG 2','AG 3','AG 4'))
##plt.savefig('../python_110000/Result1.pdf')
##plt.ylim(1, 1.05)
#
#
#plt.figure(6)
#plot_v_61=plt.plot(timeLine, voltage_rec_61,'red')
#plot_v_62=plt.plot(timeLine, voltage_rec_62,'green')
#plot_v_63=plt.plot(timeLine, voltage_rec_63,'yellow')
#plot_v_64=plt.plot(timeLine, voltage_rec_64,'black')
##plot_v_main=plt.plot(timeLine, voltage_rec_main,'black')
#
#plt.xlabel('Iteration number')
#plt.ylabel('Voltage magnitude, p.u.')
#plt.title('Voltage Convergence 6')
#plt.grid(True)
#plt.xlim((0, iteration-1))   # set the xlim to xmin, xmax
#plt.ylim((0.80, 1.50)) 
#plt.legend((plot_v_61[0], plot_v_62[0],plot_v_63[0], plot_v_64[0]), ('AG 1', 'AG 2','AG 3','AG 4'))
##plt.savefig('../python_110000/Result1.pdf')
##plt.ylim(1, 1.05)
#
#
#plt.figure(7)
#plot_v_71=plt.plot(timeLine, voltage_rec_71,'red')
#plot_v_72=plt.plot(timeLine, voltage_rec_72,'green')
#plot_v_73=plt.plot(timeLine, voltage_rec_73,'yellow')
#plot_v_74=plt.plot(timeLine, voltage_rec_74,'black')
##plot_v_main=plt.plot(timeLine, voltage_rec_main,'black')
#
#plt.xlabel('Iteration number')
#plt.ylabel('Voltage magnitude, p.u.')
#plt.title('Voltage Convergence 7')
#plt.grid(True)
#plt.xlim((0, iteration-1))   # set the xlim to xmin, xmax
#plt.ylim((0.80, 1.50)) 
#plt.legend((plot_v_71[0], plot_v_72[0],plot_v_73[0], plot_v_74[0]), ('AG 1', 'AG 2','AG 3','AG 4'))
##plt.savefig('../python_110000/Result1.pdf')
##plt.ylim(1, 1.05)
#
#
#plt.figure(8)
#plot_v_81=plt.plot(timeLine, voltage_rec_81,'red')
#plot_v_82=plt.plot(timeLine, voltage_rec_82,'green')
#plot_v_83=plt.plot(timeLine, voltage_rec_83,'yellow')
#plot_v_84=plt.plot(timeLine, voltage_rec_84,'black')
##plot_v_main=plt.plot(timeLine, voltage_rec_main,'black')
#
#plt.xlabel('Iteration number')
#plt.ylabel('Voltage magnitude, p.u.')
#plt.title('Voltage Convergence 8')
#plt.grid(True)
#plt.xlim((0, iteration-1))   # set the xlim to xmin, xmax
#plt.ylim((0.80, 1.50)) 
#plt.legend((plot_v_81[0], plot_v_82[0],plot_v_83[0], plot_v_84[0]), ('AG 1', 'AG 2','AG 3','AG 4'))
##plt.savefig('../python_110000/Result1.pdf')
##plt.ylim(1, 1.05)
#
#plt.figure(9)
#plot_v_91=plt.plot(timeLine, voltage_rec_91,'red')
#plot_v_92=plt.plot(timeLine, voltage_rec_92,'green')
#plot_v_93=plt.plot(timeLine, voltage_rec_93,'yellow')
#plot_v_94=plt.plot(timeLine, voltage_rec_94,'black')
##plot_v_main=plt.plot(timeLine, voltage_rec_main,'black')
#
#plt.xlabel('Iteration number')
#plt.ylabel('Voltage magnitude, p.u.')
#plt.title('Voltage Convergence 9')
#plt.grid(True)
#plt.xlim((0, iteration-1))   # set the xlim to xmin, xmax
#plt.ylim((0.80, 1.50)) 
#plt.legend((plot_v_91[0], plot_v_92[0],plot_v_93[0], plot_v_94[0]), ('AG 1', 'AG 2','AG 3','AG 4'))
##plt.savefig('../python_110000/Result1.pdf')
##plt.ylim(1, 1.05)
#
#
#plt.figure(10)
#plot_v_01=plt.plot(timeLine, voltage_rec_01,'red')
#plot_v_02=plt.plot(timeLine, voltage_rec_02,'green')
#plot_v_03=plt.plot(timeLine, voltage_rec_03,'yellow')
#plot_v_04=plt.plot(timeLine, voltage_rec_04,'black')


#plot_v_main=plt.plot(timeLine, voltage_rec_main,'black')

#plt.xlabel('Iteration number')
#plt.ylabel('Voltage magnitude, p.u.')
#plt.title('Voltage Convergence 10')
#plt.grid(True)
#plt.xlim((0, iteration-1))   # set the xlim to xmin, xmax
#plt.ylim((0.80, 1.50)) 
#plt.legend((plot_v_01[0], plot_v_02[0],plot_v_03[0], plot_v_04[0]), ('AG 1', 'AG 2','AG 3','AG 4'))
##plt.savefig('../python_110000/Result1.pdf')
##plt.ylim(1, 1.05)


plt.figure(11)
length = len(AllNodeNames)
timeLine = list(range(length))
unit_voltage = []
unit_voltage_initial = []
plt.figure(figsize=(20,10))
#unit_voltage_regulator = []
for node in range(45153):
    unit_voltage.append(AllNodeVoltage[node]/VBase[node])
    unit_voltage_initial.append(AllNodeVoltage_initial[node]/VBase[node])
#    unit_voltage_regulator.append(AllNodeVoltage_regulator[node]/VBase[node])
plot_vc_1=plt.scatter(timeLine,unit_voltage_initial,s=20)
#plot_vc_2=plt.scatter(timeLine,unit_voltage_regulator,s=10)
plot_vc_3=plt.scatter(timeLine,unit_voltage,s=10)
#for i in range(len(unit_voltage)):
#    if unit_voltage[i]<0.95:
#        print("error")
#        print(unit_voltage[i])    
plt.xlabel('Node index on primary side')
plt.ylabel('Voltage magnitude, p.u.')
plt.title('Voltage Estimation')
plt.grid(True)
plt.legend((plot_vc_1, plot_vc_3), ('Real voltage', 'Estimated voltage'))
#plt.legend((plot_vc_1, plot_vc_2,plot_vc_3), ('Voltage w/o control', 'Voltage w/ default control','Voltage w/ OPF control'))
plt.xlim((0, 45152))
plt.savefig('../python/Result3.pdf')



## Print out error values

V_real  = [0]*(node_number+1)
for index in range(node_number):
    V_est[index+1] = V_est[index+1]/VBase[index]
    V_real[index+1] = AllNodeVoltage_initial[index]/VBase[index]
error_sum = 0
SE_error = []
for index in range(node_number):
    error_temp = abs((V_est[index+1]-V_real[index+1])/V_real[index+1])
    error_sum += error_temp
    SE_error.append(error_temp)
#    print(val_v[index],v_real[index])
error_ave = error_sum/node_number
error_max = max(SE_error)
print("result")
print("average error = ")
print(error_ave)
print("maximum error = ")
print(error_max)



