clear;
pct_p = 0.3;
pct_s = 0.9;
fid_stg1_rslt = fopen("Dd_EXP_POWERS_130.CSV");
% read in alphas from the results of control on 1st stage
count =0;
line_ex = fgetl(fid_stg1_rslt);    % read line excluding newline character; char
i = 0;
pf =[];
while line_ex ~= -1
    count = count +1;
    
    line = strrep(line_ex,'"'," "); % replace " in the line
    % if it is a DG
    if contains( line,"Generic5." ) 
        i = i+1;
        line = strip(line);% strip spaces on both ends
        pst = strfind(line,',') ;
        line = char(line);    
        dg_name(i) = strip( string( line(1 : pst(1)-1) ) );
        p = -1*sscanf(line(pst(2)+1 : pst(3)-1),'%f');
        q = -1*sscanf(line(pst(3)+1 : length(line)),'%f');
        
        if p > eps
            pf(i) = q/p;
        else
            pf(i) = 0;
        end
    end
    dgs_alfa = i;
    line_ex = fgetl(fid_stg1_rslt);    % read line excluding newline character; char
end
fclose(fid_stg1_rslt);
%%

feeder = 2 % for feeder 2
        % secondary side
    scd_old_nm  = "DGDef_SecondaryDGAfterSecond_"+string(feeder)+".dss"
    scd_new_nm   = "DGDef_SecondaryDG_pq_"+string(feeder)+".dss"
    pri_old_nm = "DGDef_PrimaryPVAfterSecondStage_"+string(feeder)+".dss"
    pri_new_nm = "DGDef_PrimaryDG_pq_"+string(feeder)+".dss"
        
        fid_2_a = fopen(scd_old_nm);
        fid_2_pq = fopen(scd_new_nm,"w");
        count =0;
        i_new = 0;

        line_ex = fgetl(fid_2_a);
        while line_ex ~= -1
            count = count +1;
            if contains( line_ex,'Generic5.' ) 

                line = lower(line_ex); % lower case 
                for i=1:1:5
                    line = strrep(line," =","=");
                    line = strrep(line,"= ","=");
                end
                line = strrep(line,'"'," "); % replace " in the line
                line = strip(line);% strip spaces on both ends

                c_arry = char(line);
                len = length(c_arry);
                % find the DG name and primary-side dg name
                pst = strfind(c_arry,'generic5.') ;  % assume there are 2 the other is the secondary
                pst_sps = strfind(c_arry(pst(1):len)," ");
                name = string(c_arry(pst(1):pst_sps(1)-1));
                pri_name = string(c_arry(pst(2):len));
                % find the real power 
                pst = strfind(c_arry,'p_refkw=') ;  % assume there are 2 the other is the secondary
                pst_sps = strfind(c_arry(pst(1):len)," ");
                pref = sscanf(c_arry(pst(1)+8:pst(1) + pst_sps(1)-1),'%f');
                % calculate reactive power
                for i = 1:1:dgs_alfa   % check alfa array
                    if contains( line,lower(dg_name(i)))
                       if or(lower(dg_name(i))==lower('Generic5.PVs_ncctt257'),lower(dg_name(i)) == lower('Generic5.PVs_ncctt2542'))
                            qref = pf(i) * pref* pct_p*9;
                       else
                            qref = pf(i) * pref*pct_s ;
                       end
                       str_Qref = 'q_refkvar='+string(qref);

                        new_line = strrep(line,"dg="+pri_name, "");
                        %new_line = strrep(new_line,, "");

                        new_line = strrep(new_line,"q_refkvar=0", str_Qref);

                        new_line = strrep(new_line,"qv_flag=1","QV_flag=0");
                        new_line = strrep(new_line,"cc_switch=t","cc_switch=f");               

                        % write in the new definition file
                        new_line = string(new_line) +"\n";
                        fprintf(fid_2_pq,new_line);
                        i_new = i_new+1; % count DGs in old file
                        break;
                    end
                end

            end
            line_ex = fgetl(fid_2_a);  % read line excluding newline character
        end

        fclose(fid_2_a);
        fclose(fid_2_pq);
        fprintf('secondary side: %i old dgs in file\n', count);
        fprintf('secondary side: %i new dgs defined\n', i_new);
        %%
        % primary side definition
        fid_1_a  = fopen(pri_old_nm);
        fid_1_pq  = fopen(pri_new_nm,'w');
        count =0;
        i_new = 0;

        line_ex = fgetl(fid_1_a);
        while line_ex ~= -1
            count = count +1;
            if contains( line_ex,'Generic5.' ) 

                line = lower(line_ex); % lower case 
                for i=1:1:5
                    line = strrep(line," =","=");
                    line = strrep(line,"= ","=");
                end
                line = strrep(line,'"'," "); % replace " in the line
                line = strip(line);% strip spaces on both ends

                c_arry = char(line);
                len = length(c_arry);
                % find the DG name 
                pst = strfind(c_arry,'generic5.') ;  % assume there are 2 the other is the secondary
                pst_sps = strfind(c_arry(pst(1):len)," ");
                name = string(c_arry(pst(1):pst_sps(1)-1));
                % find the real power 
                pst = strfind(c_arry,'p_refkw=') ;  % assume there are 2 the other is the secondary
                pst_sps = strfind(c_arry(pst(1):len)," ");
                pref = sscanf(c_arry(pst(1)+8:pst(1) + pst_sps(1)-1),'%f');
                % calculate reactive power
                for i = 1:1:dgs_alfa   % check alfa array
                    if contains( line,lower(dg_name(i)))
                        qref = pf(i) * pref* pct_p;
                        str_Qref = 'q_refkvar='+string(qref);

                        new_line = strrep(line,"q_refkvar=0", str_Qref);

                        new_line = strrep(new_line,"qv_flag=1","QV_flag=1");
                        new_line = strrep(new_line,"cc_switch=t","cc_switch=t");               

                        % write in the new definition file
                        new_line = string(new_line) +"\n";
                        fprintf(fid_2_pq,new_line);
                        i_new = i_new+1; % count DGs in old file
                        break;
                    end
                end

            end
            line_ex = fgetl(fid_1_a);  % read line excluding newline character
        end

        fclose(fid_1_a);
        fclose(fid_1_pq);
        fprintf('Primary side: %i old dgs in file\n', count);
        fprintf('Primary side: %i new dgs defined\n', i_new);
